/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardSelectionPage;
import org.eclipse.ui.internal.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public abstract class WorkbenchWizardListSelectionPage
extends WorkbenchWizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private String message;
    private static final String STORE_SELECTED_WIZARD_ID = "WizardListSelectionPage.STORE_SELECTED_WIZARD_ID";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_LISTS_WIDTH = 150;

    protected WorkbenchWizardListSelectionPage(IWorkbench aWorkbench, IStructuredSelection currentSelection, AdaptableList wizardElements, String message) {
        super("singleWizardSelectionPage", aWorkbench, currentSelection, wizardElements);
        this.setDescription(WorkbenchMessages.getString("WizardList.description"));
        this.message = message;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(272));
        outerContainer.setFont(font);
        Label messageLabel = new Label(outerContainer, 0);
        messageLabel.setText(this.message);
        messageLabel.setFont(font);
        Table table = new Table(outerContainer, 2048);
        GridData data = new GridData(1808);
        int availableRows = DialogUtil.availableRows(parent);
        data.heightHint = availableRows > 50 ? 200 : availableRows * 3;
        table.setLayoutData((Object)data);
        table.setFont(font);
        this.wizardSelectionViewer = new TableViewer(table);
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.wizardSelectionViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.wizardSelectionViewer.setInput((Object)this.wizardElements);
        this.restoreWidgetValues();
        this.setControl((Control)outerContainer);
    }

    protected abstract IWizardNode createWizardNode(WorkbenchWizardElement var1);

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, this.wizardSelectionViewer.getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    private void restoreWidgetValues() {
        String wizardId = this.getDialogSettings().get(STORE_SELECTED_WIZARD_ID);
        WorkbenchWizardElement wizard = this.findWizard(wizardId);
        if (wizard == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)wizard);
        this.wizardSelectionViewer.setSelection((ISelection)selection);
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, (ISelection)selection));
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        IStructuredSelection sel = (IStructuredSelection)this.wizardSelectionViewer.getSelection();
        if (sel.size() > 0) {
            WorkbenchWizardElement selectedWizard = (WorkbenchWizardElement)sel.getFirstElement();
            settings.put(STORE_SELECTED_WIZARD_ID, selectedWizard.getID());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        WorkbenchWizardElement currentWizardSelection = (WorkbenchWizardElement)selection.getFirstElement();
        if (currentWizardSelection == null) {
            this.setMessage(null);
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(currentWizardSelection));
        this.setMessage(currentWizardSelection.getDescription());
    }
}

