/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.misc.ActivatorBarLayout;
import org.eclipse.ui.internal.misc.ActivatorItem;
import org.eclipse.ui.internal.misc.ItemListener;

public class ActivatorBar
extends Canvas
implements PaintListener {
    private ActivatorItem activeItem = null;
    private ItemListener listener;
    private ArrayList items = new ArrayList(5);

    public ActivatorBar(Composite parent) {
        super(parent, 0);
        this.addPaintListener(this);
        this.setLayout(new ActivatorBarLayout());
    }

    protected void addItem(ActivatorItem item) {
        this.items.add(item);
        this.layout();
    }

    public void addItemListener(ItemListener listener) {
        this.listener = listener;
    }

    public ActivatorItem getItem(int nX) {
        return (ActivatorItem)((Object)this.items.get(nX));
    }

    public int getItemCount() {
        return this.items.size();
    }

    public ActivatorItem getSelection() {
        return this.activeItem;
    }

    public int getSelectionIndex() {
        if (this.activeItem == null) {
            return -1;
        }
        return this.items.indexOf((Object)this.activeItem);
    }

    protected void itemClosePressed(ActivatorItem item) {
        if (this.listener != null) {
            this.listener.itemClosePressed(item);
        }
    }

    protected void itemSelected(ActivatorItem item) {
        if (this.listener != null) {
            this.listener.itemSelected(item);
        }
    }

    public void paintControl(PaintEvent event) {
        Display disp = this.getDisplay();
        GC gc = event.gc;
        Rectangle r = this.getClientArea();
        ActivatorBar.paintGradient(disp, gc, r);
    }

    protected static void paintGradient(Display disp, GC gc, Rectangle r) {
        Color c1 = disp.getSystemColor(19);
        Color c2 = disp.getSystemColor(18);
        int y = 0;
        int STEPS = 20;
        int dY = r.height / STEPS + 1;
        int nStep = 0;
        while (nStep < STEPS) {
            int red = (c1.getRed() * (STEPS - nStep) + c2.getRed() * nStep) / STEPS;
            int green = (c1.getGreen() * (STEPS - nStep) + c2.getGreen() * nStep) / STEPS;
            int blue = (c1.getBlue() * (STEPS - nStep) + c2.getBlue() * nStep) / STEPS;
            Color bandColor = new Color((Device)disp, red, green, blue);
            Color oldColor = gc.getBackground();
            gc.setBackground(bandColor);
            gc.fillRectangle(0, y, r.width, dY);
            gc.setBackground(oldColor);
            bandColor.dispose();
            y += dY;
            ++nStep;
        }
    }

    public void removeAllItems() {
        List safeCopy = (List)this.items.clone();
        Iterator iterator = safeCopy.iterator();
        while (iterator.hasNext()) {
            ActivatorItem item = (ActivatorItem)((Object)iterator.next());
            item.dispose();
        }
        this.items.clear();
        this.layout();
    }

    protected void removeItem(ActivatorItem item) {
        int nIndex = this.items.indexOf((Object)item);
        if (nIndex >= 0) {
            if (this.activeItem == item) {
                this.activeItem = null;
            }
            this.items.remove(nIndex);
        }
        this.layout();
    }

    public void removeSelectionListener(ItemListener listener) {
        this.listener = null;
    }

    public void setSelection(ActivatorItem item) {
        if (this.activeItem == item) {
            return;
        }
        if (this.activeItem != null) {
            this.activeItem.setPressed(false);
        }
        this.activeItem = item;
        if (this.activeItem != null) {
            this.activeItem.setPressed(true);
        }
    }

    public void setSelectionIndex(int nX) {
        ActivatorItem item = (ActivatorItem)((Object)this.items.get(nX));
        this.setSelection(item);
    }
}

