/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ActivatorBarLayout
extends Layout {
    private int preferredWidth;
    private int lastClientWidth;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int count = children.length;
        if (count == 0) {
            return new Point(5, 22);
        }
        int width = 0;
        int height = 22;
        int i = 0;
        while (i < count) {
            Control child = children[i];
            Point pt = child.computeSize(-1, -1, flushCache);
            width += pt.x;
            height = Math.max(height, pt.y);
            ++i;
        }
        this.preferredWidth = width;
        return new Point(width, height);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        int count = children.length;
        if (count == 0) {
            return;
        }
        Rectangle client = composite.getClientArea();
        int x = client.x;
        int y = client.y;
        int height = client.height;
        float scale = 1.0f;
        if (flushCache || client.width != this.lastClientWidth) {
            this.preferredWidth = this.computeSize((Composite)composite, (int)0, (int)0, (boolean)true).x;
            this.lastClientWidth = client.width;
        }
        if (this.preferredWidth > client.width) {
            scale = (float)client.width / (float)this.preferredWidth;
        }
        int i = 0;
        while (i < count) {
            Control child = children[i];
            Point pt = child.computeSize(-1, -1, false);
            int width = (int)((float)pt.x * scale);
            if (scale < 1.0f && i == count - 1) {
                width = client.width - x;
            }
            child.setBounds(x, y, width, height);
            x += width;
            ++i;
        }
    }
}

