/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.misc.ActivatorBar;

public class ActivatorItem
extends Canvas
implements PaintListener,
MouseListener,
DisposeListener {
    protected String fText;
    protected Image fImage;
    protected static Image fCloseImage;
    protected static int fInstanceCount;
    protected ActivatorBar fParent;
    protected boolean fPressed = false;
    static final int GAP = 5;

    public ActivatorItem(ActivatorBar parent) {
        super((Composite)parent, 0);
        ActivatorItem.addInstance();
        this.fParent = parent;
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addDisposeListener(this);
        this.fParent.addItem(this);
    }

    private static void addInstance() {
        ImageDescriptor desc;
        if (fInstanceCount == 0 && (desc = WorkbenchImages.getImageDescriptor("IMG_LCL_CLOSE_VIEW")) != null) {
            fCloseImage = desc.createImage();
        }
        ++fInstanceCount;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point e = this.getMinimumSize();
        if (wHint != -1) {
            e.x = wHint;
        }
        if (hHint != -1) {
            e.y = hHint;
        }
        return e;
    }

    public void dispose() {
        super.dispose();
        this.fParent.removeItem(this);
    }

    private static void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getMinimumSize() {
        Rectangle r;
        Point size = new Point(0, 22);
        if (this.fImage != null) {
            r = this.fImage.getBounds();
            size.x = r.width;
        }
        if (this.fText != null && this.fText.length() > 0) {
            GC gc = new GC((Drawable)this);
            Point e = gc.textExtent(this.fText);
            size.x += e.x + 10;
            gc.dispose();
        }
        if (fCloseImage != null) {
            r = fCloseImage.getBounds();
            size.x += r.width + 2;
        }
        return size;
    }

    public String getText() {
        return this.fText;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            int textExtent = 100000;
            if (this.fPressed && fCloseImage != null) {
                textExtent = this.getClientArea().width - ActivatorItem.fCloseImage.getBounds().width - 4;
            }
            if (e.x < textExtent) {
                this.fParent.itemSelected(this);
            } else {
                this.fParent.itemClosePressed(this);
            }
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    protected void paintBorder(GC gc, Rectangle r) {
        Display disp = this.getDisplay();
        Color c1 = null;
        Color c2 = null;
        if (this.fPressed) {
            c1 = disp.getSystemColor(18);
            c2 = disp.getSystemColor(20);
        } else {
            c1 = disp.getSystemColor(19);
            c2 = disp.getSystemColor(18);
        }
        if (c1 != null && c2 != null) {
            gc.setLineWidth(1);
            ActivatorItem.drawBevelRect(gc, r.x, r.y, r.width - 1, r.height - 1, c1, c2);
        }
    }

    protected void paintBorder(GC gc, Rectangle r, boolean bPressed) {
        Display disp = this.getDisplay();
        Color c1 = null;
        Color c2 = null;
        if (bPressed) {
            c1 = disp.getSystemColor(18);
            c2 = disp.getSystemColor(20);
        } else {
            c1 = disp.getSystemColor(19);
            c2 = disp.getSystemColor(18);
        }
        if (c1 != null && c2 != null) {
            gc.setLineWidth(1);
            ActivatorItem.drawBevelRect(gc, r.x, r.y, r.width - 1, r.height - 1, c1, c2);
        }
    }

    public void paintControl(PaintEvent event) {
        int availableWidth;
        GC gc = event.gc;
        Rectangle r = this.getClientArea();
        if (this.fPressed) {
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.fillRectangle(r);
        } else {
            ActivatorBar.paintGradient(this.getDisplay(), gc, r);
        }
        this.paintBorder(gc, r);
        int imageWidth = 0;
        Image image = this.fImage;
        Rectangle imageBounds = null;
        if (image != null) {
            imageBounds = image.getBounds();
            imageWidth = image.getBounds().width;
        }
        Point textExtent = null;
        if (this.fText != null && this.fText.length() > 0) {
            textExtent = gc.textExtent(this.fText);
        }
        Rectangle closeBox = new Rectangle(0, 0, 0, 0);
        if (fCloseImage != null) {
            int width = ActivatorItem.fCloseImage.getBounds().width + 2;
            closeBox = new Rectangle(r.x + r.width - width, r.y, width, r.height);
        }
        boolean shortenText = false;
        if (this.fText != null && textExtent.x > (availableWidth = r.width - 10 - imageWidth - closeBox.width)) {
            image = null;
            imageWidth = 0;
            availableWidth = r.width - 10 - imageWidth - closeBox.width;
            if (textExtent.x > availableWidth) {
                shortenText = true;
            }
        }
        String t = this.fText;
        if (shortenText) {
            int availableWidth2 = r.width - 10 - imageWidth - closeBox.width;
            t = this.shortenText(gc, this.fText, availableWidth2);
            textExtent.x = gc.textExtent((String)t).x;
            this.setToolTipText(this.fText);
        } else {
            this.setToolTipText(null);
        }
        int x = r.x;
        if (image != null) {
            gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, x, (r.height - imageBounds.height) / 2, imageBounds.width, imageBounds.height);
            x += imageBounds.width;
        }
        if (t != null) {
            gc.setForeground(this.getDisplay().getSystemColor(2));
            gc.drawText(t, x += 5, r.y + (r.height - textExtent.y) / 2, true);
        }
        if (this.fPressed && fCloseImage != null) {
            ++closeBox.x;
            closeBox.width -= 2;
            ++closeBox.y;
            closeBox.height -= 2;
            gc.setBackground(this.getDisplay().getSystemColor(22));
            gc.fillRectangle(closeBox);
            Rectangle imgBounds = fCloseImage.getBounds();
            gc.drawImage(fCloseImage, 0, 0, imgBounds.width, imgBounds.height, closeBox.x + (closeBox.width - imgBounds.width) / 2, closeBox.y + (closeBox.height - imgBounds.height) / 2, imgBounds.width, imgBounds.height);
            this.paintBorder(gc, closeBox, false);
        }
    }

    private static void removeInstance() {
        if (--fInstanceCount <= 0 && fCloseImage != null) {
            fCloseImage.dispose();
            fCloseImage = null;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        if (image != this.fImage) {
            this.fImage = image;
            this.redraw();
        }
    }

    public void setPressed(boolean pressed) {
        this.fPressed = pressed;
        this.redraw();
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.fText)) {
            this.fText = text;
        }
        this.fParent.layout();
        this.redraw();
    }

    protected String shortenText(GC gc, String t, int width) {
        int pivot;
        String ellipsis = "...";
        int w = gc.textExtent((String)ellipsis).x;
        int l = t.length();
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = t.substring(0, s);
            String s2 = t.substring(e, l);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + w + l2 < width) {
                t = String.valueOf(s1) + ellipsis + s2;
                break;
            }
            --s;
            ++e;
        }
        return t;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
        ActivatorItem.removeInstance();
    }
}

