/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.registry.MarkerQueryResult;

public class MarkerQuery {
    private String type;
    private String[] attributes;
    private int hashCode;

    public MarkerQuery(String markerType, String[] markerAttributes) {
        Assert.isNotNull(markerAttributes);
        this.type = markerType;
        this.attributes = markerAttributes;
        this.computeHashCode();
    }

    public MarkerQueryResult performQuery(IMarker marker) {
        try {
            if (this.type != null && !this.type.equals(marker.getType())) {
                return null;
            }
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Error accessing marker type", e.getStatus());
            return null;
        }
        String[] values = new String[this.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            try {
                Object value = marker.getAttribute(this.attributes[i]);
                if (value == null) {
                    return null;
                }
                values[i] = value.toString();
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Error accessing marker attribute", e.getStatus());
                return null;
            }
            ++i;
        }
        return new MarkerQueryResult(values);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MarkerQuery)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        MarkerQuery mq = (MarkerQuery)o;
        if (this.type == null ? mq.type != null : !this.type.equals(mq.type)) {
            return false;
        }
        if (this.attributes.length != mq.attributes.length) {
            return false;
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (!this.attributes[i].equals(mq.attributes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void computeHashCode() {
        this.hashCode = 19;
        if (this.type != null) {
            this.hashCode = this.hashCode * 37 + this.type.hashCode();
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.hashCode = this.hashCode * 37 + this.attributes[i].hashCode();
            ++i;
        }
    }

    public String getType() {
        return this.type;
    }

    public String[] getAttributes() {
        return this.attributes;
    }
}

