/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.model.AdaptableList;
import org.eclipse.ui.internal.registry.RegistryReader;

public class WizardsRegistryReader
extends RegistryReader {
    protected AdaptableList wizards;
    private String pluginPoint;
    protected static final String TAG_WIZARD = "wizard";
    protected static final String ATT_NAME = "name";
    public static final String ATT_CLASS = "class";
    protected static final String ATT_ICON = "icon";
    protected static final String ATT_ID = "id";
    protected static final String trueString = "TRUE";

    public WizardsRegistryReader(String pluginPointId) {
        this.pluginPoint = pluginPointId;
    }

    protected void addNewElementToResult(WorkbenchWizardElement wizard, IConfigurationElement config, AdaptableList result) {
        result.add(wizard);
    }

    protected AdaptableList createEmptyWizardCollection() {
        return new AdaptableList();
    }

    protected WorkbenchWizardElement createWizardElement(IConfigurationElement element) {
        String nameString = element.getAttribute(ATT_NAME);
        if (nameString == null) {
            this.logMissingAttribute(element, ATT_NAME);
            return null;
        }
        WorkbenchWizardElement result = new WorkbenchWizardElement(nameString);
        if (this.initializeWizard(result, element)) {
            return result;
        }
        return null;
    }

    public WorkbenchWizardElement findWizard(String id) {
        Object[] wizards = this.getWizards().getChildren();
        int nX = 0;
        while (nX < wizards.length) {
            WizardCollectionElement collection = (WizardCollectionElement)wizards[nX];
            WorkbenchWizardElement element = collection.findWizard(id, true);
            if (element != null) {
                return element;
            }
            ++nX;
        }
        return null;
    }

    public AdaptableList getWizards() {
        if (this.wizards == null) {
            this.readWizards();
        }
        return this.wizards;
    }

    protected boolean initializeWizard(WorkbenchWizardElement element, IConfigurationElement config) {
        element.setID(config.getAttribute(ATT_ID));
        element.setDescription(this.getDescription(config));
        element.setConfigurationElement(config);
        String iconName = config.getAttribute(ATT_ICON);
        if (iconName != null) {
            IExtension extension = config.getDeclaringExtension();
            element.setImageDescriptor(WorkbenchImages.getImageDescriptorFromExtension(extension, iconName));
        }
        if (element.getConfigurationElement() == null) {
            this.logMissingAttribute(config, ATT_CLASS);
            return false;
        }
        return true;
    }

    protected boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_WIZARD)) {
            return false;
        }
        WorkbenchWizardElement wizard = this.createWizardElement(element);
        if (wizard != null) {
            this.addNewElementToResult(wizard, element, this.wizards);
        }
        return true;
    }

    protected void readWizards() {
        if (this.wizards == null) {
            this.wizards = this.createEmptyWizardCollection();
            IPluginRegistry pregistry = Platform.getPluginRegistry();
            this.readRegistry(pregistry, "org.eclipse.ui", this.pluginPoint);
        }
    }
}

