/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class WorkingSetRegistryReader
extends RegistryReader {
    private static final String TAG = "workingSet";
    private WorkingSetRegistry registry;

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG)) {
            try {
                WorkingSetDescriptor desc = new WorkingSetDescriptor(element);
                this.registry.addWorkingSetDescriptor(desc);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Unable to create working set descriptor.", e.getStatus());
            }
            return true;
        }
        return false;
    }

    public void readWorkingSets(IPluginRegistry in, WorkingSetRegistry out) {
        this.registry = out;
        this.readRegistry(in, "org.eclipse.ui", "workingSets");
    }
}

