/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileEditorMappingContentProvider;
import org.eclipse.ui.dialogs.FileEditorMappingLabelProvider;
import org.eclipse.ui.dialogs.FileSelectionDialog;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.WizardImportPage;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.SelectFilesOperation;

class WizardFileSystemImportPage1
extends WizardImportPage
implements ISelectionChangedListener,
Listener {
    private List selectedResources;
    private FileSystemElement root;
    private IWorkbench workbench;
    protected Combo typesToImportField;
    protected Button typesToImportEditButton;
    protected Combo sourceNameField;
    protected Button sourceBrowseButton;
    protected Button importAllResourcesRadio;
    protected Button importTypedResourcesRadio;
    protected Button detailsButton;
    protected Label detailsDescriptionLabel;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button createContainerStructureCheckbox;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final int SIZING_LIST_HEIGHT = 150;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private static final String TYPE_DELIMITER = DataTransferMessages.getString("DataTransfer.typeDelimiter");
    private static final String STORE_SOURCE_NAMES_ID = "WizardFileSystemImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_IMPORT_ALL_RESOURCES_ID = "WizardFileSystemImportPage1.STORE_IMPORT_ALL_FILES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardFileSystemImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_CREATE_CONTAINER_STRUCTURE_ID = "WizardFileSystemImportPage1.STORE_CREATE_CONTAINER_STRUCTURE_ID";
    private static final String STORE_SELECTED_TYPES_ID = "WizardFileSystemImportPage1.STORE_SELECTED_TYPES_ID";

    protected WizardFileSystemImportPage1(String name, IWorkbench aWorkbench, IStructuredSelection selection) {
        super(name, selection);
        this.workbench = aWorkbench;
    }

    public WizardFileSystemImportPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        this("fileSystemImportPage1", aWorkbench, selection);
        this.setTitle(DataTransferMessages.getString("DataTransfer.fileSystemTitle"));
        this.setDescription(DataTransferMessages.getString("FileImport.importFileSystem"));
    }

    protected void addToSelectedResources(FileSystemElement element) {
        if (element.isDirectory()) {
            Object[] children = element.getFolders().getChildren(element);
            int i = 0;
            while (i < children.length) {
                this.addToSelectedResources((FileSystemElement)children[i]);
                ++i;
            }
            children = element.getFiles().getChildren(element);
            i = 0;
            while (i < children.length) {
                this.addToSelectedResources((FileSystemElement)children[i]);
                ++i;
            }
        } else {
            this.selectedResources.add(element);
        }
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.overwriteExistingResourcesCheckbox = new Button(optionsGroup, 32);
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.getString("FileImport.overwriteExisting"));
        this.createContainerStructureCheckbox = new Button(optionsGroup, 32);
        this.createContainerStructureCheckbox.setText(DataTransferMessages.getString("FileImport.createComplete"));
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        new Label(sourceContainerGroup, 0).setText(this.getSourceLabel());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        this.sourceNameField.addListener(24, (Listener)this);
        this.sourceNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(DataTransferMessages.getString("DataTransfer.browse"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        Composite sourceTypesGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        sourceTypesGroup.setLayout((Layout)layout);
        sourceTypesGroup.setLayoutData((Object)new GridData(768));
        this.importAllResourcesRadio = new Button(sourceTypesGroup, 16);
        this.importAllResourcesRadio.setText(DataTransferMessages.getString("DataTransfer.allTypes"));
        this.importAllResourcesRadio.addListener(13, (Listener)this);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.importAllResourcesRadio.setLayoutData((Object)data);
        this.importTypedResourcesRadio = new Button(sourceTypesGroup, 16);
        this.importTypedResourcesRadio.setText(DataTransferMessages.getString("FileImport.filesofType"));
        this.importTypedResourcesRadio.addListener(13, (Listener)this);
        this.typesToImportField = new Combo(sourceTypesGroup, 0);
        data = new GridData(768);
        data.widthHint = 250;
        this.typesToImportField.setLayoutData((Object)data);
        this.typesToImportField.addListener(24, (Listener)this);
        this.typesToImportEditButton = new Button(sourceTypesGroup, 8);
        this.typesToImportEditButton.setText(DataTransferMessages.getString("FileImport.edit"));
        this.typesToImportEditButton.setLayoutData((Object)new GridData(264));
        this.typesToImportEditButton.addListener(13, (Listener)this);
        Composite fileDetailsGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        fileDetailsGroup.setLayout((Layout)layout);
        fileDetailsGroup.setLayoutData((Object)new GridData(768));
        this.detailsButton = new Button(fileDetailsGroup, 8);
        this.detailsButton.setText(DataTransferMessages.getString("DataTransfer.details"));
        this.detailsButton.addListener(13, (Listener)this);
        this.detailsDescriptionLabel = new Label(fileDetailsGroup, 0);
        data = new GridData(768);
        this.detailsDescriptionLabel.setLayoutData((Object)data);
        this.typesToImportField.setEnabled(false);
        this.typesToImportEditButton.setEnabled(false);
        this.importAllResourcesRadio.setSelection(true);
        this.resetSelection();
        this.sourceNameField.setFocus();
    }

    protected void displaySelectedCount(int selectedFileCount) {
        if (selectedFileCount == 1) {
            this.detailsDescriptionLabel.setText(DataTransferMessages.getString("DataTransfer.oneSelected"));
        } else {
            this.detailsDescriptionLabel.setText(DataTransferMessages.format("FileImport.filesSelected", new Object[]{String.valueOf(selectedFileCount)}));
        }
    }

    protected boolean ensureSourceIsValid() {
        if (new File(this.getSourceDirectoryName()).isDirectory()) {
            return true;
        }
        this.displayErrorDialog(DataTransferMessages.getString("FileImport.invalidSource"));
        this.sourceNameField.setFocus();
        return false;
    }

    protected boolean executeImportOperation(ImportOperation op) {
        this.initializeOperation(op);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException().getMessage());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("FileImport.importProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        if (this.selectedResources == null && this.importAllResourcesRadio.getSelection()) {
            this.saveWidgetValues();
            return this.importAllResources();
        }
        if (this.selectedResources == null && this.getFileSystemTree() == null) {
            return false;
        }
        this.saveWidgetValues();
        if (this.selectedResources.size() > 0) {
            ArrayList<Object> fileSystemObjects = new ArrayList<Object>(this.selectedResources.size());
            Iterator resourcesEnum = this.selectedResources.iterator();
            while (resourcesEnum.hasNext()) {
                fileSystemObjects.add(((FileSystemElement)resourcesEnum.next()).getFileSystemObject());
            }
            return this.importResources(fileSystemObjects);
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.information"), (String)DataTransferMessages.getString("FileImport.noneSelected"));
        return false;
    }

    protected FileSystemElement getFileSystemTree() {
        if (this.root != null) {
            return this.root;
        }
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, FileSystemStructureProvider.INSTANCE);
    }

    protected FileSystemElement getRoot() {
        return this.root;
    }

    protected List getSelectedResources() {
        return this.selectedResources;
    }

    protected File getSourceDirectory() {
        File sourceDirectory = new File(this.getSourceDirectoryName());
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.getString("FileImport.invalidSource"));
            this.sourceNameField.setFocus();
            return null;
        }
        return sourceDirectory;
    }

    private String getSourceDirectoryName() {
        Path result = new Path(this.sourceNameField.getText().trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    protected String getSourceLabel() {
        return DataTransferMessages.getString("FileImport.sourceTitle");
    }

    protected List getTypesToImport() {
        if (this.importAllResourcesRadio.getSelection()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.typesToImportField.getText(), TYPE_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            if (currentExtension.equals("")) continue;
            result.add(currentExtension);
        }
        return result;
    }

    protected String[] getTypesToImportArray() {
        List typesToImport = this.getTypesToImport();
        if (typesToImport == null) {
            return null;
        }
        String[] result = new String[typesToImport.size()];
        typesToImport.toArray(result);
        return result;
    }

    protected void handleDetailsButtonPressed() {
        List newSelections;
        FileSystemElement rootElement = this.getFileSystemTree();
        if (rootElement != null && (newSelections = this.queryResourcesToImport(rootElement)) != null) {
            this.selectedResources = newSelections;
            this.displaySelectedCount(this.selectedResources.size());
        }
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.sourceNameField) {
            this.resetSelection();
        } else if (source == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        } else if (source == this.importAllResourcesRadio) {
            this.resetSelection();
        } else if (source == this.importTypedResourcesRadio) {
            this.resetSelection();
            this.typesToImportField.setFocus();
        } else if (source == this.detailsButton) {
            this.handleDetailsButtonPressed();
        } else if (source == this.typesToImportField) {
            this.resetSelection();
        } else if (source == this.typesToImportEditButton) {
            this.handleTypesEditButtonPressed();
        }
        super.handleEvent(e);
    }

    protected void handleSourceBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.sourceNameField.getShell(), 8192);
        dialog.setMessage(DataTransferMessages.getString("FileImport.selectSource"));
        dialog.setFilterPath(this.getSourceDirectoryName());
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null && !selectedDirectory.equals(this.getSourceDirectoryName())) {
            this.resetSelection();
            this.sourceNameField.setText(selectedDirectory);
        }
    }

    protected void handleTypesEditButtonPressed() {
        IFileEditorMapping[] editorMappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        List selectedTypes = this.getTypesToImport();
        ArrayList<IFileEditorMapping> initialSelections = new ArrayList<IFileEditorMapping>();
        int i = 0;
        while (i < editorMappings.length) {
            IFileEditorMapping mapping = editorMappings[i];
            if (selectedTypes.contains(mapping.getExtension())) {
                initialSelections.add(mapping);
            }
            ++i;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(this.getContainer().getShell(), editorMappings, FileEditorMappingContentProvider.INSTANCE, (ILabelProvider)FileEditorMappingLabelProvider.INSTANCE, DataTransferMessages.getString("FileImport.selectTypes"));
        dialog.setInitialSelections(initialSelections.toArray());
        dialog.setTitle(DataTransferMessages.getString("FileImport.typeSelectionTitle"));
        dialog.open();
        Object[] newSelectedTypes = dialog.getResult();
        if (newSelectedTypes != null) {
            ArrayList<String> result = new ArrayList<String>(newSelectedTypes.length);
            int i2 = 0;
            while (i2 < newSelectedTypes.length) {
                result.add(((IFileEditorMapping)newSelectedTypes[i2]).getExtension());
                ++i2;
            }
            this.setTypesToImport(result);
        }
    }

    protected boolean importAllResources() {
        return this.executeImportOperation(new ImportOperation(this.getContainerFullPath(), this.getSourceDirectory(), FileSystemStructureProvider.INSTANCE, this));
    }

    protected boolean importResources(List fileSystemObjects) {
        return this.executeImportOperation(new ImportOperation(this.getContainerFullPath(), this.getSourceDirectory(), FileSystemStructureProvider.INSTANCE, this, fileSystemObjects));
    }

    protected void initializeOperation(ImportOperation op) {
        op.setCreateContainerStructure(this.createContainerStructureCheckbox.getSelection());
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected List queryResourcesToImport(FileSystemElement rootElement) {
        FileSelectionDialog dialog = new FileSelectionDialog(this.getContainer().getShell(), rootElement, DataTransferMessages.getString("FileImport.selectResources"));
        dialog.setInitialSelections(this.selectedResources.toArray());
        dialog.setExpandAllOnOpen(true);
        dialog.open();
        if (dialog.getResult() == null) {
            return null;
        }
        return Arrays.asList(dialog.getResult());
    }

    protected void resetSelection() {
        this.detailsDescriptionLabel.setText(DataTransferMessages.getString("DataTransfer.allFiles"));
        this.selectedResources = null;
        this.root = null;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            boolean importAll = settings.getBoolean(STORE_IMPORT_ALL_RESOURCES_ID);
            this.importAllResourcesRadio.setSelection(importAll);
            this.importTypedResourcesRadio.setSelection(!importAll);
            this.sourceNameField.setText(sourceNames[0]);
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            String[] selectedTypes = settings.getArray(STORE_SELECTED_TYPES_ID);
            if (selectedTypes.length > 0) {
                this.typesToImportField.setText(selectedTypes[0]);
            }
            int i2 = 0;
            while (i2 < selectedTypes.length) {
                this.typesToImportField.add(selectedTypes[i2]);
                ++i2;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
            this.createContainerStructureCheckbox.setSelection(settings.getBoolean(STORE_CREATE_CONTAINER_STRUCTURE_ID));
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            String[] selectedTypesNames = settings.getArray(STORE_SELECTED_TYPES_ID);
            if (selectedTypesNames == null) {
                selectedTypesNames = new String[]{};
            }
            if (this.importTypedResourcesRadio.getSelection()) {
                selectedTypesNames = this.addToHistory(selectedTypesNames, this.typesToImportField.getText());
            }
            settings.put(STORE_SELECTED_TYPES_ID, selectedTypesNames);
            settings.put(STORE_IMPORT_ALL_RESOURCES_ID, this.importAllResourcesRadio.getSelection());
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
            settings.put(STORE_CREATE_CONTAINER_STRUCTURE_ID, this.createContainerStructureCheckbox.getSelection());
        }
    }

    protected FileSystemElement selectFiles(Object rootFileSystemObject, IImportStructureProvider structureProvider) {
        try {
            SelectFilesOperation op = new SelectFilesOperation(rootFileSystemObject, structureProvider);
            op.setDesiredExtensions(this.getTypesToImportArray());
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            this.root = op.getResult();
            this.setSelectedResources(new ArrayList());
            this.addToSelectedResources(this.root);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException().getMessage());
            return null;
        }
        return this.root;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.importTypedResourcesRadio.getSelection()) {
            this.resetSelection();
        }
    }

    protected void setRoot(FileSystemElement value) {
        this.root = value;
    }

    protected void setSelectedResources(List value) {
        this.selectedResources = value;
    }

    protected void setTypesToImport(List types) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < types.size()) {
            if (i != 0) {
                result.append(TYPE_DELIMITER);
                result.append(" ");
            }
            result.append(types.get(i));
            ++i;
        }
        this.typesToImportField.setText(result.toString());
    }

    protected void updateWidgetEnablements() {
        this.typesToImportField.setEnabled(this.importTypedResourcesRadio.getSelection());
        this.typesToImportEditButton.setEnabled(this.importTypedResourcesRadio.getSelection());
    }

    protected boolean validateSourceGroup() {
        return !this.getSourceDirectoryName().equals("");
    }
}

