/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.thread.impl;

import org.apache.avalon.excalibur.pool.InstrumentedResourceLimitingPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.thread.impl.BasicThreadPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.thread.Executable;
import org.apache.excalibur.thread.ThreadControl;
import org.apache.excalibur.thread.ThreadPool;

public class InstrumentedResourceLimitingThreadPool
extends ThreadGroup
implements ObjectFactory,
LogEnabled,
Disposable,
ThreadPool,
Instrumentable {
    private InstrumentedResourceLimitingPool m_underlyingPool;
    private String m_instrumentableName;
    private BasicThreadPool m_pool;

    public InstrumentedResourceLimitingThreadPool(int max) {
        this("Worker Pool", max);
    }

    public InstrumentedResourceLimitingThreadPool(String name, int max) {
        this(name, max, true, true, 0L, 10000L);
    }

    public InstrumentedResourceLimitingThreadPool(String name, int max, boolean maxStrict, boolean blocking, long blockTimeout, long trimInterval) {
        super(name);
        this.m_underlyingPool = new InstrumentedResourceLimitingPool((ObjectFactory)this, max, maxStrict, blocking, blockTimeout, trimInterval);
        try {
            this.m_pool = new BasicThreadPool((ThreadGroup)this, name, (Pool)this.m_underlyingPool);
        }
        catch (Exception e) {
            String message = "Unable to create ThreadPool due to " + e;
            throw new IllegalStateException(message);
        }
    }

    public void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return Instrumentable.EMPTY_INSTRUMENT_ARRAY;
    }

    public Instrumentable[] getChildInstrumentables() {
        return new Instrumentable[]{this.m_underlyingPool};
    }

    public int getSize() {
        return this.m_underlyingPool.getSize();
    }

    public void enableLogging(Logger logger) {
        ContainerUtil.enableLogging((Object)this.m_pool, (Logger)logger);
    }

    public void dispose() {
        this.m_pool.dispose();
    }

    public Object newInstance() {
        return this.m_pool.newInstance();
    }

    public void decommission(Object object) {
        this.m_pool.decommission(object);
    }

    public Class getCreatedClass() {
        return this.m_pool.getCreatedClass();
    }

    public ThreadControl execute(org.apache.avalon.framework.activity.Executable work) {
        return this.m_pool.execute(work);
    }

    public ThreadControl execute(Runnable work) {
        return this.m_pool.execute(work);
    }

    public ThreadControl execute(Executable work) {
        return this.m_pool.execute(work);
    }
}

