/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.StringHelper;

public class JDBCBinder {
    private Settings settings;
    private ConnectionProvider connectionProvider;
    private static final Log log = LogFactory.getLog((Class)JDBCBinder.class);
    private Dialect dialect;
    private DatabaseMetaData metaData;
    private Connection connection;
    private final Mappings mappings;
    private final JDBCMetaDataConfiguration cfg;
    private ReverseEngineeringStrategy revengStrategy;

    public JDBCBinder(JDBCMetaDataConfiguration cfg, Settings settings, Mappings mappings, ReverseEngineeringStrategy revengStrategy) {
        this.cfg = cfg;
        this.settings = settings;
        this.mappings = mappings;
        this.revengStrategy = revengStrategy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFromDatabase(String catalog, String schema) {
        this.connectionProvider = this.settings.getConnectionProvider();
        this.dialect = this.settings.getDialect();
        try {
            try {
                Map oneToManyCandidates = this.readDatabaseSchema(catalog, schema);
                this.createPersistentClasses(oneToManyCandidates);
            }
            catch (SQLException e) {
                throw this.settings.getSQLExceptionConverter().convert(e, "Reading from database", null);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (this.connection == null) throw throwable;
                this.connectionProvider.closeConnection(this.connection);
                throw throwable;
            }
            catch (SQLException e) {
                throw this.settings.getSQLExceptionConverter().convert(e, "Closing connection", null);
            }
        }
        try {}
        catch (SQLException e) {
            throw this.settings.getSQLExceptionConverter().convert(e, "Closing connection", null);
        }
        if (this.connection == null) return;
        this.connectionProvider.closeConnection(this.connection);
    }

    public Map readDatabaseSchema(String catalog, String schema) throws SQLException {
        this.readTables(catalog, schema);
        Iterator tables = this.mappings.iterateTables();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            this.processBasicColumns(table);
            this.processPrimaryKey(table);
            this.processIndices(table);
        }
        tables = this.mappings.iterateTables();
        HashMap oneToManyCandidates = new HashMap();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            Map foreignKeys = this.processForeignKeys(table);
            this.mergeMultiMap(oneToManyCandidates, foreignKeys);
        }
        return oneToManyCandidates;
    }

    private void mergeMultiMap(Map dest, Map src) {
        Iterator items = src.entrySet().iterator();
        while (items.hasNext()) {
            Map.Entry element = items.next();
            List existing = (List)dest.get(element.getKey());
            if (existing == null) {
                dest.put(element.getKey(), element.getValue());
                continue;
            }
            existing.addAll((List)element.getValue());
        }
    }

    private void createPersistentClasses(Map manyToOneCandidates) {
        Iterator iter = this.mappings.iterateTables();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (table.getColumnSpan() == 0) {
                log.warn((Object)("Cannot create persistent class for " + table + " as no columns were found."));
                continue;
            }
            RootClass rc = new RootClass();
            rc.setEntityName(this.revengStrategy.tableToClassName(TableIdentifier.create(table)));
            rc.setClassName(this.revengStrategy.tableToClassName(TableIdentifier.create(table)));
            rc.setProxyInterfaceName(rc.getEntityName());
            rc.setLazy(true);
            rc.setDiscriminatorValue(rc.getEntityName());
            rc.setTable(table);
            this.mappings.addClass((PersistentClass)rc);
            this.mappings.addImport(rc.getEntityName(), rc.getEntityName());
            HashSet processed = new HashSet();
            this.bindPrimaryKeyToProperties(table, rc, processed);
            this.bindOutgoingForeignKeys(table, rc, processed);
            this.bindColumnsToProperties(table, rc, processed);
            List incomingForeignKeys = (List)manyToOneCandidates.get(rc.getEntityName());
            this.bindIncomingForeignKeys((PersistentClass)rc, processed, incomingForeignKeys);
        }
    }

    private void bindIncomingForeignKeys(PersistentClass rc, java.util.Set processed, List foreignKeys) {
        if (foreignKeys != null) {
            Iterator iter = foreignKeys.iterator();
            while (iter.hasNext()) {
                ForeignKey fk = (ForeignKey)iter.next();
                Property property = this.bindOneToMany(rc, fk, processed);
                rc.addProperty(property);
            }
        }
    }

    private Property bindManyToOne(String propertyName, Table table, ForeignKey fk, java.util.Set processedColumns) {
        ManyToOne value = new ManyToOne(table);
        value.setReferencedEntityName(fk.getReferencedEntityName());
        Iterator columns = fk.getColumnIterator();
        while (columns.hasNext()) {
            Column fkcolumn = (Column)columns.next();
            this.checkColumn(fkcolumn);
            value.addColumn(fkcolumn);
            processedColumns.add(fkcolumn);
        }
        return JDBCBinder.makeProperty(propertyName, (Value)value, true, true, false, null, null);
    }

    private Property bindOneToMany(PersistentClass rc, ForeignKey foreignKey, java.util.Set processed) {
        Table collectionTable = foreignKey.getTable();
        Set collection = new Set(rc);
        collection.setCollectionTable(collectionTable);
        String collectionRole = this.revengStrategy.foreignKeyToCollectionName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), TableIdentifier.create(foreignKey.getReferencedTable()));
        collectionRole = this.makeUnique(rc, collectionRole);
        String fullRolePath = StringHelper.qualify((String)rc.getEntityName(), (String)collectionRole);
        if (this.mappings.getCollection(fullRolePath) != null) {
            log.debug((Object)(fullRolePath + " found twice!"));
        }
        collection.setRole(fullRolePath);
        collection.setInverse(true);
        collection.setLazy(true);
        OneToMany oneToMany = new OneToMany(collection.getOwner());
        oneToMany.setReferencedEntityName(this.revengStrategy.tableToClassName(TableIdentifier.create(foreignKey.getTable())));
        this.mappings.addSecondPass((HbmBinder.SecondPass)new CollectionSecondPass(this.mappings, (Collection)collection));
        collection.setElement((Value)oneToMany);
        String propRef = collection.getReferencedPropertyName();
        KeyValue referencedKeyValue = propRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getProperty(propRef).getValue();
        DependantValue keyValue = new DependantValue(collectionTable, referencedKeyValue);
        Iterator columnIterator = foreignKey.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column fkcolumn = (Column)columnIterator.next();
            keyValue.addColumn(fkcolumn);
        }
        collection.setKey((KeyValue)keyValue);
        this.mappings.addCollection((Collection)collection);
        return JDBCBinder.makeProperty(collectionRole, (Value)collection, true, true, true, "all", null);
    }

    private void bindPrimaryKeyToProperties(Table table, RootClass rc, java.util.Set processed) {
        SimpleValue id = null;
        String idPropertyname = null;
        ArrayList<Column> keyColumns = null;
        if (table.getPrimaryKey() != null) {
            keyColumns = table.getPrimaryKey().getColumns();
        } else {
            keyColumns = new ArrayList<Column>();
            Iterator iter = table.getColumnIterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                keyColumns.add(col);
            }
        }
        if (keyColumns.size() > 1) {
            id = this.handleCompositeKey(rc, processed, keyColumns);
            idPropertyname = "id";
        } else {
            id = new SimpleValue(table);
            Column pkc = (Column)keyColumns.get(0);
            this.checkColumn(pkc);
            id.addColumn(pkc);
            id.setTypeName(this.guessType(pkc));
            idPropertyname = this.revengStrategy.columnToPropertyName(TableIdentifier.create(table), pkc.getName());
            processed.add(pkc);
        }
        id.setIdentifierGeneratorStrategy("assigned");
        id.setNullValue("undefined");
        Property property = JDBCBinder.makeProperty(this.makeUnique((PersistentClass)rc, idPropertyname), (Value)id, true, true, false, null, null);
        rc.setIdentifierProperty(property);
        rc.setIdentifier((KeyValue)id);
    }

    private void bindOutgoingForeignKeys(Table table, RootClass rc, java.util.Set processedColumns) {
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            ForeignKey fk = (ForeignKey)iterator.next();
            boolean mutable = true;
            if (this.contains(fk.getColumnIterator(), processedColumns)) {
                if (!this.cfg.preferRawCompositeIds()) continue;
                mutable = false;
            }
            String propertyName = this.revengStrategy.foreignKeyToEntityName(fk.getName(), TableIdentifier.create(fk.getTable()), TableIdentifier.create(fk.getReferencedTable()));
            Property property = this.bindManyToOne(this.makeUnique((PersistentClass)rc, propertyName), table, fk, processedColumns);
            property.setUpdateable(mutable);
            property.setInsertable(mutable);
            rc.addProperty(property);
        }
    }

    private void bindColumnsToProperties(Table table, RootClass rc, java.util.Set processedColumns) {
        Iterator iterator = table.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (processedColumns.contains(column)) continue;
            this.checkColumn(column);
            String propertyName = this.revengStrategy.columnToPropertyName(TableIdentifier.create(table), column.getName());
            Property property = this.bindBasicProperty(this.makeUnique((PersistentClass)rc, propertyName), table, column, processedColumns);
            rc.addProperty(property);
        }
    }

    private Property bindBasicProperty(String propertyName, Table table, Column column, java.util.Set processedColumns) {
        SimpleValue value = new SimpleValue(table);
        value.addColumn(column);
        value.setTypeName(this.guessType(column));
        return JDBCBinder.makeProperty(propertyName, (Value)value, true, true, false, null, null);
    }

    private boolean contains(Iterator columnIterator, java.util.Set processedColumns) {
        while (columnIterator.hasNext()) {
            Column element = (Column)columnIterator.next();
            if (!processedColumns.contains(element)) continue;
            return true;
        }
        return false;
    }

    private void checkColumn(Column column) {
        if (column.getValue() != null) {
            // empty if block
        }
    }

    private String guessType(Column pkc) {
        Integer sqlTypeCode = pkc.getSqlTypeCode();
        if (sqlTypeCode == null) {
            throw new JDBCBinderException("Could not find sqltype for " + pkc);
        }
        String preferredJavaType = this.revengStrategy.jdbcToHibernateType(sqlTypeCode, pkc.getLength(), pkc.getPrecision(), pkc.getScale());
        if (preferredJavaType == null) {
            throw new JDBCBinderException("Could not find javatype for " + sqlTypeCode + "(" + JDBCToHibernateTypeHelper.getJDBCTypeName(sqlTypeCode) + ")");
        }
        return preferredJavaType;
    }

    /*
     * WARNING - void declaration
     */
    private SimpleValue handleCompositeKey(RootClass rc, java.util.Set processedColumns, List keyColumns) {
        Component pkc = new Component((PersistentClass)rc);
        pkc.setMetaAttributes(Collections.EMPTY_MAP);
        pkc.setEmbedded(false);
        pkc.setComponentClassName(rc.getClassName() + "Id");
        Table table = rc.getTable();
        List list = null;
        list = this.cfg.preferRawCompositeIds() ? new ArrayList(keyColumns) : this.findForeignKeys(table.getForeignKeyIterator(), keyColumns);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            void var9_9;
            Property property;
            Object element = iter.next();
            if (element instanceof Column) {
                Column column = (Column)element;
                if (processedColumns.contains(column)) {
                    throw new JDBCBinderException("Binding column twice for primary key should not happen: " + column);
                }
                this.checkColumn(column);
                String propertyName = this.revengStrategy.columnToPropertyName(TableIdentifier.create(table), column.getName());
                property = this.bindBasicProperty(this.makeUnique(pkc, propertyName), table, column, processedColumns);
                processedColumns.add(column);
            } else if (element instanceof ForeignKeyForColumns) {
                ForeignKeyForColumns fkfc = (ForeignKeyForColumns)element;
                ForeignKey fk = fkfc.key;
                String propertyName = this.revengStrategy.foreignKeyToEntityName(fk.getName(), TableIdentifier.create(fk.getTable()), TableIdentifier.create(fk.getReferencedTable()));
                property = this.bindManyToOne(this.makeUnique(pkc, propertyName), table, fk, processedColumns);
                processedColumns.addAll(fkfc.columns);
            } else {
                throw new JDBCBinderException("unknown thing");
            }
            this.markAsUseInEquals((Property)var9_9);
            pkc.addProperty((Property)var9_9);
        }
        return pkc;
    }

    private void markAsUseInEquals(Property property) {
        HashMap<String, MetaAttribute> m = new HashMap<String, MetaAttribute>();
        MetaAttribute ma = new MetaAttribute("use-in-equals");
        ma.addValue("true");
        m.put(ma.getName(), ma);
        property.setMetaAttributes(m);
    }

    private List findForeignKeys(Iterator foreignKeyIterator, List pkColumns) {
        ArrayList<ForeignKeyForColumns> result = new ArrayList<ForeignKeyForColumns>();
        ArrayList remainingColumns = new ArrayList();
        remainingColumns.addAll(pkColumns);
        while (foreignKeyIterator.hasNext()) {
            ForeignKey key = (ForeignKey)foreignKeyIterator.next();
            ArrayList<Column> columns = new ArrayList<Column>();
            Iterator pkColumnsIter = pkColumns.iterator();
            while (pkColumnsIter.hasNext()) {
                Column column = (Column)pkColumnsIter.next();
                if (!key.containsColumn(column)) continue;
                columns.add(column);
            }
            if (columns.size() != key.getColumnSpan()) continue;
            result.add(new ForeignKeyForColumns(key, columns));
            remainingColumns.removeAll(columns);
        }
        result.addAll(remainingColumns);
        return result;
    }

    private void readTables(String catalog, String schema) {
        ResultSet tableRs = null;
        try {
            catalog = catalog != null ? catalog : this.settings.getDefaultCatalogName();
            schema = schema != null ? schema : this.settings.getDefaultSchemaName();
            tableRs = this.getMetaData().getTables(catalog, schema, null, null);
            while (tableRs.next()) {
                String tableName = tableRs.getString("TABLE_NAME");
                String schemaName = tableRs.getString("TABLE_SCHEM");
                String catalogName = tableRs.getString("TABLE_CAT");
                TableIdentifier ti = new TableIdentifier(catalogName, schemaName, tableName);
                if (this.revengStrategy.excludeTable(ti)) continue;
                String tableType = tableRs.getString("TABLE_TYPE");
                if ("TABLE".equals(tableType) || "VIEW".equals(tableType) || "SYNONYM".equals(tableType)) {
                    Table table = new Table();
                    table.setName(tableName);
                    if (schemaName != null && schemaName.trim().length() > 0) {
                        table.setSchema(schemaName);
                    }
                    if (catalogName != null && catalogName.trim().length() > 0) {
                        table.setCatalog(catalogName);
                    }
                    log.debug((Object)("Adding table " + table + " of type " + tableType));
                    this.mappings.addTable(schemaName, catalogName, tableName, null, false);
                    continue;
                }
                log.debug((Object)("Ignoring table " + tableName + " of type " + tableType));
            }
        }
        catch (SQLException e) {
            String databaseStructure = this.getDatabaseStructure();
            log.error((Object)e.getMessage(), (Throwable)e);
            throw this.settings.getSQLExceptionConverter().convert(e, "Could not get list of tables from database. Probably a JDBC driver problem. " + databaseStructure, null);
        }
        finally {
            try {
                tableRs.close();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseStructure() {
        ResultSet schemaRs = null;
        ResultSet catalogRs = null;
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(nl);
        sb.append("Configured schema:").append(this.settings.getDefaultSchemaName()).append(nl);
        sb.append("Configured catalog:").append(this.settings.getDefaultCatalogName()).append(nl);
        try {
            schemaRs = this.getMetaData().getSchemas();
            sb.append("Available schemas:").append(nl);
            while (schemaRs.next()) {
                sb.append("  ").append(schemaRs.getString("TABLE_SCHEM")).append(nl);
            }
        }
        catch (SQLException e2) {
            log.warn((Object)"Couldn't get schemas", (Throwable)e2);
            sb.append("  ?? Couldn't get schemas ??").append(nl);
        }
        finally {
            try {
                schemaRs.close();
            }
            catch (Exception ignore) {}
        }
        try {
            catalogRs = this.getMetaData().getCatalogs();
            sb.append("Available catalogs:").append(nl);
            while (catalogRs.next()) {
                sb.append("  ").append(catalogRs.getString("TABLE_CAT")).append(nl);
            }
        }
        catch (SQLException e2) {
            log.warn((Object)"Couldn't get catalogs", (Throwable)e2);
            sb.append("  ?? Couldn't get catalogs ??").append(nl);
        }
        finally {
            try {
                catalogRs.close();
            }
            catch (Exception ignore) {}
        }
        return sb.toString();
    }

    private DatabaseMetaData getMetaData() throws JDBCBinderException {
        if (this.metaData == null) {
            try {
                this.metaData = this.getConnnection().getMetaData();
            }
            catch (SQLException e) {
                throw this.settings.getSQLExceptionConverter().convert(e, "Getting database metadata", null);
            }
        }
        return this.metaData;
    }

    private void dumpMetaDataInfo(DatabaseMetaData md) throws SQLException {
        ResultSet typeInfo = md.getTypeInfo();
        while (typeInfo.next()) {
            System.out.println(typeInfo.getString("TYPE_NAME"));
            System.out.println(typeInfo.getInt("DATA_TYPE"));
        }
        typeInfo.close();
    }

    private Connection getConnnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBasicColumns(Table table) throws SQLException {
        ResultSet columnRs = null;
        try {
            log.debug((Object)("Finding columns for " + table.getQualifiedName(this.dialect, null, null)));
            columnRs = this.getMetaData().getColumns(table.getCatalog(), table.getSchema(), this.dialect.quote(table.getName()), null);
            while (columnRs.next()) {
                int sqlType = columnRs.getInt("DATA_TYPE");
                String sqlTypeName = columnRs.getString("TYPE_NAME");
                String columnName = columnRs.getString("COLUMN_NAME");
                String columnDefaultValue = columnRs.getString("COLUMN_DEF");
                boolean isNullable = 1 == columnRs.getInt("NULLABLE");
                int size = columnRs.getInt("COLUMN_SIZE");
                int decimalDigits = columnRs.getInt("DECIMAL_DIGITS");
                Column column = new Column();
                column.setName(columnName);
                Column existing = table.getColumn(column);
                if (existing != null) {
                    throw new JDBCBinderException(column + " already exist in " + table);
                }
                column.setSqlTypeCode(new Integer(sqlType));
                if (this.intBounds(size)) {
                    if (this.columnHasLength(sqlType)) {
                        column.setLength(size);
                    }
                    if (this.columnHasScaleAndPrecision(sqlType)) {
                        column.setPrecision(size);
                    }
                }
                if (this.intBounds(decimalDigits) && this.columnHasScaleAndPrecision(sqlType)) {
                    column.setScale(decimalDigits);
                }
                column.setNullable(isNullable);
                table.addColumn(column);
            }
        }
        finally {
            if (columnRs != null) {
                columnRs.close();
            }
        }
    }

    private boolean columnHasScaleAndPrecision(int sqlType) {
        return sqlType == 3 || sqlType == 2 || sqlType == 7 || sqlType == 6 || sqlType == 8;
    }

    private boolean columnHasLength(int sqlType) {
        return sqlType == 1 || sqlType == 91 || sqlType == -1 || sqlType == 92 || sqlType == 93 || sqlType == 12;
    }

    private boolean intBounds(int size) {
        return size >= 0 && size != Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIndices(Table table) throws SQLException {
        HashMap<String, Index> indexes = new HashMap<String, Index>();
        HashMap<String, UniqueKey> uniquekeys = new HashMap<String, UniqueKey>();
        HashMap<Column, ArrayList<UniqueKey>> uniqueColumns = new HashMap<Column, ArrayList<UniqueKey>>();
        ResultSet indexRs = null;
        try {
            indexRs = this.getMetaData().getIndexInfo(table.getCatalog(), table.getSchema(), table.getName(), false, true);
            while (indexRs.next()) {
                boolean unique;
                String indexName = indexRs.getString("INDEX_NAME");
                String columnName = indexRs.getString("COLUMN_NAME");
                boolean bl = unique = !indexRs.getBoolean("NON_UNIQUE");
                if (columnName != null || indexName != null) {
                    Column column;
                    if (unique) {
                        UniqueKey key = (UniqueKey)uniquekeys.get(indexName);
                        if (key == null) {
                            key = new UniqueKey();
                            key.setName(indexName);
                            key.setTable(table);
                            table.addUniqueKey(key);
                            uniquekeys.put(indexName, key);
                        }
                        if (indexes.containsKey(indexName)) {
                            throw new JDBCBinderException("UniqueKey exists also as Index! ");
                        }
                        column = this.getColumn(table, columnName);
                        key.addColumn(column);
                        if (!unique || key.getColumnSpan() != 1) continue;
                        ArrayList<UniqueKey> l = (ArrayList<UniqueKey>)uniqueColumns.get(column);
                        if (l == null) {
                            l = new ArrayList<UniqueKey>();
                            uniqueColumns.put(column, l);
                        }
                        l.add(key);
                        continue;
                    }
                    Index index = (Index)indexes.get(indexName);
                    if (index == null) {
                        index = new Index();
                        index.setName(indexName);
                        index.setTable(table);
                        table.addIndex(index);
                        indexes.put(indexName, index);
                    }
                    if (uniquekeys.containsKey(indexName)) {
                        throw new JDBCBinderException("Index exists also as Unique! ");
                    }
                    column = this.getColumn(table, columnName);
                    index.addColumn(column);
                    continue;
                }
                if (0 == indexRs.getShort("TYPE")) continue;
                log.warn((Object)("Index was not statistical, but no column name was found in " + indexName));
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Exception while trying to get indexinfo on " + table.getQualifiedName(this.dialect, null, null) + "=" + t.getMessage()));
        }
        finally {
            if (indexRs != null) {
                indexRs.close();
            }
        }
        Iterator iterator = uniqueColumns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Column col = (Column)entry.getKey();
            Iterator keys = ((List)entry.getValue()).iterator();
            while (keys.hasNext()) {
                UniqueKey key = (UniqueKey)keys.next();
                if (key.getColumnSpan() != 1) continue;
                col.setUnique(true);
            }
        }
    }

    private Column getColumn(Table table, String columnName) {
        Column column = new Column();
        column.setName(columnName);
        Column existing = table.getColumn(column);
        if (existing != null) {
            column = existing;
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPrimaryKey(Table table) throws SQLException {
        ResultSet primaryKeyRs = null;
        try {
            primaryKeyRs = this.getMetaData().getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            PrimaryKey key = null;
            while (primaryKeyRs.next()) {
                String columnName = primaryKeyRs.getString("COLUMN_NAME");
                short seq = primaryKeyRs.getShort("KEY_SEQ");
                String name = primaryKeyRs.getString("PK_NAME");
                if (key == null) {
                    key = new PrimaryKey();
                    key.setName(name);
                    key.setTable(table);
                    if (table.getPrimaryKey() != null) {
                        throw new JDBCBinderException(table + " already has a primary key!");
                    }
                    table.setPrimaryKey(key);
                } else if (name != key.getName() && name != null && !name.equals(key.getName())) {
                    throw new JDBCBinderException("Duplicate names found for primarykey. Existing name: " + key.getName() + " JDBC name: " + name + " on table " + table);
                }
                columns.add(new Object[]{new Short(seq), columnName});
            }
            Collections.sort(columns, new Comparator(){

                public boolean equals(Object obj) {
                    return obj == this;
                }

                public int compare(Object o1, Object o2) {
                    Short left = (Short)((Object[])o1)[0];
                    Short right = (Short)((Object[])o2)[0];
                    return left.compareTo(right);
                }
            });
            Iterator cols = columns.iterator();
            while (cols.hasNext()) {
                Object[] element = (Object[])cols.next();
                Column col = new Column();
                col.setName((String)element[1]);
                Column existing = table.getColumn(col);
                if (existing != null) {
                    col = existing;
                }
                key.addColumn(col);
            }
            if (key == null) {
                log.warn((Object)("The JDBC driver didn't report any primary key columns in " + table.getName()));
            } else {
                log.debug((Object)("primary key for " + table + " -> " + key));
            }
        }
        finally {
            if (primaryKeyRs != null) {
                primaryKeyRs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map processForeignKeys(Table pkTable) throws JDBCBinderException, SQLException {
        HashMap foreignKeys = new HashMap();
        HashMap<String, Table> foreignTables = new HashMap<String, Table>();
        HashMap oneToManyCandidates = new HashMap();
        short bogusFkName = 0;
        ResultSet exportedKeyRs = null;
        log.debug((Object)("Calling getExportedKeys on " + pkTable));
        exportedKeyRs = this.getMetaData().getExportedKeys(pkTable.getCatalog(), pkTable.getSchema(), pkTable.getName());
        try {
            while (exportedKeyRs.next()) {
                ArrayList<Column> l;
                String fkCatalog = exportedKeyRs.getString("FKTABLE_CAT");
                String fkSchema = exportedKeyRs.getString("FKTABLE_SCHEM");
                String fkTableName = exportedKeyRs.getString("FKTABLE_NAME");
                String fkColumnName = exportedKeyRs.getString("FKCOLUMN_NAME");
                String pkColumnName = exportedKeyRs.getString("PKCOLUMN_NAME");
                String fkName = exportedKeyRs.getString("FK_NAME");
                short keySeq = exportedKeyRs.getShort("KEY_SEQ");
                log.debug((Object)("foreign key name: " + fkName));
                Table fkTable = this.mappings.getTable(fkSchema, fkCatalog, fkTableName);
                if (fkTable == null) continue;
                if (keySeq == 0) {
                    bogusFkName = (short)(bogusFkName + 1);
                }
                if (fkName == null) {
                    fkName = Short.toString(bogusFkName);
                }
                if ((l = (ArrayList<Column>)foreignKeys.get(fkName)) == null) {
                    l = new ArrayList<Column>();
                    foreignKeys.put(fkName, l);
                    foreignTables.put(fkName, fkTable);
                } else {
                    Object previousTable = foreignTables.get(fkName);
                    if (fkTable != previousTable) {
                        throw new JDBCBinderException("Foreign key name (" + fkName + ") mapped to different tables! previous: " + previousTable + " current:" + fkTable);
                    }
                }
                Column column = new Column(fkColumnName);
                Column existingColumn = fkTable.getColumn(column);
                column = existingColumn == null ? column : existingColumn;
                l.add(column);
            }
        }
        finally {
            exportedKeyRs.close();
        }
        Iterator iterator = foreignTables.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String fkName = (String)entry.getKey();
            Table fkTable = (Table)entry.getValue();
            List columns = (List)foreignKeys.get(fkName);
            String className = this.revengStrategy.tableToClassName(TableIdentifier.create(pkTable));
            ForeignKey key = fkTable.createForeignKey(fkName, columns, className);
            key.setReferencedTable(pkTable);
            this.addToMultiMap(oneToManyCandidates, className, key);
        }
        return oneToManyCandidates;
    }

    private void addToMultiMap(Map multimap, String key, Object item) {
        ArrayList<Object> existing = (ArrayList<Object>)multimap.get(key);
        if (existing == null) {
            existing = new ArrayList<Object>();
            multimap.put(key, existing);
        }
        existing.add(item);
    }

    private static Property makeProperty(String propertyName, Value value, boolean insertable, boolean updatable, boolean lazy, String cascade, String propertyAccessorName) {
        log.debug((Object)("Building property " + propertyName));
        Property prop = new Property();
        prop.setName(propertyName);
        prop.setValue(value);
        prop.setInsertable(insertable);
        prop.setUpdateable(updatable);
        prop.setLazy(lazy);
        prop.setCascade(cascade);
        prop.setPropertyAccessorName(propertyAccessorName);
        prop.setMetaAttributes(Collections.EMPTY_MAP);
        log.debug((Object)("Cascading " + propertyName + " with " + cascade));
        return prop;
    }

    private String makeUnique(Component clazz, String propertyName) {
        return JDBCBinder.makeUnique(clazz.getPropertyIterator(), propertyName);
    }

    private String makeUnique(PersistentClass clazz, String propertyName) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (clazz.hasIdentifierProperty()) {
            list.add(clazz.getIdentifierProperty());
        }
        if (clazz.isVersioned()) {
            list.add(clazz.getVersion());
        }
        JoinedIterator iterator = new JoinedIterator(list.iterator(), clazz.getPropertyClosureIterator());
        return JDBCBinder.makeUnique((Iterator)iterator, propertyName);
    }

    private static String makeUnique(Iterator props, String originalPropertyName) {
        int cnt = 0;
        String propertyName = originalPropertyName;
        HashSet<String> uniqueNames = new HashSet<String>();
        while (props.hasNext()) {
            Property element = (Property)props.next();
            uniqueNames.add(element.getName());
        }
        while (uniqueNames.contains(propertyName)) {
            propertyName = originalPropertyName + "_" + ++cnt;
        }
        return propertyName;
    }

    public static void bindCollectionSecondPass(Collection collection, Map persistentClasses, Mappings mappings, Map inheritedMetas) throws MappingException {
        if (collection.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collection.getElement();
            PersistentClass persistentClass = mappings.getClass(oneToMany.getReferencedEntityName());
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + oneToMany.getReferencedEntityName());
            }
            oneToMany.setAssociatedClass(persistentClass);
        }
    }

    static class CollectionSecondPass
    extends HbmBinder.SecondPass {
        CollectionSecondPass(Mappings mappings, Collection coll) {
            super(null, mappings, coll);
        }

        void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
            JDBCBinder.bindCollectionSecondPass(this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static class ForeignKeyForColumns {
        protected final List columns;
        protected final ForeignKey key;

        public ForeignKeyForColumns(ForeignKey key, List columns) {
            this.key = key;
            this.columns = columns;
        }
    }
}

