/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.ConfigurationVisitor;
import org.hibernate.tool.hbm2x.POJOExporter;

public class ConfigurationNavigator {
    private static final Log log = LogFactory.getLog((Class)POJOExporter.class);

    public void export(Configuration cfg, ConfigurationVisitor exporter) {
        HashMap components = new HashMap();
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            if (exporter.startMapping(cfg)) {
                PersistentClass clazz = (PersistentClass)classes.next();
                ConfigurationNavigator.collectComponents(components, clazz);
                if (exporter.startPersistentClass(clazz)) {
                    if (clazz.hasIdentifierProperty()) {
                        exporter.startIdentifierProperty(clazz.getIdentifierProperty());
                        exporter.endIdentifierProperty(clazz.getIdentifierProperty());
                    } else if (clazz.hasEmbeddedIdentifier()) {
                        exporter.startEmbeddedIdentifier((Component)clazz.getKey());
                        exporter.endEmbeddedIdentifier((Component)clazz.getKey());
                    }
                    Iterator unjoinedPropertyIterator = clazz.getUnjoinedPropertyIterator();
                    while (unjoinedPropertyIterator.hasNext()) {
                        Property prop = (Property)unjoinedPropertyIterator.next();
                        exporter.startProperty(prop);
                        exporter.endProperty(prop);
                    }
                }
                exporter.endPersistentClass(clazz);
                continue;
            }
            exporter.endMapping(cfg);
        }
        Iterator comps = components.values().iterator();
        while (comps.hasNext()) {
            Component component = (Component)comps.next();
            exporter.startComponent(component);
        }
        if (exporter.startGeneralConfiguration(cfg)) {
            exporter.endGeneralConfiguration(cfg);
        }
    }

    public static void collectComponents(Map components, PersistentClass clazz) {
        Iterator iter = new Cfg2JavaTool().getAllPropertiesIterator(clazz);
        while (iter.hasNext()) {
            Component comp;
            Component existing;
            Property property = (Property)iter.next();
            if (!(property.getValue() instanceof Component) || (existing = components.put((comp = (Component)property.getValue()).getComponentClassName(), comp)) == null) continue;
            log.warn((Object)("Component " + existing.getComponentClassName() + " found more than once!"));
        }
    }
}

