/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.XMLPrettyPrinter;

public class HibernateConfigurationExporter
extends AbstractExporter {
    private Writer output;
    private Properties customProperties = new Properties();

    public HibernateConfigurationExporter(Configuration configuration, File outputdir) {
        super(configuration, outputdir);
    }

    public HibernateConfigurationExporter() {
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
    }

    public Writer getOutput() {
        return this.output;
    }

    public void setOutput(Writer output) {
        this.output = output;
    }

    public void start() throws ExporterException {
        PrintWriter pw = null;
        File file = null;
        try {
            try {
                if (this.output == null) {
                    file = new File(this.getOutputDirectory(), "hibernate.cfg.xml");
                    pw = new PrintWriter(new FileWriter(file));
                } else {
                    pw = new PrintWriter(this.output);
                }
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE hibernate-configuration PUBLIC\r\n\t\t\"-//Hibernate/Hibernate Configuration DTD 3.0//EN\"\r\n\t\t\"http://hibernate.sourceforge.net/hibernate-configuration-3.0.dtd\">\r\n<hibernate-configuration>");
                Properties props = new Properties();
                if (this.getConfiguration() != null) {
                    props.putAll((Map<?, ?>)this.getConfiguration().getProperties());
                }
                if (this.customProperties != null) {
                    props.putAll((Map<?, ?>)this.customProperties);
                }
                String sfname = props.getProperty("hibernate.session_factory_name");
                pw.println("    <session-factory" + (sfname == null ? "" : " name=\"" + sfname + "\"") + ">");
                Set<Map.Entry<Object, Object>> set = props.entrySet();
                Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> element = iterator.next();
                    String key = (String)element.getKey();
                    if (key.equals("hibernate.session_factory_name") || !key.startsWith("hibernate.")) continue;
                    pw.println("        <property name=\"" + key + "\">" + element.getValue() + "</property>");
                }
                if (this.getConfiguration() != null) {
                    Iterator classMappings = this.getConfiguration().getClassMappings();
                    while (classMappings.hasNext()) {
                        PersistentClass element = (PersistentClass)classMappings.next();
                        if (!(element instanceof RootClass)) continue;
                        this.dump(pw, element);
                    }
                }
                pw.println("    </session-factory>\r\n</hibernate-configuration>");
            }
            catch (IOException e) {
                throw new ExporterException("Problems while creating hibernate.cfg.xml", e);
            }
            Object var10_11 = null;
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (pw != null) {
                pw.flush();
                pw.close();
            }
            throw throwable;
        }
        if (file != null) {
            try {
                XMLPrettyPrinter.prettyPrintFile(XMLPrettyPrinter.getDefaultTidy(), file, file);
            }
            catch (IOException e) {
                throw new ExporterException("Problems while creating hibernate.cfg.xml", e);
            }
        }
    }

    private void dump(PrintWriter pw, PersistentClass element) {
        pw.println("<mapping resource=\"" + this.getMappingFileResource(element) + "\"/>");
        Iterator directSubclasses = element.getDirectSubclasses();
        while (directSubclasses.hasNext()) {
            PersistentClass subclass = (PersistentClass)directSubclasses.next();
            this.dump(pw, subclass);
        }
    }

    private String getMappingFileResource(PersistentClass element) {
        return element.getClassName().replace('.', '/') + ".hbm.xml";
    }
}

