/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.hibernate.mapping.MetaAttribute;
import org.jdom.Element;

public class MetaAttributeHelper {
    protected static MultiMap loadMetaMap(Element element) {
        MultiHashMap result = new MultiHashMap();
        ArrayList metaAttributeList = new ArrayList();
        metaAttributeList.addAll(element.getChildren("meta"));
        Iterator iter = metaAttributeList.iterator();
        while (iter.hasNext()) {
            Element metaAttrib = (Element)iter.next();
            String attribute = metaAttrib.getAttribute("attribute").getValue();
            String value = metaAttrib.getText();
            String inheritStr = metaAttrib.getAttributeValue("inherit");
            boolean inherit = true;
            if (inheritStr != null) {
                inherit = Boolean.valueOf(inheritStr);
            }
            SimpleMetaAttribute ma = new SimpleMetaAttribute(value, inherit);
            result.put((Object)attribute, (Object)ma);
        }
        return result;
    }

    public static MultiMap mergeMetaMaps(MultiMap local, MultiMap inherited) {
        MultiHashMap result = new MultiHashMap();
        MetaAttributeHelper.copyMultiMap((MultiMap)result, local);
        if (inherited != null) {
            Iterator iter = inherited.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (local.containsKey((Object)key)) continue;
                Collection ml = (Collection)inherited.get((Object)key);
                Iterator iterator = ml.iterator();
                while (iterator.hasNext()) {
                    SimpleMetaAttribute element = (SimpleMetaAttribute)iterator.next();
                    if (!element.inheritable) continue;
                    result.put((Object)key, (Object)element);
                }
            }
        }
        return result;
    }

    public static MultiMap loadAndMergeMetaMap(Element classElement, MultiMap inheritedMeta) {
        return MetaAttributeHelper.mergeMetaMaps(MetaAttributeHelper.loadMetaMap(classElement), inheritedMeta);
    }

    public static String getMetaAsString(Collection meta, String seperator) {
        if (meta == null || meta.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = meta.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(seperator);
        }
        return buf.toString();
    }

    public static String getMetaAsString(MetaAttribute meta, String seperator) {
        if (meta == null) {
            return null;
        }
        return MetaAttributeHelper.getMetaAsString(meta.getValues(), seperator);
    }

    static boolean getMetaAsBool(Collection c, boolean defaultValue) {
        if (c == null || c.isEmpty()) {
            return defaultValue;
        }
        return Boolean.valueOf(c.iterator().next().toString());
    }

    public static String getMetaAsString(MetaAttribute c) {
        return c == null ? "" : MetaAttributeHelper.getMetaAsString(c.getValues());
    }

    static String getMetaAsString(Collection c) {
        return MetaAttributeHelper.getMetaAsString(c, "");
    }

    public static void copyMultiMap(MultiMap destination, MultiMap source) {
        Iterator keyIterator = source.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            Collection c = (Collection)source.get(key);
            Iterator valueIterator = c.iterator();
            while (valueIterator.hasNext()) {
                destination.put(key, valueIterator.next());
            }
        }
    }

    public static boolean getMetaAsBool(MetaAttribute metaAttribute, boolean defaultValue) {
        return MetaAttributeHelper.getMetaAsBool(metaAttribute == null ? null : metaAttribute.getValues(), defaultValue);
    }

    static class SimpleMetaAttribute {
        String value;
        boolean inheritable = true;

        SimpleMetaAttribute(String value, boolean inherit) {
            this.value = value;
            this.inheritable = inherit;
        }

        public String toString() {
            return this.value;
        }
    }
}

