/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.Referenceable;
import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.ErrorCodes;
import io.apigee.trireme.kernel.handles.Handle;
import io.apigee.trireme.kernel.handles.IOCompletionHandler;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaStreamWrap
implements InternalNodeModule {
    private static final Logger log = LoggerFactory.getLogger((String)JavaStreamWrap.class.getName());
    public static final String MODULE_NAME = "java_stream_wrap";

    public String getModuleName() {
        return MODULE_NAME;
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runtime) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Scriptable exports = cx.newObject(scope);
        exports.setPrototype(scope);
        exports.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)exports, Referenceable.class);
        ScriptableObject.defineClass((Scriptable)exports, StreamWrapImpl.class);
        return exports;
    }

    public static class StreamWrapImpl
    extends Referenceable {
        public static final String CLASS_NAME = "JavaStream";
        protected int byteCount;
        private Function onRead;
        protected ScriptRunner runtime;
        private Handle handle;
        private boolean reading;

        public String getClassName() {
            return CLASS_NAME;
        }

        public StreamWrapImpl() {
        }

        protected StreamWrapImpl(Handle handle, ScriptRunner runtime) {
            this.handle = handle;
            this.runtime = runtime;
        }

        @JSConstructor
        public static Object construct(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            if (!inNewExpr) {
                return cx.newObject((Scriptable)ctorObj, CLASS_NAME, args);
            }
            ScriptRunner runtime = (ScriptRunner)cx.getThreadLocal((Object)"runner");
            Handle handle = (Handle)ArgUtils.objArg((Object[])args, (int)0, Handle.class, (boolean)true);
            return new StreamWrapImpl(handle, runtime);
        }

        @JSGetter(value="bytes")
        public int getByteCount() {
            return this.byteCount;
        }

        @JSGetter(value="writeQueueSize")
        public int getWriteQueueSize() {
            return this.handle.getWritesOutstanding();
        }

        @JSSetter(value="onread")
        public void setOnRead(Function r) {
            this.onRead = r;
        }

        @JSGetter(value="onread")
        public Function getOnRead() {
            return this.onRead;
        }

        @JSFunction
        public static void close(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Function cb = ArgUtils.functionArg((Object[])args, (int)0, (boolean)false);
            StreamWrapImpl self = (StreamWrapImpl)thisObj;
            self.readStop();
            self.handle.close();
            self.close();
            if (cb != null) {
                self.runtime.enqueueCallback(cb, (Scriptable)self, null, (Object)((Scriptable)self.runtime.getDomain()), ScriptRuntime.emptyArgs);
            }
        }

        @JSFunction
        public static Object writeBuffer(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Buffer.BufferImpl buf = (Buffer.BufferImpl)ArgUtils.objArg((Object[])args, (int)0, Buffer.BufferImpl.class, (boolean)true);
            final StreamWrapImpl self = (StreamWrapImpl)thisObj;
            final Scriptable req = cx.newObject((Scriptable)self);
            int len = self.handle.write(buf.getBuffer(), (IOCompletionHandler)new IOCompletionHandler<Integer>(){

                public void ioComplete(int errCode, Integer value) {
                    self.writeComplete(errCode, value, req);
                }
            });
            self.updateByteCount(req, len);
            return req;
        }

        @JSFunction
        public static Object writeUtf8String(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String s = ArgUtils.stringArg((Object[])args, (int)0);
            return ((StreamWrapImpl)thisObj).doWrite(cx, s, Charsets.UTF8);
        }

        @JSFunction
        public static Object writeAsciiString(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String s = ArgUtils.stringArg((Object[])args, (int)0);
            return ((StreamWrapImpl)thisObj).doWrite(cx, s, Charsets.ASCII);
        }

        @JSFunction
        public static Object writeUcs2String(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String s = ArgUtils.stringArg((Object[])args, (int)0);
            return ((StreamWrapImpl)thisObj).doWrite(cx, s, Charsets.UCS2);
        }

        private Scriptable doWrite(Context cx, String s, Charset cs) {
            final Scriptable req = cx.newObject((Scriptable)this);
            int len = this.handle.write(s, cs, (IOCompletionHandler)new IOCompletionHandler<Integer>(){

                public void ioComplete(int errCode, Integer value) {
                    StreamWrapImpl.this.writeComplete(errCode, value, req);
                }
            });
            this.updateByteCount(req, len);
            return req;
        }

        private void updateByteCount(Scriptable req, int len) {
            req.put("bytes", req, (Object)len);
            this.byteCount += len;
        }

        protected void writeComplete(final int err, int len, final Scriptable req) {
            this.runtime.enqueueTask(new ScriptTask(){

                public void execute(Context cx, Scriptable scope) {
                    Object onComplete = ScriptableObject.getProperty((Scriptable)req, (String)"oncomplete");
                    if (onComplete != null && !Undefined.instance.equals(onComplete)) {
                        Function afterWrite = (Function)onComplete;
                        Object errStr = err == 0 ? Undefined.instance : ErrorCodes.get().toString(err);
                        afterWrite.call(cx, (Scriptable)afterWrite, (Scriptable)StreamWrapImpl.this, new Object[]{errStr, StreamWrapImpl.this, req});
                    }
                }
            });
        }

        @JSFunction
        public void readStart() {
            if (!this.reading) {
                this.handle.startReading((IOCompletionHandler)new IOCompletionHandler<ByteBuffer>(){

                    public void ioComplete(int errCode, ByteBuffer value) {
                        StreamWrapImpl.this.onRead(errCode, value);
                    }
                });
                this.reading = true;
            }
        }

        @JSFunction
        public void readStop() {
            if (this.reading) {
                this.handle.stopReading();
                this.reading = false;
            }
        }

        protected void onRead(int err, ByteBuffer buf) {
            Context cx = Context.getCurrentContext();
            if (this.onRead != null) {
                Buffer.BufferImpl jBuf;
                Buffer.BufferImpl bufferImpl = jBuf = buf == null ? null : Buffer.BufferImpl.newBuffer((Context)cx, (Scriptable)this, (ByteBuffer)buf, (boolean)false);
                if (err == 0) {
                    this.runtime.clearErrno();
                } else {
                    this.runtime.setErrno(ErrorCodes.get().toString(err));
                }
                this.onRead.call(cx, (Scriptable)this.onRead, (Scriptable)this, new Object[]{jBuf, 0, buf == null ? 0 : buf.remaining()});
            }
        }
    }
}

