/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ExceptionMetered;
import io.astefanutti.metrics.cdi.MetricResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@ExceptionMetered
@Priority(value=1010)
class ExceptionMeteredInterceptor {
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private ExceptionMeteredInterceptor(MetricRegistry registry, MetricResolver resolver) {
        this.registry = registry;
        this.resolver = resolver;
    }

    @AroundConstruct
    private Object meteredConstructor(InvocationContext context) throws Throwable {
        return this.meteredCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object meteredMethod(InvocationContext context) throws Throwable {
        return this.meteredCallable(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object meteredCallable(InvocationContext context, E element) throws Throwable {
        MetricResolver.Of<ExceptionMetered> exceptionMetered = this.resolver.exceptionMetered(element);
        Meter meter = (Meter)this.registry.getMetrics().get(exceptionMetered.metricName());
        if (meter == null) {
            throw new IllegalStateException("No meter with name [" + exceptionMetered.metricName() + "] found in registry [" + this.registry + "]");
        }
        try {
            return context.proceed();
        }
        catch (Throwable throwable) {
            if (exceptionMetered.metricAnnotation().cause().isInstance(throwable)) {
                meter.mark();
            }
            throw throwable;
        }
    }
}

