/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.astefanutti.metrics.cdi.MetricName;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;

@Alternative
@Dependent
@Priority(value=1000)
final class MetricProducer {
    MetricProducer() {
    }

    @Produces
    private static Counter counter(InjectionPoint ip, MetricRegistry registry, MetricName metricName) {
        return registry.counter(metricName.of(ip));
    }

    @Produces
    private static <T> Gauge<T> gauge(final InjectionPoint ip, final MetricRegistry registry, final MetricName metricName) {
        return new Gauge<T>(){

            public T getValue() {
                return ((Gauge)registry.getGauges().get(metricName.of(ip))).getValue();
            }
        };
    }

    @Produces
    private static Histogram histogram(InjectionPoint ip, MetricRegistry registry, MetricName metricName) {
        return registry.histogram(metricName.of(ip));
    }

    @Produces
    private static Meter meter(InjectionPoint ip, MetricRegistry registry, MetricName metricName) {
        return registry.meter(metricName.of(ip));
    }

    @Produces
    private static Timer timer(InjectionPoint ip, MetricRegistry registry, MetricName metricName) {
        return registry.timer(metricName.of(ip));
    }
}

