/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.CachedGauge;
import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Gauge;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import io.astefanutti.metrics.cdi.MetricName;
import io.astefanutti.metrics.cdi.MetricsExtension;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;

@ApplicationScoped
class MetricResolver {
    @Inject
    private MetricsExtension extension;
    @Inject
    private MetricName metricName;

    MetricResolver() {
    }

    Of<CachedGauge> cachedGauge(Method method) {
        return this.resolverOf(method, CachedGauge.class);
    }

    <E extends Member & AnnotatedElement> Of<Counted> counted(E element) {
        return this.resolverOf(element, (Class)Counted.class);
    }

    <E extends Member & AnnotatedElement> Of<ExceptionMetered> exceptionMetered(E element) {
        return this.resolverOf(element, (Class)ExceptionMetered.class);
    }

    Of<Gauge> gauge(Method method) {
        return this.resolverOf(method, Gauge.class);
    }

    <E extends Member & AnnotatedElement> Of<Metered> metered(E element) {
        return this.resolverOf(element, (Class)Metered.class);
    }

    <E extends Member & AnnotatedElement> Of<Timed> timed(E element) {
        return this.resolverOf(element, (Class)Timed.class);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> resolverOf(E element, Class<T> type) {
        if (((AnnotatedElement)element).isAnnotationPresent(type)) {
            T annotation = ((AnnotatedElement)element).getAnnotation(type);
            String name = this.metricName(element, (Class<? extends Annotation>)type, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
            return new DoesHaveMetric((Annotation)annotation, name, null);
        }
        Class<?> bean = element.getDeclaringClass();
        if (bean.isAnnotationPresent(type)) {
            T annotation = bean.getAnnotation(type);
            String name = this.metricName(bean, element, (Class<? extends Annotation>)type, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
            return new DoesHaveMetric((Annotation)annotation, name, null);
        }
        return new DoesNotHaveMetric();
    }

    private <E extends Member & AnnotatedElement> String metricName(E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? this.defaultName(element, type) : this.metricName.of(name);
        return absolute ? metric : MetricRegistry.name(element.getDeclaringClass(), (String[])new String[]{metric});
    }

    private <E extends Member & AnnotatedElement> String metricName(Class<?> bean, E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? bean.getSimpleName() : this.metricName.of(name);
        return absolute ? MetricRegistry.name((String)metric, (String[])new String[]{this.defaultName(element, type)}) : MetricRegistry.name((String)bean.getPackage().getName(), (String[])new String[]{metric, this.defaultName(element, type)});
    }

    private <E extends Member & AnnotatedElement> String defaultName(E element, Class<? extends Annotation> type) {
        if (ExceptionMetered.class.equals(type)) {
            return MetricRegistry.name((String)this.memberName(element), (String[])new String[]{"exceptions"});
        }
        return this.memberName(element);
    }

    private String memberName(Member member) {
        if (member instanceof Constructor) {
            return member.getDeclaringClass().getSimpleName();
        }
        return member.getName();
    }

    private String metricName(Annotation annotation) {
        if (CachedGauge.class.isInstance(annotation)) {
            return ((CachedGauge)annotation).name();
        }
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).name();
        }
        if (ExceptionMetered.class.isInstance(annotation)) {
            return ((ExceptionMetered)annotation).name();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).name();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).name();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).name();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private boolean isMetricAbsolute(Annotation annotation) {
        if (this.extension.getParameters().contains((Object)MetricsParameter.useAbsoluteName)) {
            return true;
        }
        if (CachedGauge.class.isInstance(annotation)) {
            return ((CachedGauge)annotation).absolute();
        }
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).absolute();
        }
        if (ExceptionMetered.class.isInstance(annotation)) {
            return ((ExceptionMetered)annotation).absolute();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).absolute();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).absolute();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).absolute();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    @Vetoed
    private static final class DoesNotHaveMetric<T extends Annotation>
    implements Of<T> {
        private DoesNotHaveMetric() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public String metricName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T metricAnnotation() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DoesHaveMetric<T extends Annotation>
    implements Of<T> {
        private final T annotation;
        private final String name;

        private DoesHaveMetric(T annotation, String name) {
            this.annotation = annotation;
            this.name = name;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String metricName() {
            return this.name;
        }

        @Override
        public T metricAnnotation() {
            return this.annotation;
        }

        /* synthetic */ DoesHaveMetric(Annotation x0, String x1, 1 x2) {
            this(x0, x1);
        }
    }

    static interface Of<T extends Annotation> {
        public boolean isPresent();

        public String metricName();

        public T metricAnnotation();
    }
}

