/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import io.astefanutti.metrics.cdi.MetricsConfiguration;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

final class MetricsConfigurationEvent
implements MetricsConfiguration {
    private final EnumSet<MetricsParameter> configuration = EnumSet.noneOf(MetricsParameter.class);
    private volatile boolean unmodifiable;

    MetricsConfigurationEvent() {
    }

    @Override
    public MetricsConfiguration useAbsoluteName(boolean useAbsoluteName) {
        this.throwsIfUnmodifiable();
        if (useAbsoluteName) {
            this.configuration.add(MetricsParameter.useAbsoluteName);
        } else {
            this.configuration.remove((Object)MetricsParameter.useAbsoluteName);
        }
        return this;
    }

    Set<MetricsParameter> getParameters() {
        return Collections.unmodifiableSet(this.configuration);
    }

    void unmodifiable() {
        this.unmodifiable = true;
    }

    private void throwsIfUnmodifiable() {
        if (this.unmodifiable) {
            throw new IllegalStateException("Metrics CDI configuration event must not be used outside its observer method!");
        }
    }
}

