/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.annotation.CachedGauge;
import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Gauge;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import io.astefanutti.metrics.cdi.AnnotatedMethodDecorator;
import io.astefanutti.metrics.cdi.AnnotatedTypeDecorator;
import io.astefanutti.metrics.cdi.MetricName;
import io.astefanutti.metrics.cdi.MetricProducer;
import io.astefanutti.metrics.cdi.MetricRegistryBean;
import io.astefanutti.metrics.cdi.MetricsBinding;
import io.astefanutti.metrics.cdi.MetricsConfigurationEvent;
import io.astefanutti.metrics.cdi.MetricsParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.interceptor.InterceptorBinding;

public class MetricsExtension
implements Extension {
    private static final AnnotationLiteral<Nonbinding> NON_BINDING = new AnnotationLiteral<Nonbinding>(){};
    private static final AnnotationLiteral<InterceptorBinding> INTERCEPTOR_BINDING = new AnnotationLiteral<InterceptorBinding>(){};
    private static final AnnotationLiteral<MetricsBinding> METRICS_BINDING = new AnnotationLiteral<MetricsBinding>(){};
    private final Map<Bean<?>, AnnotatedMember<?>> metrics = new HashMap();
    private final MetricsConfigurationEvent configuration = new MetricsConfigurationEvent();

    Set<MetricsParameter> getParameters() {
        return this.configuration.getParameters();
    }

    private void addInterceptorBindings(@Observes BeforeBeanDiscovery bbd, BeanManager manager) {
        MetricsExtension.declareAsInterceptorBinding(Counted.class, manager, bbd);
        MetricsExtension.declareAsInterceptorBinding(ExceptionMetered.class, manager, bbd);
        MetricsExtension.declareAsInterceptorBinding(Metered.class, manager, bbd);
        MetricsExtension.declareAsInterceptorBinding(Timed.class, manager, bbd);
    }

    private <X> void metricsAnnotations(@Observes @WithAnnotations(value={CachedGauge.class, Counted.class, ExceptionMetered.class, Gauge.class, Metered.class, Timed.class}) ProcessAnnotatedType<X> pat) {
        pat.setAnnotatedType(new AnnotatedTypeDecorator(pat.getAnnotatedType(), (Annotation)METRICS_BINDING));
    }

    private void metricProducerField(@Observes ProcessProducerField<? extends Metric, ?> ppf) {
        this.metrics.put((Bean<?>)ppf.getBean(), (AnnotatedMember<?>)ppf.getAnnotatedProducerField());
    }

    private void metricProducerMethod(@Observes ProcessProducerMethod<? extends Metric, ?> ppm) {
        if (!ppm.getBean().getBeanClass().equals(MetricProducer.class)) {
            this.metrics.put((Bean<?>)ppm.getBean(), (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod());
        }
    }

    private void defaultMetricRegistry(@Observes AfterBeanDiscovery abd, BeanManager manager) {
        if (manager.getBeans(MetricRegistry.class, new Annotation[0]).isEmpty()) {
            abd.addBean((Bean)new MetricRegistryBean(manager));
        }
    }

    private void configuration(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        manager.fireEvent((Object)this.configuration, new Annotation[0]);
        this.configuration.unmodifiable();
        MetricRegistry registry = MetricsExtension.getReference(manager, MetricRegistry.class);
        MetricName name = MetricsExtension.getReference(manager, MetricName.class);
        for (Map.Entry<Bean<?>, AnnotatedMember<?>> bean : this.metrics.entrySet()) {
            if (bean.getKey().getTypes().contains(MetricSet.class)) continue;
            registry.register(name.of(bean.getValue()), (Metric)MetricsExtension.getReference(manager, bean.getValue().getBaseType(), bean.getKey()));
        }
        this.metrics.clear();
    }

    private static <T extends Annotation> void declareAsInterceptorBinding(Class<T> annotation, BeanManager manager, BeforeBeanDiscovery bbd) {
        AnnotatedType annotated = manager.createAnnotatedType(annotation);
        HashSet methods = new HashSet();
        for (AnnotatedMethod method : annotated.getMethods()) {
            methods.add(new AnnotatedMethodDecorator(method, (Annotation)NON_BINDING));
        }
        bbd.addInterceptorBinding(new AnnotatedTypeDecorator(annotated, (Annotation)INTERCEPTOR_BINDING, methods));
    }

    private static <T> T getReference(BeanManager manager, Class<T> type) {
        return MetricsExtension.getReference(manager, type, manager.resolve(manager.getBeans(type, new Annotation[0])));
    }

    private static <T> T getReference(BeanManager manager, Type type, Bean<?> bean) {
        return (T)manager.getReference(bean, type, manager.createCreationalContext(bean));
    }
}

