/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.CachedGauge;
import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import io.astefanutti.metrics.cdi.MetricResolver;
import io.astefanutti.metrics.cdi.MetricsBinding;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.TimeUnit;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@MetricsBinding
@Priority(value=1000)
class MetricsInterceptor {
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private MetricsInterceptor(MetricRegistry registry, MetricResolver resolver) {
        this.registry = registry;
        this.resolver = resolver;
    }

    @AroundConstruct
    private Object metrics(InvocationContext context) throws Exception {
        this.registerMetrics(context.getConstructor());
        Class bean = context.getConstructor().getDeclaringClass();
        do {
            for (Method method : bean.getDeclaredMethods()) {
                if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                this.registerMetrics(method);
            }
        } while (!Object.class.equals(bean = bean.getSuperclass()));
        Object target = context.proceed();
        bean = context.getConstructor().getDeclaringClass();
        do {
            for (Method method : bean.getDeclaredMethods()) {
                MetricResolver.Of<com.codahale.metrics.annotation.Gauge> gauge;
                MetricResolver.Of<CachedGauge> cachedGauge = this.resolver.cachedGauge(method);
                if (cachedGauge.isPresent()) {
                    this.registry.register(cachedGauge.metricName(), (Metric)new CachingGauge(new ForwardingGauge(method, context.getTarget()), cachedGauge.metricAnnotation().timeout(), cachedGauge.metricAnnotation().timeoutUnit()));
                }
                if (!(gauge = this.resolver.gauge(method)).isPresent()) continue;
                this.registry.register(gauge.metricName(), (Metric)new ForwardingGauge(method, context.getTarget()));
            }
        } while (!Object.class.equals(bean = bean.getSuperclass()));
        return target;
    }

    private <E extends Member & AnnotatedElement> void registerMetrics(E element) {
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<Metered> metered;
        MetricResolver.Of<ExceptionMetered> exceptionMetered;
        MetricResolver.Of<Counted> counted = this.resolver.counted(element);
        if (counted.isPresent()) {
            this.registry.counter(counted.metricName());
        }
        if ((exceptionMetered = this.resolver.exceptionMetered(element)).isPresent()) {
            this.registry.meter(exceptionMetered.metricName());
        }
        if ((metered = this.resolver.metered(element)).isPresent()) {
            this.registry.meter(metered.metricName());
        }
        if ((timed = this.resolver.timed(element)).isPresent()) {
            this.registry.timer(timed.metricName());
        }
    }

    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }

    private static final class ForwardingGauge
    implements Gauge<Object> {
        private final Method method;
        private final Object object;

        private ForwardingGauge(Method method, Object object) {
            this.method = method;
            this.object = object;
            method.setAccessible(true);
        }

        public Object getValue() {
            return MetricsInterceptor.invokeMethod(this.method, this.object);
        }
    }

    private static final class CachingGauge
    extends com.codahale.metrics.CachedGauge<Object> {
        private final Gauge<?> gauge;

        private CachingGauge(Gauge<?> gauge, long timeout, TimeUnit timeoutUnit) {
            super(timeout, timeoutUnit);
            this.gauge = gauge;
        }

        protected Object loadValue() {
            return this.gauge.getValue();
        }
    }
}

