package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.docker.api.builder.Predicate;

public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{


    public Boolean isAttachStderr();
    public A withAttachStderr(Boolean AttachStderr);
    public Boolean hasAttachStderr();
    public Boolean isAttachStdin();
    public A withAttachStdin(Boolean AttachStdin);
    public Boolean hasAttachStdin();
    public Boolean isAttachStdout();
    public A withAttachStdout(Boolean AttachStdout);
    public Boolean hasAttachStdout();
    public A addToCmd(int index,String item);
    public A setToCmd(int index,String item);
    public A addToCmd(String... items);
    public A addAllToCmd(Collection<String> items);
    public A removeFromCmd(String... items);
    public A removeAllFromCmd(Collection<String> items);
    public List<String> getCmd();
    public String getCmd(int index);
    public String getFirstCmd();
    public String getLastCmd();
    public String getMatchingCmd(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withCmd(List<String> Cmd);
    public A withCmd(String... Cmd);
    public Boolean hasCmd();
    public String getDomainname();
    public A withDomainname(String Domainname);
    public Boolean hasDomainname();
    public A addToEntrypoint(int index,String item);
    public A setToEntrypoint(int index,String item);
    public A addToEntrypoint(String... items);
    public A addAllToEntrypoint(Collection<String> items);
    public A removeFromEntrypoint(String... items);
    public A removeAllFromEntrypoint(Collection<String> items);
    public List<String> getEntrypoint();
    public String getEntrypoint(int index);
    public String getFirstEntrypoint();
    public String getLastEntrypoint();
    public String getMatchingEntrypoint(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withEntrypoint(List<String> Entrypoint);
    public A withEntrypoint(String... Entrypoint);
    public Boolean hasEntrypoint();
    public A addToEnv(int index,String item);
    public A setToEnv(int index,String item);
    public A addToEnv(String... items);
    public A addAllToEnv(Collection<String> items);
    public A removeFromEnv(String... items);
    public A removeAllFromEnv(Collection<String> items);
    public List<String> getEnv();
    public String getEnv(int index);
    public String getFirstEnv();
    public String getLastEnv();
    public String getMatchingEnv(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withEnv(List<String> Env);
    public A withEnv(String... Env);
    public Boolean hasEnv();
    public A addToExposedPorts(String key,Object value);
    public A addToExposedPorts(Map<String,Object> map);
    public A removeFromExposedPorts(String key);
    public A removeFromExposedPorts(Map<String,Object> map);
    public Map<String,Object> getExposedPorts();
    public A withExposedPorts(Map<String,Object> ExposedPorts);
    public Boolean hasExposedPorts();
    public String getHostname();
    public A withHostname(String Hostname);
    public Boolean hasHostname();
    public String getImage();
    public A withImage(String Image);
    public Boolean hasImage();
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> Labels);
    public Boolean hasLabels();
    public String getMacAddress();
    public A withMacAddress(String MacAddress);
    public Boolean hasMacAddress();
    public Boolean isNetworkDisabled();
    public A withNetworkDisabled(Boolean NetworkDisabled);
    public Boolean hasNetworkDisabled();
    public A addToOnBuild(int index,String item);
    public A setToOnBuild(int index,String item);
    public A addToOnBuild(String... items);
    public A addAllToOnBuild(Collection<String> items);
    public A removeFromOnBuild(String... items);
    public A removeAllFromOnBuild(Collection<String> items);
    public List<String> getOnBuild();
    public String getOnBuild(int index);
    public String getFirstOnBuild();
    public String getLastOnBuild();
    public String getMatchingOnBuild(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withOnBuild(List<String> OnBuild);
    public A withOnBuild(String... OnBuild);
    public Boolean hasOnBuild();
    public Boolean isOpenStdin();
    public A withOpenStdin(Boolean OpenStdin);
    public Boolean hasOpenStdin();
    public String getPublishService();
    public A withPublishService(String PublishService);
    public Boolean hasPublishService();
    public Boolean isStdinOnce();
    public A withStdinOnce(Boolean StdinOnce);
    public Boolean hasStdinOnce();
    public String getStopSignal();
    public A withStopSignal(String StopSignal);
    public Boolean hasStopSignal();
    public Boolean isTty();
    public A withTty(Boolean Tty);
    public Boolean hasTty();
    public String getUser();
    public A withUser(String User);
    public Boolean hasUser();
    public A addToVolumes(String key,Object value);
    public A addToVolumes(Map<String,Object> map);
    public A removeFromVolumes(String key);
    public A removeFromVolumes(Map<String,Object> map);
    public Map<String,Object> getVolumes();
    public A withVolumes(Map<String,Object> Volumes);
    public Boolean hasVolumes();
    public String getWorkingDir();
    public A withWorkingDir(String WorkingDir);
    public Boolean hasWorkingDir();



}
