package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.docker.api.builder.Predicate;

public interface ContainerCreateResponseFluent<A extends ContainerCreateResponseFluent<A>> extends Fluent<A>{


    public String getId();
    public A withId(String Id);
    public Boolean hasId();
    public A addToWarnings(int index,String item);
    public A setToWarnings(int index,String item);
    public A addToWarnings(String... items);
    public A addAllToWarnings(Collection<String> items);
    public A removeFromWarnings(String... items);
    public A removeAllFromWarnings(Collection<String> items);
    public List<String> getWarnings();
    public String getWarning(int index);
    public String getFirstWarning();
    public String getLastWarning();
    public String getMatchingWarning(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withWarnings(List<String> Warnings);
    public A withWarnings(String... Warnings);
    public Boolean hasWarnings();



}
