package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class ContainerInspectFluentImpl<A extends ContainerInspectFluent<A>> extends ContainerJSONBaseFluentImpl<A> implements ContainerInspectFluent<A>{

    private ConfigBuilder Config;
    private List<MountPointBuilder> Mounts =  new ArrayList<MountPointBuilder>();
    private NetworkSettingsBuilder NetworkSettings;

    public ContainerInspectFluentImpl(){
    }
    public ContainerInspectFluentImpl(ContainerInspect instance){
            this.withAppArmorProfile(instance.getAppArmorProfile()); 
            this.withArgs(instance.getArgs()); 
            this.withCreated(instance.getCreated()); 
            this.withDriver(instance.getDriver()); 
            this.withExecDriver(instance.getExecDriver()); 
            this.withExecIDs(instance.getExecIDs()); 
            this.withGraphDriver(instance.getGraphDriver()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withHostnamePath(instance.getHostnamePath()); 
            this.withHostsPath(instance.getHostsPath()); 
            this.withId(instance.getId()); 
            this.withImage(instance.getImage()); 
            this.withLogPath(instance.getLogPath()); 
            this.withMountLabel(instance.getMountLabel()); 
            this.withName(instance.getName()); 
            this.withPath(instance.getPath()); 
            this.withProcessLabel(instance.getProcessLabel()); 
            this.withResolvConfPath(instance.getResolvConfPath()); 
            this.withRestartCount(instance.getRestartCount()); 
            this.withSizeRootFs(instance.getSizeRootFs()); 
            this.withSizeRw(instance.getSizeRw()); 
            this.withState(instance.getState()); 
            this.withConfig(instance.getConfig()); 
            this.withMounts(instance.getMounts()); 
            this.withNetworkSettings(instance.getNetworkSettings()); 
            this.withConfig(instance.getConfig());

            this.withMounts(instance.getMounts());

            this.withNetworkSettings(instance.getNetworkSettings());

    }

    
/**
 * This method has been deprecated, please use method buildConfig instead.
 */
@Deprecated public Config getConfig(){
            return this.Config!=null?this.Config.build():null;
    }

    public Config buildConfig(){
            return this.Config!=null?this.Config.build():null;
    }

    public A withConfig(Config Config){
            _visitables.remove(this.Config);
            if (Config!=null){ this.Config= new ConfigBuilder(Config); _visitables.add(this.Config);} return (A) this;
    }

    public Boolean hasConfig(){
            return this.Config!=null;
    }

    public ContainerInspectFluent.ConfigNested<A> withNewConfig(){
            return new ConfigNestedImpl();
    }

    public ContainerInspectFluent.ConfigNested<A> withNewConfigLike(Config item){
            return new ConfigNestedImpl(item);
    }

    public ContainerInspectFluent.ConfigNested<A> editConfig(){
            return withNewConfigLike(getConfig());
    }

    public ContainerInspectFluent.ConfigNested<A> editOrNewConfig(){
            return withNewConfigLike(getConfig() != null ? getConfig(): new ConfigBuilder().build());
    }

    public ContainerInspectFluent.ConfigNested<A> editOrNewConfigLike(Config item){
            return withNewConfigLike(getConfig() != null ? getConfig(): item);
    }

    public A addToMounts(int index,MountPoint item){
            MountPointBuilder builder = new MountPointBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.Mounts.add(index >= 0 ? index : Mounts.size(), builder); return (A)this;
    }

    public A setToMounts(int index,MountPoint item){
            MountPointBuilder builder = new MountPointBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= Mounts.size()) { Mounts.add(builder); } else { Mounts.set(index, builder);}
             return (A)this;
    }

    public A addToMounts(MountPoint... items){
            for (MountPoint item : items) {MountPointBuilder builder = new MountPointBuilder(item);_visitables.add(builder);this.Mounts.add(builder);} return (A)this;
    }

    public A addAllToMounts(Collection<MountPoint> items){
            for (MountPoint item : items) {MountPointBuilder builder = new MountPointBuilder(item);_visitables.add(builder);this.Mounts.add(builder);} return (A)this;
    }

    public A removeFromMounts(MountPoint... items){
            for (MountPoint item : items) {MountPointBuilder builder = new MountPointBuilder(item);_visitables.remove(builder);this.Mounts.remove(builder);} return (A)this;
    }

    public A removeAllFromMounts(Collection<MountPoint> items){
            for (MountPoint item : items) {MountPointBuilder builder = new MountPointBuilder(item);_visitables.remove(builder);this.Mounts.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMounts instead.
 */
@Deprecated public List<MountPoint> getMounts(){
            return build(Mounts);
    }

    public List<MountPoint> buildMounts(){
            return build(Mounts);
    }

    public MountPoint buildMount(int index){
            return this.Mounts.get(index).build();
    }

    public MountPoint buildFirstMount(){
            return this.Mounts.get(0).build();
    }

    public MountPoint buildLastMount(){
            return this.Mounts.get(Mounts.size() - 1).build();
    }

    public MountPoint buildMatchingMount(io.fabric8.docker.api.builder.Predicate<MountPointBuilder> predicate){
            for (MountPointBuilder item: Mounts) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withMounts(List<MountPoint> Mounts){
            _visitables.removeAll(this.Mounts);
            this.Mounts.clear();
            if (Mounts != null) {for (MountPoint item : Mounts){this.addToMounts(item);}} return (A) this;
    }

    public A withMounts(MountPoint... Mounts){
            this.Mounts.clear(); if (Mounts != null) {for (MountPoint item :Mounts){ this.addToMounts(item);}} return (A) this;
    }

    public Boolean hasMounts(){
            return Mounts!= null && !Mounts.isEmpty();
    }

    public ContainerInspectFluent.MountsNested<A> addNewMount(){
            return new MountsNestedImpl();
    }

    public ContainerInspectFluent.MountsNested<A> addNewMountLike(MountPoint item){
            return new MountsNestedImpl(-1, item);
    }

    public ContainerInspectFluent.MountsNested<A> setNewMountLike(int index,MountPoint item){
            return new MountsNestedImpl(index, item);
    }

    public ContainerInspectFluent.MountsNested<A> editMount(int index){
            if (Mounts.size() <= index) throw new RuntimeException("Can't edit Mounts. Index exceeds size.");
            return setNewMountLike(index, buildMount(index));
    }

    public ContainerInspectFluent.MountsNested<A> editFirstMount(){
            if (Mounts.size() == 0) throw new RuntimeException("Can't edit first Mounts. The list is empty.");
            return setNewMountLike(0, buildMount(0));
    }

    public ContainerInspectFluent.MountsNested<A> editLastMount(){
            int index = Mounts.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last Mounts. The list is empty.");
            return setNewMountLike(index, buildMount(index));
    }

    public ContainerInspectFluent.MountsNested<A> editMatchingMount(io.fabric8.docker.api.builder.Predicate<MountPointBuilder> predicate){
            int index = -1;
            for (int i=0;i<Mounts.size();i++) { 
            if (predicate.apply(Mounts.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching Mounts. No match found.");
            return setNewMountLike(index, buildMount(index));
    }

    
/**
 * This method has been deprecated, please use method buildNetworkSettings instead.
 */
@Deprecated public NetworkSettings getNetworkSettings(){
            return this.NetworkSettings!=null?this.NetworkSettings.build():null;
    }

    public NetworkSettings buildNetworkSettings(){
            return this.NetworkSettings!=null?this.NetworkSettings.build():null;
    }

    public A withNetworkSettings(NetworkSettings NetworkSettings){
            _visitables.remove(this.NetworkSettings);
            if (NetworkSettings!=null){ this.NetworkSettings= new NetworkSettingsBuilder(NetworkSettings); _visitables.add(this.NetworkSettings);} return (A) this;
    }

    public Boolean hasNetworkSettings(){
            return this.NetworkSettings!=null;
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> withNewNetworkSettings(){
            return new NetworkSettingsNestedImpl();
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> withNewNetworkSettingsLike(NetworkSettings item){
            return new NetworkSettingsNestedImpl(item);
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> editNetworkSettings(){
            return withNewNetworkSettingsLike(getNetworkSettings());
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> editOrNewNetworkSettings(){
            return withNewNetworkSettingsLike(getNetworkSettings() != null ? getNetworkSettings(): new NetworkSettingsBuilder().build());
    }

    public ContainerInspectFluent.NetworkSettingsNested<A> editOrNewNetworkSettingsLike(NetworkSettings item){
            return withNewNetworkSettingsLike(getNetworkSettings() != null ? getNetworkSettings(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerInspectFluentImpl that = (ContainerInspectFluentImpl) o;
            if (Config != null ? !Config.equals(that.Config) :that.Config != null) return false;
            if (Mounts != null ? !Mounts.equals(that.Mounts) :that.Mounts != null) return false;
            if (NetworkSettings != null ? !NetworkSettings.equals(that.NetworkSettings) :that.NetworkSettings != null) return false;
            return true;
    }


    public class ConfigNestedImpl<N> extends ConfigFluentImpl<ContainerInspectFluent.ConfigNested<N>> implements ContainerInspectFluent.ConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ConfigBuilder builder;
    
            ConfigNestedImpl(Config item){
                    this.builder = new ConfigBuilder(this, item);
            }
            ConfigNestedImpl(){
                    this.builder = new ConfigBuilder(this);
            }
    
    public N and(){
            return (N) ContainerInspectFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig(){
            return and();
    }

}
    public class MountsNestedImpl<N> extends MountPointFluentImpl<ContainerInspectFluent.MountsNested<N>> implements ContainerInspectFluent.MountsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final MountPointBuilder builder;
        private final int index;
    
            MountsNestedImpl(int index,MountPoint item){
                    this.index = index;
                    this.builder = new MountPointBuilder(this, item);
            }
            MountsNestedImpl(){
                    this.index = -1;
                    this.builder = new MountPointBuilder(this);
            }
    
    public N and(){
            return (N) ContainerInspectFluentImpl.this.setToMounts(index, builder.build());
    }
    public N endMount(){
            return and();
    }

}
    public class NetworkSettingsNestedImpl<N> extends NetworkSettingsFluentImpl<ContainerInspectFluent.NetworkSettingsNested<N>> implements ContainerInspectFluent.NetworkSettingsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkSettingsBuilder builder;
    
            NetworkSettingsNestedImpl(NetworkSettings item){
                    this.builder = new NetworkSettingsBuilder(this, item);
            }
            NetworkSettingsNestedImpl(){
                    this.builder = new NetworkSettingsBuilder(this);
            }
    
    public N and(){
            return (N) ContainerInspectFluentImpl.this.withNetworkSettings(builder.build());
    }
    public N endNetworkSettings(){
            return and();
    }

}


}
