package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerPathStatBuilder extends ContainerPathStatFluentImpl<ContainerPathStatBuilder> implements VisitableBuilder<ContainerPathStat,ContainerPathStatBuilder>{

    ContainerPathStatFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerPathStatBuilder(){
            this(true);
    }
    public ContainerPathStatBuilder(Boolean validationEnabled){
            this(new ContainerPathStat(), validationEnabled);
    }
    public ContainerPathStatBuilder(ContainerPathStatFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerPathStatBuilder(ContainerPathStatFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerPathStat(), validationEnabled);
    }
    public ContainerPathStatBuilder(ContainerPathStatFluent<?> fluent,ContainerPathStat instance){
            this(fluent, instance, true);
    }
    public ContainerPathStatBuilder(ContainerPathStatFluent<?> fluent,ContainerPathStat instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLinkTarget(instance.getLinkTarget()); 
            fluent.withMode(instance.getMode()); 
            fluent.withMtime(instance.getMtime()); 
            fluent.withName(instance.getName()); 
            fluent.withSize(instance.getSize()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerPathStatBuilder(ContainerPathStat instance){
            this(instance,true);
    }
    public ContainerPathStatBuilder(ContainerPathStat instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLinkTarget(instance.getLinkTarget()); 
            this.withMode(instance.getMode()); 
            this.withMtime(instance.getMtime()); 
            this.withName(instance.getName()); 
            this.withSize(instance.getSize()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableContainerPathStat build(){
            EditableContainerPathStat buildable = new EditableContainerPathStat(fluent.getLinkTarget(),fluent.getMode(),fluent.getMtime(),fluent.getName(),fluent.getSize());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerPathStatBuilder that = (ContainerPathStatBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
