package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CopyConfigBuilder extends CopyConfigFluentImpl<CopyConfigBuilder> implements VisitableBuilder<CopyConfig,CopyConfigBuilder>{

    CopyConfigFluent<?> fluent;
    Boolean validationEnabled;

    public CopyConfigBuilder(){
            this(true);
    }
    public CopyConfigBuilder(Boolean validationEnabled){
            this(new CopyConfig(), validationEnabled);
    }
    public CopyConfigBuilder(CopyConfigFluent<?> fluent){
            this(fluent, true);
    }
    public CopyConfigBuilder(CopyConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CopyConfig(), validationEnabled);
    }
    public CopyConfigBuilder(CopyConfigFluent<?> fluent,CopyConfig instance){
            this(fluent, instance, true);
    }
    public CopyConfigBuilder(CopyConfigFluent<?> fluent,CopyConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }
    public CopyConfigBuilder(CopyConfig instance){
            this(instance,true);
    }
    public CopyConfigBuilder(CopyConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withResource(instance.getResource()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableCopyConfig build(){
            EditableCopyConfig buildable = new EditableCopyConfig(fluent.getResource());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CopyConfigBuilder that = (CopyConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
