package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DeviceMappingBuilder extends DeviceMappingFluentImpl<DeviceMappingBuilder> implements VisitableBuilder<DeviceMapping,DeviceMappingBuilder>{

    DeviceMappingFluent<?> fluent;
    Boolean validationEnabled;

    public DeviceMappingBuilder(){
            this(true);
    }
    public DeviceMappingBuilder(Boolean validationEnabled){
            this(new DeviceMapping(), validationEnabled);
    }
    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent){
            this(fluent, true);
    }
    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DeviceMapping(), validationEnabled);
    }
    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent,DeviceMapping instance){
            this(fluent, instance, true);
    }
    public DeviceMappingBuilder(DeviceMappingFluent<?> fluent,DeviceMapping instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCgroupPermissions(instance.getCgroupPermissions()); 
            fluent.withPathInContainer(instance.getPathInContainer()); 
            fluent.withPathOnHost(instance.getPathOnHost()); 
            this.validationEnabled = validationEnabled; 
    }
    public DeviceMappingBuilder(DeviceMapping instance){
            this(instance,true);
    }
    public DeviceMappingBuilder(DeviceMapping instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCgroupPermissions(instance.getCgroupPermissions()); 
            this.withPathInContainer(instance.getPathInContainer()); 
            this.withPathOnHost(instance.getPathOnHost()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableDeviceMapping build(){
            EditableDeviceMapping buildable = new EditableDeviceMapping(fluent.getCgroupPermissions(),fluent.getPathInContainer(),fluent.getPathOnHost());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeviceMappingBuilder that = (DeviceMappingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
