package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.docker.api.builder.Predicate;
import java.util.List;
import java.lang.Long;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Boolean;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Collection;
import io.fabric8.docker.api.builder.Nested;

public class DockerSchemaFluentImpl<A extends DockerSchemaFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements DockerSchemaFluent<A>{

    private AddressBuilder Address;
    private AuthConfigBuilder AuthConfig;
    private AuthResponseBuilder AuthResponse;
    private ContainerChangeBuilder ContainerChange;
    private ContainerCommitResponseBuilder ContainerCommitResponse;
    private ContainerCreateResponseBuilder ContainerCreateResponse;
    private ContainerExecCreateResponseBuilder ContainerExecCreateResponse;
    private ContainerJSONBaseBuilder ContainerJSONBase;
    private ContainerPathStatBuilder ContainerPathStat;
    private ContainerProcessListBuilder ContainerProcessList;
    private ContainerStateBuilder ContainerState;
    private ContainerWaitResponseBuilder ContainerWaitResponse;
    private CopyConfigBuilder CopyConfig;
    private DefaultNetworkSettingsBuilder DefaultNetworkSettings;
    private EndpointResourceBuilder EndpointResource;
    private EndpointSettingsBuilder EndpointSettings;
    private ExecConfigBuilder ExecConfig;
    private ExecStartCheckBuilder ExecStartCheck;
    private GraphDriverDataBuilder GraphDriverData;
    private HostConfigBuilder HostConfig;
    private IPAMBuilder IPAM;
    private IPAMConfigBuilder IPAMConfig;
    private ImageBuilder Image;
    private ImageDeleteBuilder ImageDelete;
    private ImageHistoryBuilder ImageHistory;
    private ImageInspectBuilder ImageInspect;
    private IndexInfoBuilder IndexInfo;
    private InfoBuilder Info;
    private KeyValuePairBuilder KeyValuePair;
    private LogConfigBuilder LogConfig;
    private MountPointBuilder MountPoint;
    private NetworkConnectBuilder NetworkConnect;
    private NetworkCreateBuilder NetworkCreate;
    private NetworkCreateResponseBuilder NetworkCreateResponse;
    private NetworkDisconnectBuilder NetworkDisconnect;
    private NetworkResourceBuilder NetworkResource;
    private NetworkSettingsBuilder NetworkSettings;
    private NetworkSettingsBaseBuilder NetworkSettingsBase;
    private PortBuilder Port;
    private PortBindingBuilder PortBinding;
    private SearchResultBuilder SearchResult;
    private SearchResultsBuilder SearchResults;
    private ServiceConfigBuilder ServiceConfig;
    private StatsBuilder Stats;
    private List<String> StrSlice = new ArrayList<String>();
    private VersionBuilder Version;
    private VolumeBuilder Volume;
    private VolumeCreateRequestBuilder VolumeCreateRequest;
    private VolumesListResponseBuilder VolumesListResponse;

    public DockerSchemaFluentImpl(){
    }
    public DockerSchemaFluentImpl(DockerSchema instance){
            this.withAddress(instance.getAddress()); 
            this.withAuthConfig(instance.getAuthConfig()); 
            this.withAuthResponse(instance.getAuthResponse()); 
            this.withContainerChange(instance.getContainerChange()); 
            this.withContainerCommitResponse(instance.getContainerCommitResponse()); 
            this.withContainerCreateResponse(instance.getContainerCreateResponse()); 
            this.withContainerExecCreateResponse(instance.getContainerExecCreateResponse()); 
            this.withContainerJSONBase(instance.getContainerJSONBase()); 
            this.withContainerPathStat(instance.getContainerPathStat()); 
            this.withContainerProcessList(instance.getContainerProcessList()); 
            this.withContainerState(instance.getContainerState()); 
            this.withContainerWaitResponse(instance.getContainerWaitResponse()); 
            this.withCopyConfig(instance.getCopyConfig()); 
            this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); 
            this.withEndpointResource(instance.getEndpointResource()); 
            this.withEndpointSettings(instance.getEndpointSettings()); 
            this.withExecConfig(instance.getExecConfig()); 
            this.withExecStartCheck(instance.getExecStartCheck()); 
            this.withGraphDriverData(instance.getGraphDriverData()); 
            this.withHostConfig(instance.getHostConfig()); 
            this.withIPAM(instance.getIPAM()); 
            this.withIPAMConfig(instance.getIPAMConfig()); 
            this.withImage(instance.getImage()); 
            this.withImageDelete(instance.getImageDelete()); 
            this.withImageHistory(instance.getImageHistory()); 
            this.withImageInspect(instance.getImageInspect()); 
            this.withIndexInfo(instance.getIndexInfo()); 
            this.withInfo(instance.getInfo()); 
            this.withKeyValuePair(instance.getKeyValuePair()); 
            this.withLogConfig(instance.getLogConfig()); 
            this.withMountPoint(instance.getMountPoint()); 
            this.withNetworkConnect(instance.getNetworkConnect()); 
            this.withNetworkCreate(instance.getNetworkCreate()); 
            this.withNetworkCreateResponse(instance.getNetworkCreateResponse()); 
            this.withNetworkDisconnect(instance.getNetworkDisconnect()); 
            this.withNetworkResource(instance.getNetworkResource()); 
            this.withNetworkSettings(instance.getNetworkSettings()); 
            this.withNetworkSettingsBase(instance.getNetworkSettingsBase()); 
            this.withPort(instance.getPort()); 
            this.withPortBinding(instance.getPortBinding()); 
            this.withSearchResult(instance.getSearchResult()); 
            this.withSearchResults(instance.getSearchResults()); 
            this.withServiceConfig(instance.getServiceConfig()); 
            this.withStats(instance.getStats()); 
            this.withStrSlice(instance.getStrSlice()); 
            this.withVersion(instance.getVersion()); 
            this.withVolume(instance.getVolume()); 
            this.withVolumeCreateRequest(instance.getVolumeCreateRequest()); 
            this.withVolumesListResponse(instance.getVolumesListResponse()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 */
@Deprecated public Address getAddress(){
            return this.Address!=null?this.Address.build():null;
    }

    public Address buildAddress(){
            return this.Address!=null?this.Address.build():null;
    }

    public A withAddress(Address Address){
            _visitables.remove(this.Address);
            if (Address!=null){ this.Address= new AddressBuilder(Address); _visitables.add(this.Address);} return (A) this;
    }

    public Boolean hasAddress(){
            return this.Address!=null;
    }

    public DockerSchemaFluent.AddressNested<A> withNewAddress(){
            return new AddressNestedImpl();
    }

    public DockerSchemaFluent.AddressNested<A> withNewAddressLike(Address item){
            return new AddressNestedImpl(item);
    }

    public DockerSchemaFluent.AddressNested<A> editAddress(){
            return withNewAddressLike(getAddress());
    }

    public DockerSchemaFluent.AddressNested<A> editOrNewAddress(){
            return withNewAddressLike(getAddress() != null ? getAddress(): new AddressBuilder().build());
    }

    public DockerSchemaFluent.AddressNested<A> editOrNewAddressLike(Address item){
            return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A withNewAddress(String Addr,Integer PrefixLen){
            return (A)withAddress(new Address(Addr, PrefixLen));
    }

    
/**
 * This method has been deprecated, please use method buildAuthConfig instead.
 */
@Deprecated public AuthConfig getAuthConfig(){
            return this.AuthConfig!=null?this.AuthConfig.build():null;
    }

    public AuthConfig buildAuthConfig(){
            return this.AuthConfig!=null?this.AuthConfig.build():null;
    }

    public A withAuthConfig(AuthConfig AuthConfig){
            _visitables.remove(this.AuthConfig);
            if (AuthConfig!=null){ this.AuthConfig= new AuthConfigBuilder(AuthConfig); _visitables.add(this.AuthConfig);} return (A) this;
    }

    public Boolean hasAuthConfig(){
            return this.AuthConfig!=null;
    }

    public DockerSchemaFluent.AuthConfigNested<A> withNewAuthConfig(){
            return new AuthConfigNestedImpl();
    }

    public DockerSchemaFluent.AuthConfigNested<A> withNewAuthConfigLike(AuthConfig item){
            return new AuthConfigNestedImpl(item);
    }

    public DockerSchemaFluent.AuthConfigNested<A> editAuthConfig(){
            return withNewAuthConfigLike(getAuthConfig());
    }

    public DockerSchemaFluent.AuthConfigNested<A> editOrNewAuthConfig(){
            return withNewAuthConfigLike(getAuthConfig() != null ? getAuthConfig(): new AuthConfigBuilder().build());
    }

    public DockerSchemaFluent.AuthConfigNested<A> editOrNewAuthConfigLike(AuthConfig item){
            return withNewAuthConfigLike(getAuthConfig() != null ? getAuthConfig(): item);
    }

    public A withNewAuthConfig(String auth,String email,String password,String serveraddress,String username){
            return (A)withAuthConfig(new AuthConfig(auth, email, password, serveraddress, username));
    }

    
/**
 * This method has been deprecated, please use method buildAuthResponse instead.
 */
@Deprecated public AuthResponse getAuthResponse(){
            return this.AuthResponse!=null?this.AuthResponse.build():null;
    }

    public AuthResponse buildAuthResponse(){
            return this.AuthResponse!=null?this.AuthResponse.build():null;
    }

    public A withAuthResponse(AuthResponse AuthResponse){
            _visitables.remove(this.AuthResponse);
            if (AuthResponse!=null){ this.AuthResponse= new AuthResponseBuilder(AuthResponse); _visitables.add(this.AuthResponse);} return (A) this;
    }

    public Boolean hasAuthResponse(){
            return this.AuthResponse!=null;
    }

    public DockerSchemaFluent.AuthResponseNested<A> withNewAuthResponse(){
            return new AuthResponseNestedImpl();
    }

    public DockerSchemaFluent.AuthResponseNested<A> withNewAuthResponseLike(AuthResponse item){
            return new AuthResponseNestedImpl(item);
    }

    public DockerSchemaFluent.AuthResponseNested<A> editAuthResponse(){
            return withNewAuthResponseLike(getAuthResponse());
    }

    public DockerSchemaFluent.AuthResponseNested<A> editOrNewAuthResponse(){
            return withNewAuthResponseLike(getAuthResponse() != null ? getAuthResponse(): new AuthResponseBuilder().build());
    }

    public DockerSchemaFluent.AuthResponseNested<A> editOrNewAuthResponseLike(AuthResponse item){
            return withNewAuthResponseLike(getAuthResponse() != null ? getAuthResponse(): item);
    }

    public A withNewAuthResponse(String Status){
            return (A)withAuthResponse(new AuthResponse(Status));
    }

    
/**
 * This method has been deprecated, please use method buildContainerChange instead.
 */
@Deprecated public ContainerChange getContainerChange(){
            return this.ContainerChange!=null?this.ContainerChange.build():null;
    }

    public ContainerChange buildContainerChange(){
            return this.ContainerChange!=null?this.ContainerChange.build():null;
    }

    public A withContainerChange(ContainerChange ContainerChange){
            _visitables.remove(this.ContainerChange);
            if (ContainerChange!=null){ this.ContainerChange= new ContainerChangeBuilder(ContainerChange); _visitables.add(this.ContainerChange);} return (A) this;
    }

    public Boolean hasContainerChange(){
            return this.ContainerChange!=null;
    }

    public DockerSchemaFluent.ContainerChangeNested<A> withNewContainerChange(){
            return new ContainerChangeNestedImpl();
    }

    public DockerSchemaFluent.ContainerChangeNested<A> withNewContainerChangeLike(ContainerChange item){
            return new ContainerChangeNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerChangeNested<A> editContainerChange(){
            return withNewContainerChangeLike(getContainerChange());
    }

    public DockerSchemaFluent.ContainerChangeNested<A> editOrNewContainerChange(){
            return withNewContainerChangeLike(getContainerChange() != null ? getContainerChange(): new ContainerChangeBuilder().build());
    }

    public DockerSchemaFluent.ContainerChangeNested<A> editOrNewContainerChangeLike(ContainerChange item){
            return withNewContainerChangeLike(getContainerChange() != null ? getContainerChange(): item);
    }

    public A withNewContainerChange(Integer Kind,String Path){
            return (A)withContainerChange(new ContainerChange(Kind, Path));
    }

    
/**
 * This method has been deprecated, please use method buildContainerCommitResponse instead.
 */
@Deprecated public ContainerCommitResponse getContainerCommitResponse(){
            return this.ContainerCommitResponse!=null?this.ContainerCommitResponse.build():null;
    }

    public ContainerCommitResponse buildContainerCommitResponse(){
            return this.ContainerCommitResponse!=null?this.ContainerCommitResponse.build():null;
    }

    public A withContainerCommitResponse(ContainerCommitResponse ContainerCommitResponse){
            _visitables.remove(this.ContainerCommitResponse);
            if (ContainerCommitResponse!=null){ this.ContainerCommitResponse= new ContainerCommitResponseBuilder(ContainerCommitResponse); _visitables.add(this.ContainerCommitResponse);} return (A) this;
    }

    public Boolean hasContainerCommitResponse(){
            return this.ContainerCommitResponse!=null;
    }

    public DockerSchemaFluent.ContainerCommitResponseNested<A> withNewContainerCommitResponse(){
            return new ContainerCommitResponseNestedImpl();
    }

    public DockerSchemaFluent.ContainerCommitResponseNested<A> withNewContainerCommitResponseLike(ContainerCommitResponse item){
            return new ContainerCommitResponseNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerCommitResponseNested<A> editContainerCommitResponse(){
            return withNewContainerCommitResponseLike(getContainerCommitResponse());
    }

    public DockerSchemaFluent.ContainerCommitResponseNested<A> editOrNewContainerCommitResponse(){
            return withNewContainerCommitResponseLike(getContainerCommitResponse() != null ? getContainerCommitResponse(): new ContainerCommitResponseBuilder().build());
    }

    public DockerSchemaFluent.ContainerCommitResponseNested<A> editOrNewContainerCommitResponseLike(ContainerCommitResponse item){
            return withNewContainerCommitResponseLike(getContainerCommitResponse() != null ? getContainerCommitResponse(): item);
    }

    public A withNewContainerCommitResponse(String Id){
            return (A)withContainerCommitResponse(new ContainerCommitResponse(Id));
    }

    
/**
 * This method has been deprecated, please use method buildContainerCreateResponse instead.
 */
@Deprecated public ContainerCreateResponse getContainerCreateResponse(){
            return this.ContainerCreateResponse!=null?this.ContainerCreateResponse.build():null;
    }

    public ContainerCreateResponse buildContainerCreateResponse(){
            return this.ContainerCreateResponse!=null?this.ContainerCreateResponse.build():null;
    }

    public A withContainerCreateResponse(ContainerCreateResponse ContainerCreateResponse){
            _visitables.remove(this.ContainerCreateResponse);
            if (ContainerCreateResponse!=null){ this.ContainerCreateResponse= new ContainerCreateResponseBuilder(ContainerCreateResponse); _visitables.add(this.ContainerCreateResponse);} return (A) this;
    }

    public Boolean hasContainerCreateResponse(){
            return this.ContainerCreateResponse!=null;
    }

    public DockerSchemaFluent.ContainerCreateResponseNested<A> withNewContainerCreateResponse(){
            return new ContainerCreateResponseNestedImpl();
    }

    public DockerSchemaFluent.ContainerCreateResponseNested<A> withNewContainerCreateResponseLike(ContainerCreateResponse item){
            return new ContainerCreateResponseNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerCreateResponseNested<A> editContainerCreateResponse(){
            return withNewContainerCreateResponseLike(getContainerCreateResponse());
    }

    public DockerSchemaFluent.ContainerCreateResponseNested<A> editOrNewContainerCreateResponse(){
            return withNewContainerCreateResponseLike(getContainerCreateResponse() != null ? getContainerCreateResponse(): new ContainerCreateResponseBuilder().build());
    }

    public DockerSchemaFluent.ContainerCreateResponseNested<A> editOrNewContainerCreateResponseLike(ContainerCreateResponse item){
            return withNewContainerCreateResponseLike(getContainerCreateResponse() != null ? getContainerCreateResponse(): item);
    }

    
/**
 * This method has been deprecated, please use method buildContainerExecCreateResponse instead.
 */
@Deprecated public ContainerExecCreateResponse getContainerExecCreateResponse(){
            return this.ContainerExecCreateResponse!=null?this.ContainerExecCreateResponse.build():null;
    }

    public ContainerExecCreateResponse buildContainerExecCreateResponse(){
            return this.ContainerExecCreateResponse!=null?this.ContainerExecCreateResponse.build():null;
    }

    public A withContainerExecCreateResponse(ContainerExecCreateResponse ContainerExecCreateResponse){
            _visitables.remove(this.ContainerExecCreateResponse);
            if (ContainerExecCreateResponse!=null){ this.ContainerExecCreateResponse= new ContainerExecCreateResponseBuilder(ContainerExecCreateResponse); _visitables.add(this.ContainerExecCreateResponse);} return (A) this;
    }

    public Boolean hasContainerExecCreateResponse(){
            return this.ContainerExecCreateResponse!=null;
    }

    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> withNewContainerExecCreateResponse(){
            return new ContainerExecCreateResponseNestedImpl();
    }

    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> withNewContainerExecCreateResponseLike(ContainerExecCreateResponse item){
            return new ContainerExecCreateResponseNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> editContainerExecCreateResponse(){
            return withNewContainerExecCreateResponseLike(getContainerExecCreateResponse());
    }

    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> editOrNewContainerExecCreateResponse(){
            return withNewContainerExecCreateResponseLike(getContainerExecCreateResponse() != null ? getContainerExecCreateResponse(): new ContainerExecCreateResponseBuilder().build());
    }

    public DockerSchemaFluent.ContainerExecCreateResponseNested<A> editOrNewContainerExecCreateResponseLike(ContainerExecCreateResponse item){
            return withNewContainerExecCreateResponseLike(getContainerExecCreateResponse() != null ? getContainerExecCreateResponse(): item);
    }

    public A withNewContainerExecCreateResponse(String Id){
            return (A)withContainerExecCreateResponse(new ContainerExecCreateResponse(Id));
    }

    
/**
 * This method has been deprecated, please use method buildContainerJSONBase instead.
 */
@Deprecated public ContainerJSONBase getContainerJSONBase(){
            return this.ContainerJSONBase!=null?this.ContainerJSONBase.build():null;
    }

    public ContainerJSONBase buildContainerJSONBase(){
            return this.ContainerJSONBase!=null?this.ContainerJSONBase.build():null;
    }

    public A withContainerJSONBase(ContainerJSONBase ContainerJSONBase){
            _visitables.remove(this.ContainerJSONBase);
            if (ContainerJSONBase!=null){ this.ContainerJSONBase= new ContainerJSONBaseBuilder(ContainerJSONBase); _visitables.add(this.ContainerJSONBase);} return (A) this;
    }

    public Boolean hasContainerJSONBase(){
            return this.ContainerJSONBase!=null;
    }

    public DockerSchemaFluent.ContainerJSONBaseNested<A> withNewContainerJSONBase(){
            return new ContainerJSONBaseNestedImpl();
    }

    public DockerSchemaFluent.ContainerJSONBaseNested<A> withNewContainerJSONBaseLike(ContainerJSONBase item){
            return new ContainerJSONBaseNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerJSONBaseNested<A> editContainerJSONBase(){
            return withNewContainerJSONBaseLike(getContainerJSONBase());
    }

    public DockerSchemaFluent.ContainerJSONBaseNested<A> editOrNewContainerJSONBase(){
            return withNewContainerJSONBaseLike(getContainerJSONBase() != null ? getContainerJSONBase(): new ContainerJSONBaseBuilder().build());
    }

    public DockerSchemaFluent.ContainerJSONBaseNested<A> editOrNewContainerJSONBaseLike(ContainerJSONBase item){
            return withNewContainerJSONBaseLike(getContainerJSONBase() != null ? getContainerJSONBase(): item);
    }

    
/**
 * This method has been deprecated, please use method buildContainerPathStat instead.
 */
@Deprecated public ContainerPathStat getContainerPathStat(){
            return this.ContainerPathStat!=null?this.ContainerPathStat.build():null;
    }

    public ContainerPathStat buildContainerPathStat(){
            return this.ContainerPathStat!=null?this.ContainerPathStat.build():null;
    }

    public A withContainerPathStat(ContainerPathStat ContainerPathStat){
            _visitables.remove(this.ContainerPathStat);
            if (ContainerPathStat!=null){ this.ContainerPathStat= new ContainerPathStatBuilder(ContainerPathStat); _visitables.add(this.ContainerPathStat);} return (A) this;
    }

    public Boolean hasContainerPathStat(){
            return this.ContainerPathStat!=null;
    }

    public DockerSchemaFluent.ContainerPathStatNested<A> withNewContainerPathStat(){
            return new ContainerPathStatNestedImpl();
    }

    public DockerSchemaFluent.ContainerPathStatNested<A> withNewContainerPathStatLike(ContainerPathStat item){
            return new ContainerPathStatNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerPathStatNested<A> editContainerPathStat(){
            return withNewContainerPathStatLike(getContainerPathStat());
    }

    public DockerSchemaFluent.ContainerPathStatNested<A> editOrNewContainerPathStat(){
            return withNewContainerPathStatLike(getContainerPathStat() != null ? getContainerPathStat(): new ContainerPathStatBuilder().build());
    }

    public DockerSchemaFluent.ContainerPathStatNested<A> editOrNewContainerPathStatLike(ContainerPathStat item){
            return withNewContainerPathStatLike(getContainerPathStat() != null ? getContainerPathStat(): item);
    }

    public A withNewContainerPathStat(String linkTarget,Integer mode,String mtime,String name,Long size){
            return (A)withContainerPathStat(new ContainerPathStat(linkTarget, mode, mtime, name, size));
    }

    
/**
 * This method has been deprecated, please use method buildContainerProcessList instead.
 */
@Deprecated public ContainerProcessList getContainerProcessList(){
            return this.ContainerProcessList!=null?this.ContainerProcessList.build():null;
    }

    public ContainerProcessList buildContainerProcessList(){
            return this.ContainerProcessList!=null?this.ContainerProcessList.build():null;
    }

    public A withContainerProcessList(ContainerProcessList ContainerProcessList){
            _visitables.remove(this.ContainerProcessList);
            if (ContainerProcessList!=null){ this.ContainerProcessList= new ContainerProcessListBuilder(ContainerProcessList); _visitables.add(this.ContainerProcessList);} return (A) this;
    }

    public Boolean hasContainerProcessList(){
            return this.ContainerProcessList!=null;
    }

    public DockerSchemaFluent.ContainerProcessListNested<A> withNewContainerProcessList(){
            return new ContainerProcessListNestedImpl();
    }

    public DockerSchemaFluent.ContainerProcessListNested<A> withNewContainerProcessListLike(ContainerProcessList item){
            return new ContainerProcessListNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerProcessListNested<A> editContainerProcessList(){
            return withNewContainerProcessListLike(getContainerProcessList());
    }

    public DockerSchemaFluent.ContainerProcessListNested<A> editOrNewContainerProcessList(){
            return withNewContainerProcessListLike(getContainerProcessList() != null ? getContainerProcessList(): new ContainerProcessListBuilder().build());
    }

    public DockerSchemaFluent.ContainerProcessListNested<A> editOrNewContainerProcessListLike(ContainerProcessList item){
            return withNewContainerProcessListLike(getContainerProcessList() != null ? getContainerProcessList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildContainerState instead.
 */
@Deprecated public ContainerState getContainerState(){
            return this.ContainerState!=null?this.ContainerState.build():null;
    }

    public ContainerState buildContainerState(){
            return this.ContainerState!=null?this.ContainerState.build():null;
    }

    public A withContainerState(ContainerState ContainerState){
            _visitables.remove(this.ContainerState);
            if (ContainerState!=null){ this.ContainerState= new ContainerStateBuilder(ContainerState); _visitables.add(this.ContainerState);} return (A) this;
    }

    public Boolean hasContainerState(){
            return this.ContainerState!=null;
    }

    public DockerSchemaFluent.ContainerStateNested<A> withNewContainerState(){
            return new ContainerStateNestedImpl();
    }

    public DockerSchemaFluent.ContainerStateNested<A> withNewContainerStateLike(ContainerState item){
            return new ContainerStateNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerStateNested<A> editContainerState(){
            return withNewContainerStateLike(getContainerState());
    }

    public DockerSchemaFluent.ContainerStateNested<A> editOrNewContainerState(){
            return withNewContainerStateLike(getContainerState() != null ? getContainerState(): new ContainerStateBuilder().build());
    }

    public DockerSchemaFluent.ContainerStateNested<A> editOrNewContainerStateLike(ContainerState item){
            return withNewContainerStateLike(getContainerState() != null ? getContainerState(): item);
    }

    
/**
 * This method has been deprecated, please use method buildContainerWaitResponse instead.
 */
@Deprecated public ContainerWaitResponse getContainerWaitResponse(){
            return this.ContainerWaitResponse!=null?this.ContainerWaitResponse.build():null;
    }

    public ContainerWaitResponse buildContainerWaitResponse(){
            return this.ContainerWaitResponse!=null?this.ContainerWaitResponse.build():null;
    }

    public A withContainerWaitResponse(ContainerWaitResponse ContainerWaitResponse){
            _visitables.remove(this.ContainerWaitResponse);
            if (ContainerWaitResponse!=null){ this.ContainerWaitResponse= new ContainerWaitResponseBuilder(ContainerWaitResponse); _visitables.add(this.ContainerWaitResponse);} return (A) this;
    }

    public Boolean hasContainerWaitResponse(){
            return this.ContainerWaitResponse!=null;
    }

    public DockerSchemaFluent.ContainerWaitResponseNested<A> withNewContainerWaitResponse(){
            return new ContainerWaitResponseNestedImpl();
    }

    public DockerSchemaFluent.ContainerWaitResponseNested<A> withNewContainerWaitResponseLike(ContainerWaitResponse item){
            return new ContainerWaitResponseNestedImpl(item);
    }

    public DockerSchemaFluent.ContainerWaitResponseNested<A> editContainerWaitResponse(){
            return withNewContainerWaitResponseLike(getContainerWaitResponse());
    }

    public DockerSchemaFluent.ContainerWaitResponseNested<A> editOrNewContainerWaitResponse(){
            return withNewContainerWaitResponseLike(getContainerWaitResponse() != null ? getContainerWaitResponse(): new ContainerWaitResponseBuilder().build());
    }

    public DockerSchemaFluent.ContainerWaitResponseNested<A> editOrNewContainerWaitResponseLike(ContainerWaitResponse item){
            return withNewContainerWaitResponseLike(getContainerWaitResponse() != null ? getContainerWaitResponse(): item);
    }

    public A withNewContainerWaitResponse(Integer StatusCode){
            return (A)withContainerWaitResponse(new ContainerWaitResponse(StatusCode));
    }

    
/**
 * This method has been deprecated, please use method buildCopyConfig instead.
 */
@Deprecated public CopyConfig getCopyConfig(){
            return this.CopyConfig!=null?this.CopyConfig.build():null;
    }

    public CopyConfig buildCopyConfig(){
            return this.CopyConfig!=null?this.CopyConfig.build():null;
    }

    public A withCopyConfig(CopyConfig CopyConfig){
            _visitables.remove(this.CopyConfig);
            if (CopyConfig!=null){ this.CopyConfig= new CopyConfigBuilder(CopyConfig); _visitables.add(this.CopyConfig);} return (A) this;
    }

    public Boolean hasCopyConfig(){
            return this.CopyConfig!=null;
    }

    public DockerSchemaFluent.CopyConfigNested<A> withNewCopyConfig(){
            return new CopyConfigNestedImpl();
    }

    public DockerSchemaFluent.CopyConfigNested<A> withNewCopyConfigLike(CopyConfig item){
            return new CopyConfigNestedImpl(item);
    }

    public DockerSchemaFluent.CopyConfigNested<A> editCopyConfig(){
            return withNewCopyConfigLike(getCopyConfig());
    }

    public DockerSchemaFluent.CopyConfigNested<A> editOrNewCopyConfig(){
            return withNewCopyConfigLike(getCopyConfig() != null ? getCopyConfig(): new CopyConfigBuilder().build());
    }

    public DockerSchemaFluent.CopyConfigNested<A> editOrNewCopyConfigLike(CopyConfig item){
            return withNewCopyConfigLike(getCopyConfig() != null ? getCopyConfig(): item);
    }

    public A withNewCopyConfig(String Resource){
            return (A)withCopyConfig(new CopyConfig(Resource));
    }

    
/**
 * This method has been deprecated, please use method buildDefaultNetworkSettings instead.
 */
@Deprecated public DefaultNetworkSettings getDefaultNetworkSettings(){
            return this.DefaultNetworkSettings!=null?this.DefaultNetworkSettings.build():null;
    }

    public DefaultNetworkSettings buildDefaultNetworkSettings(){
            return this.DefaultNetworkSettings!=null?this.DefaultNetworkSettings.build():null;
    }

    public A withDefaultNetworkSettings(DefaultNetworkSettings DefaultNetworkSettings){
            _visitables.remove(this.DefaultNetworkSettings);
            if (DefaultNetworkSettings!=null){ this.DefaultNetworkSettings= new DefaultNetworkSettingsBuilder(DefaultNetworkSettings); _visitables.add(this.DefaultNetworkSettings);} return (A) this;
    }

    public Boolean hasDefaultNetworkSettings(){
            return this.DefaultNetworkSettings!=null;
    }

    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> withNewDefaultNetworkSettings(){
            return new DefaultNetworkSettingsNestedImpl();
    }

    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> withNewDefaultNetworkSettingsLike(DefaultNetworkSettings item){
            return new DefaultNetworkSettingsNestedImpl(item);
    }

    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> editDefaultNetworkSettings(){
            return withNewDefaultNetworkSettingsLike(getDefaultNetworkSettings());
    }

    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> editOrNewDefaultNetworkSettings(){
            return withNewDefaultNetworkSettingsLike(getDefaultNetworkSettings() != null ? getDefaultNetworkSettings(): new DefaultNetworkSettingsBuilder().build());
    }

    public DockerSchemaFluent.DefaultNetworkSettingsNested<A> editOrNewDefaultNetworkSettingsLike(DefaultNetworkSettings item){
            return withNewDefaultNetworkSettingsLike(getDefaultNetworkSettings() != null ? getDefaultNetworkSettings(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEndpointResource instead.
 */
@Deprecated public EndpointResource getEndpointResource(){
            return this.EndpointResource!=null?this.EndpointResource.build():null;
    }

    public EndpointResource buildEndpointResource(){
            return this.EndpointResource!=null?this.EndpointResource.build():null;
    }

    public A withEndpointResource(EndpointResource EndpointResource){
            _visitables.remove(this.EndpointResource);
            if (EndpointResource!=null){ this.EndpointResource= new EndpointResourceBuilder(EndpointResource); _visitables.add(this.EndpointResource);} return (A) this;
    }

    public Boolean hasEndpointResource(){
            return this.EndpointResource!=null;
    }

    public DockerSchemaFluent.EndpointResourceNested<A> withNewEndpointResource(){
            return new EndpointResourceNestedImpl();
    }

    public DockerSchemaFluent.EndpointResourceNested<A> withNewEndpointResourceLike(EndpointResource item){
            return new EndpointResourceNestedImpl(item);
    }

    public DockerSchemaFluent.EndpointResourceNested<A> editEndpointResource(){
            return withNewEndpointResourceLike(getEndpointResource());
    }

    public DockerSchemaFluent.EndpointResourceNested<A> editOrNewEndpointResource(){
            return withNewEndpointResourceLike(getEndpointResource() != null ? getEndpointResource(): new EndpointResourceBuilder().build());
    }

    public DockerSchemaFluent.EndpointResourceNested<A> editOrNewEndpointResourceLike(EndpointResource item){
            return withNewEndpointResourceLike(getEndpointResource() != null ? getEndpointResource(): item);
    }

    public A withNewEndpointResource(String EndpointID,String IPv4Address,String IPv6Address,String MacAddress){
            return (A)withEndpointResource(new EndpointResource(EndpointID, IPv4Address, IPv6Address, MacAddress));
    }

    
/**
 * This method has been deprecated, please use method buildEndpointSettings instead.
 */
@Deprecated public EndpointSettings getEndpointSettings(){
            return this.EndpointSettings!=null?this.EndpointSettings.build():null;
    }

    public EndpointSettings buildEndpointSettings(){
            return this.EndpointSettings!=null?this.EndpointSettings.build():null;
    }

    public A withEndpointSettings(EndpointSettings EndpointSettings){
            _visitables.remove(this.EndpointSettings);
            if (EndpointSettings!=null){ this.EndpointSettings= new EndpointSettingsBuilder(EndpointSettings); _visitables.add(this.EndpointSettings);} return (A) this;
    }

    public Boolean hasEndpointSettings(){
            return this.EndpointSettings!=null;
    }

    public DockerSchemaFluent.EndpointSettingsNested<A> withNewEndpointSettings(){
            return new EndpointSettingsNestedImpl();
    }

    public DockerSchemaFluent.EndpointSettingsNested<A> withNewEndpointSettingsLike(EndpointSettings item){
            return new EndpointSettingsNestedImpl(item);
    }

    public DockerSchemaFluent.EndpointSettingsNested<A> editEndpointSettings(){
            return withNewEndpointSettingsLike(getEndpointSettings());
    }

    public DockerSchemaFluent.EndpointSettingsNested<A> editOrNewEndpointSettings(){
            return withNewEndpointSettingsLike(getEndpointSettings() != null ? getEndpointSettings(): new EndpointSettingsBuilder().build());
    }

    public DockerSchemaFluent.EndpointSettingsNested<A> editOrNewEndpointSettingsLike(EndpointSettings item){
            return withNewEndpointSettingsLike(getEndpointSettings() != null ? getEndpointSettings(): item);
    }

    
/**
 * This method has been deprecated, please use method buildExecConfig instead.
 */
@Deprecated public ExecConfig getExecConfig(){
            return this.ExecConfig!=null?this.ExecConfig.build():null;
    }

    public ExecConfig buildExecConfig(){
            return this.ExecConfig!=null?this.ExecConfig.build():null;
    }

    public A withExecConfig(ExecConfig ExecConfig){
            _visitables.remove(this.ExecConfig);
            if (ExecConfig!=null){ this.ExecConfig= new ExecConfigBuilder(ExecConfig); _visitables.add(this.ExecConfig);} return (A) this;
    }

    public Boolean hasExecConfig(){
            return this.ExecConfig!=null;
    }

    public DockerSchemaFluent.ExecConfigNested<A> withNewExecConfig(){
            return new ExecConfigNestedImpl();
    }

    public DockerSchemaFluent.ExecConfigNested<A> withNewExecConfigLike(ExecConfig item){
            return new ExecConfigNestedImpl(item);
    }

    public DockerSchemaFluent.ExecConfigNested<A> editExecConfig(){
            return withNewExecConfigLike(getExecConfig());
    }

    public DockerSchemaFluent.ExecConfigNested<A> editOrNewExecConfig(){
            return withNewExecConfigLike(getExecConfig() != null ? getExecConfig(): new ExecConfigBuilder().build());
    }

    public DockerSchemaFluent.ExecConfigNested<A> editOrNewExecConfigLike(ExecConfig item){
            return withNewExecConfigLike(getExecConfig() != null ? getExecConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildExecStartCheck instead.
 */
@Deprecated public ExecStartCheck getExecStartCheck(){
            return this.ExecStartCheck!=null?this.ExecStartCheck.build():null;
    }

    public ExecStartCheck buildExecStartCheck(){
            return this.ExecStartCheck!=null?this.ExecStartCheck.build():null;
    }

    public A withExecStartCheck(ExecStartCheck ExecStartCheck){
            _visitables.remove(this.ExecStartCheck);
            if (ExecStartCheck!=null){ this.ExecStartCheck= new ExecStartCheckBuilder(ExecStartCheck); _visitables.add(this.ExecStartCheck);} return (A) this;
    }

    public Boolean hasExecStartCheck(){
            return this.ExecStartCheck!=null;
    }

    public DockerSchemaFluent.ExecStartCheckNested<A> withNewExecStartCheck(){
            return new ExecStartCheckNestedImpl();
    }

    public DockerSchemaFluent.ExecStartCheckNested<A> withNewExecStartCheckLike(ExecStartCheck item){
            return new ExecStartCheckNestedImpl(item);
    }

    public DockerSchemaFluent.ExecStartCheckNested<A> editExecStartCheck(){
            return withNewExecStartCheckLike(getExecStartCheck());
    }

    public DockerSchemaFluent.ExecStartCheckNested<A> editOrNewExecStartCheck(){
            return withNewExecStartCheckLike(getExecStartCheck() != null ? getExecStartCheck(): new ExecStartCheckBuilder().build());
    }

    public DockerSchemaFluent.ExecStartCheckNested<A> editOrNewExecStartCheckLike(ExecStartCheck item){
            return withNewExecStartCheckLike(getExecStartCheck() != null ? getExecStartCheck(): item);
    }

    public A withNewExecStartCheck(Boolean Detach,Boolean Tty){
            return (A)withExecStartCheck(new ExecStartCheck(Detach, Tty));
    }

    
/**
 * This method has been deprecated, please use method buildGraphDriverData instead.
 */
@Deprecated public GraphDriverData getGraphDriverData(){
            return this.GraphDriverData!=null?this.GraphDriverData.build():null;
    }

    public GraphDriverData buildGraphDriverData(){
            return this.GraphDriverData!=null?this.GraphDriverData.build():null;
    }

    public A withGraphDriverData(GraphDriverData GraphDriverData){
            _visitables.remove(this.GraphDriverData);
            if (GraphDriverData!=null){ this.GraphDriverData= new GraphDriverDataBuilder(GraphDriverData); _visitables.add(this.GraphDriverData);} return (A) this;
    }

    public Boolean hasGraphDriverData(){
            return this.GraphDriverData!=null;
    }

    public DockerSchemaFluent.GraphDriverDataNested<A> withNewGraphDriverData(){
            return new GraphDriverDataNestedImpl();
    }

    public DockerSchemaFluent.GraphDriverDataNested<A> withNewGraphDriverDataLike(GraphDriverData item){
            return new GraphDriverDataNestedImpl(item);
    }

    public DockerSchemaFluent.GraphDriverDataNested<A> editGraphDriverData(){
            return withNewGraphDriverDataLike(getGraphDriverData());
    }

    public DockerSchemaFluent.GraphDriverDataNested<A> editOrNewGraphDriverData(){
            return withNewGraphDriverDataLike(getGraphDriverData() != null ? getGraphDriverData(): new GraphDriverDataBuilder().build());
    }

    public DockerSchemaFluent.GraphDriverDataNested<A> editOrNewGraphDriverDataLike(GraphDriverData item){
            return withNewGraphDriverDataLike(getGraphDriverData() != null ? getGraphDriverData(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHostConfig instead.
 */
@Deprecated public HostConfig getHostConfig(){
            return this.HostConfig!=null?this.HostConfig.build():null;
    }

    public HostConfig buildHostConfig(){
            return this.HostConfig!=null?this.HostConfig.build():null;
    }

    public A withHostConfig(HostConfig HostConfig){
            _visitables.remove(this.HostConfig);
            if (HostConfig!=null){ this.HostConfig= new HostConfigBuilder(HostConfig); _visitables.add(this.HostConfig);} return (A) this;
    }

    public Boolean hasHostConfig(){
            return this.HostConfig!=null;
    }

    public DockerSchemaFluent.HostConfigNested<A> withNewHostConfig(){
            return new HostConfigNestedImpl();
    }

    public DockerSchemaFluent.HostConfigNested<A> withNewHostConfigLike(HostConfig item){
            return new HostConfigNestedImpl(item);
    }

    public DockerSchemaFluent.HostConfigNested<A> editHostConfig(){
            return withNewHostConfigLike(getHostConfig());
    }

    public DockerSchemaFluent.HostConfigNested<A> editOrNewHostConfig(){
            return withNewHostConfigLike(getHostConfig() != null ? getHostConfig(): new HostConfigBuilder().build());
    }

    public DockerSchemaFluent.HostConfigNested<A> editOrNewHostConfigLike(HostConfig item){
            return withNewHostConfigLike(getHostConfig() != null ? getHostConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildIPAM instead.
 */
@Deprecated public IPAM getIPAM(){
            return this.IPAM!=null?this.IPAM.build():null;
    }

    public IPAM buildIPAM(){
            return this.IPAM!=null?this.IPAM.build():null;
    }

    public A withIPAM(IPAM IPAM){
            _visitables.remove(this.IPAM);
            if (IPAM!=null){ this.IPAM= new IPAMBuilder(IPAM); _visitables.add(this.IPAM);} return (A) this;
    }

    public Boolean hasIPAM(){
            return this.IPAM!=null;
    }

    public DockerSchemaFluent.IPAMNested<A> withNewIPAM(){
            return new IPAMNestedImpl();
    }

    public DockerSchemaFluent.IPAMNested<A> withNewIPAMLike(IPAM item){
            return new IPAMNestedImpl(item);
    }

    public DockerSchemaFluent.IPAMNested<A> editIPAM(){
            return withNewIPAMLike(getIPAM());
    }

    public DockerSchemaFluent.IPAMNested<A> editOrNewIPAM(){
            return withNewIPAMLike(getIPAM() != null ? getIPAM(): new IPAMBuilder().build());
    }

    public DockerSchemaFluent.IPAMNested<A> editOrNewIPAMLike(IPAM item){
            return withNewIPAMLike(getIPAM() != null ? getIPAM(): item);
    }

    
/**
 * This method has been deprecated, please use method buildIPAMConfig instead.
 */
@Deprecated public IPAMConfig getIPAMConfig(){
            return this.IPAMConfig!=null?this.IPAMConfig.build():null;
    }

    public IPAMConfig buildIPAMConfig(){
            return this.IPAMConfig!=null?this.IPAMConfig.build():null;
    }

    public A withIPAMConfig(IPAMConfig IPAMConfig){
            _visitables.remove(this.IPAMConfig);
            if (IPAMConfig!=null){ this.IPAMConfig= new IPAMConfigBuilder(IPAMConfig); _visitables.add(this.IPAMConfig);} return (A) this;
    }

    public Boolean hasIPAMConfig(){
            return this.IPAMConfig!=null;
    }

    public DockerSchemaFluent.IPAMConfigNested<A> withNewIPAMConfig(){
            return new IPAMConfigNestedImpl();
    }

    public DockerSchemaFluent.IPAMConfigNested<A> withNewIPAMConfigLike(IPAMConfig item){
            return new IPAMConfigNestedImpl(item);
    }

    public DockerSchemaFluent.IPAMConfigNested<A> editIPAMConfig(){
            return withNewIPAMConfigLike(getIPAMConfig());
    }

    public DockerSchemaFluent.IPAMConfigNested<A> editOrNewIPAMConfig(){
            return withNewIPAMConfigLike(getIPAMConfig() != null ? getIPAMConfig(): new IPAMConfigBuilder().build());
    }

    public DockerSchemaFluent.IPAMConfigNested<A> editOrNewIPAMConfigLike(IPAMConfig item){
            return withNewIPAMConfigLike(getIPAMConfig() != null ? getIPAMConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildImage instead.
 */
@Deprecated public Image getImage(){
            return this.Image!=null?this.Image.build():null;
    }

    public Image buildImage(){
            return this.Image!=null?this.Image.build():null;
    }

    public A withImage(Image Image){
            _visitables.remove(this.Image);
            if (Image!=null){ this.Image= new ImageBuilder(Image); _visitables.add(this.Image);} return (A) this;
    }

    public Boolean hasImage(){
            return this.Image!=null;
    }

    public DockerSchemaFluent.ImageNested<A> withNewImage(){
            return new ImageNestedImpl();
    }

    public DockerSchemaFluent.ImageNested<A> withNewImageLike(Image item){
            return new ImageNestedImpl(item);
    }

    public DockerSchemaFluent.ImageNested<A> editImage(){
            return withNewImageLike(getImage());
    }

    public DockerSchemaFluent.ImageNested<A> editOrNewImage(){
            return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
    }

    public DockerSchemaFluent.ImageNested<A> editOrNewImageLike(Image item){
            return withNewImageLike(getImage() != null ? getImage(): item);
    }

    
/**
 * This method has been deprecated, please use method buildImageDelete instead.
 */
@Deprecated public ImageDelete getImageDelete(){
            return this.ImageDelete!=null?this.ImageDelete.build():null;
    }

    public ImageDelete buildImageDelete(){
            return this.ImageDelete!=null?this.ImageDelete.build():null;
    }

    public A withImageDelete(ImageDelete ImageDelete){
            _visitables.remove(this.ImageDelete);
            if (ImageDelete!=null){ this.ImageDelete= new ImageDeleteBuilder(ImageDelete); _visitables.add(this.ImageDelete);} return (A) this;
    }

    public Boolean hasImageDelete(){
            return this.ImageDelete!=null;
    }

    public DockerSchemaFluent.ImageDeleteNested<A> withNewImageDelete(){
            return new ImageDeleteNestedImpl();
    }

    public DockerSchemaFluent.ImageDeleteNested<A> withNewImageDeleteLike(ImageDelete item){
            return new ImageDeleteNestedImpl(item);
    }

    public DockerSchemaFluent.ImageDeleteNested<A> editImageDelete(){
            return withNewImageDeleteLike(getImageDelete());
    }

    public DockerSchemaFluent.ImageDeleteNested<A> editOrNewImageDelete(){
            return withNewImageDeleteLike(getImageDelete() != null ? getImageDelete(): new ImageDeleteBuilder().build());
    }

    public DockerSchemaFluent.ImageDeleteNested<A> editOrNewImageDeleteLike(ImageDelete item){
            return withNewImageDeleteLike(getImageDelete() != null ? getImageDelete(): item);
    }

    public A withNewImageDelete(String Deleted,String Untagged){
            return (A)withImageDelete(new ImageDelete(Deleted, Untagged));
    }

    
/**
 * This method has been deprecated, please use method buildImageHistory instead.
 */
@Deprecated public ImageHistory getImageHistory(){
            return this.ImageHistory!=null?this.ImageHistory.build():null;
    }

    public ImageHistory buildImageHistory(){
            return this.ImageHistory!=null?this.ImageHistory.build():null;
    }

    public A withImageHistory(ImageHistory ImageHistory){
            _visitables.remove(this.ImageHistory);
            if (ImageHistory!=null){ this.ImageHistory= new ImageHistoryBuilder(ImageHistory); _visitables.add(this.ImageHistory);} return (A) this;
    }

    public Boolean hasImageHistory(){
            return this.ImageHistory!=null;
    }

    public DockerSchemaFluent.ImageHistoryNested<A> withNewImageHistory(){
            return new ImageHistoryNestedImpl();
    }

    public DockerSchemaFluent.ImageHistoryNested<A> withNewImageHistoryLike(ImageHistory item){
            return new ImageHistoryNestedImpl(item);
    }

    public DockerSchemaFluent.ImageHistoryNested<A> editImageHistory(){
            return withNewImageHistoryLike(getImageHistory());
    }

    public DockerSchemaFluent.ImageHistoryNested<A> editOrNewImageHistory(){
            return withNewImageHistoryLike(getImageHistory() != null ? getImageHistory(): new ImageHistoryBuilder().build());
    }

    public DockerSchemaFluent.ImageHistoryNested<A> editOrNewImageHistoryLike(ImageHistory item){
            return withNewImageHistoryLike(getImageHistory() != null ? getImageHistory(): item);
    }

    
/**
 * This method has been deprecated, please use method buildImageInspect instead.
 */
@Deprecated public ImageInspect getImageInspect(){
            return this.ImageInspect!=null?this.ImageInspect.build():null;
    }

    public ImageInspect buildImageInspect(){
            return this.ImageInspect!=null?this.ImageInspect.build():null;
    }

    public A withImageInspect(ImageInspect ImageInspect){
            _visitables.remove(this.ImageInspect);
            if (ImageInspect!=null){ this.ImageInspect= new ImageInspectBuilder(ImageInspect); _visitables.add(this.ImageInspect);} return (A) this;
    }

    public Boolean hasImageInspect(){
            return this.ImageInspect!=null;
    }

    public DockerSchemaFluent.ImageInspectNested<A> withNewImageInspect(){
            return new ImageInspectNestedImpl();
    }

    public DockerSchemaFluent.ImageInspectNested<A> withNewImageInspectLike(ImageInspect item){
            return new ImageInspectNestedImpl(item);
    }

    public DockerSchemaFluent.ImageInspectNested<A> editImageInspect(){
            return withNewImageInspectLike(getImageInspect());
    }

    public DockerSchemaFluent.ImageInspectNested<A> editOrNewImageInspect(){
            return withNewImageInspectLike(getImageInspect() != null ? getImageInspect(): new ImageInspectBuilder().build());
    }

    public DockerSchemaFluent.ImageInspectNested<A> editOrNewImageInspectLike(ImageInspect item){
            return withNewImageInspectLike(getImageInspect() != null ? getImageInspect(): item);
    }

    
/**
 * This method has been deprecated, please use method buildIndexInfo instead.
 */
@Deprecated public IndexInfo getIndexInfo(){
            return this.IndexInfo!=null?this.IndexInfo.build():null;
    }

    public IndexInfo buildIndexInfo(){
            return this.IndexInfo!=null?this.IndexInfo.build():null;
    }

    public A withIndexInfo(IndexInfo IndexInfo){
            _visitables.remove(this.IndexInfo);
            if (IndexInfo!=null){ this.IndexInfo= new IndexInfoBuilder(IndexInfo); _visitables.add(this.IndexInfo);} return (A) this;
    }

    public Boolean hasIndexInfo(){
            return this.IndexInfo!=null;
    }

    public DockerSchemaFluent.IndexInfoNested<A> withNewIndexInfo(){
            return new IndexInfoNestedImpl();
    }

    public DockerSchemaFluent.IndexInfoNested<A> withNewIndexInfoLike(IndexInfo item){
            return new IndexInfoNestedImpl(item);
    }

    public DockerSchemaFluent.IndexInfoNested<A> editIndexInfo(){
            return withNewIndexInfoLike(getIndexInfo());
    }

    public DockerSchemaFluent.IndexInfoNested<A> editOrNewIndexInfo(){
            return withNewIndexInfoLike(getIndexInfo() != null ? getIndexInfo(): new IndexInfoBuilder().build());
    }

    public DockerSchemaFluent.IndexInfoNested<A> editOrNewIndexInfoLike(IndexInfo item){
            return withNewIndexInfoLike(getIndexInfo() != null ? getIndexInfo(): item);
    }

    
/**
 * This method has been deprecated, please use method buildInfo instead.
 */
@Deprecated public Info getInfo(){
            return this.Info!=null?this.Info.build():null;
    }

    public Info buildInfo(){
            return this.Info!=null?this.Info.build():null;
    }

    public A withInfo(Info Info){
            _visitables.remove(this.Info);
            if (Info!=null){ this.Info= new InfoBuilder(Info); _visitables.add(this.Info);} return (A) this;
    }

    public Boolean hasInfo(){
            return this.Info!=null;
    }

    public DockerSchemaFluent.InfoNested<A> withNewInfo(){
            return new InfoNestedImpl();
    }

    public DockerSchemaFluent.InfoNested<A> withNewInfoLike(Info item){
            return new InfoNestedImpl(item);
    }

    public DockerSchemaFluent.InfoNested<A> editInfo(){
            return withNewInfoLike(getInfo());
    }

    public DockerSchemaFluent.InfoNested<A> editOrNewInfo(){
            return withNewInfoLike(getInfo() != null ? getInfo(): new InfoBuilder().build());
    }

    public DockerSchemaFluent.InfoNested<A> editOrNewInfoLike(Info item){
            return withNewInfoLike(getInfo() != null ? getInfo(): item);
    }

    
/**
 * This method has been deprecated, please use method buildKeyValuePair instead.
 */
@Deprecated public KeyValuePair getKeyValuePair(){
            return this.KeyValuePair!=null?this.KeyValuePair.build():null;
    }

    public KeyValuePair buildKeyValuePair(){
            return this.KeyValuePair!=null?this.KeyValuePair.build():null;
    }

    public A withKeyValuePair(KeyValuePair KeyValuePair){
            _visitables.remove(this.KeyValuePair);
            if (KeyValuePair!=null){ this.KeyValuePair= new KeyValuePairBuilder(KeyValuePair); _visitables.add(this.KeyValuePair);} return (A) this;
    }

    public Boolean hasKeyValuePair(){
            return this.KeyValuePair!=null;
    }

    public DockerSchemaFluent.KeyValuePairNested<A> withNewKeyValuePair(){
            return new KeyValuePairNestedImpl();
    }

    public DockerSchemaFluent.KeyValuePairNested<A> withNewKeyValuePairLike(KeyValuePair item){
            return new KeyValuePairNestedImpl(item);
    }

    public DockerSchemaFluent.KeyValuePairNested<A> editKeyValuePair(){
            return withNewKeyValuePairLike(getKeyValuePair());
    }

    public DockerSchemaFluent.KeyValuePairNested<A> editOrNewKeyValuePair(){
            return withNewKeyValuePairLike(getKeyValuePair() != null ? getKeyValuePair(): new KeyValuePairBuilder().build());
    }

    public DockerSchemaFluent.KeyValuePairNested<A> editOrNewKeyValuePairLike(KeyValuePair item){
            return withNewKeyValuePairLike(getKeyValuePair() != null ? getKeyValuePair(): item);
    }

    public A withNewKeyValuePair(String Key,String Value){
            return (A)withKeyValuePair(new KeyValuePair(Key, Value));
    }

    
/**
 * This method has been deprecated, please use method buildLogConfig instead.
 */
@Deprecated public LogConfig getLogConfig(){
            return this.LogConfig!=null?this.LogConfig.build():null;
    }

    public LogConfig buildLogConfig(){
            return this.LogConfig!=null?this.LogConfig.build():null;
    }

    public A withLogConfig(LogConfig LogConfig){
            _visitables.remove(this.LogConfig);
            if (LogConfig!=null){ this.LogConfig= new LogConfigBuilder(LogConfig); _visitables.add(this.LogConfig);} return (A) this;
    }

    public Boolean hasLogConfig(){
            return this.LogConfig!=null;
    }

    public DockerSchemaFluent.LogConfigNested<A> withNewLogConfig(){
            return new LogConfigNestedImpl();
    }

    public DockerSchemaFluent.LogConfigNested<A> withNewLogConfigLike(LogConfig item){
            return new LogConfigNestedImpl(item);
    }

    public DockerSchemaFluent.LogConfigNested<A> editLogConfig(){
            return withNewLogConfigLike(getLogConfig());
    }

    public DockerSchemaFluent.LogConfigNested<A> editOrNewLogConfig(){
            return withNewLogConfigLike(getLogConfig() != null ? getLogConfig(): new LogConfigBuilder().build());
    }

    public DockerSchemaFluent.LogConfigNested<A> editOrNewLogConfigLike(LogConfig item){
            return withNewLogConfigLike(getLogConfig() != null ? getLogConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMountPoint instead.
 */
@Deprecated public MountPoint getMountPoint(){
            return this.MountPoint!=null?this.MountPoint.build():null;
    }

    public MountPoint buildMountPoint(){
            return this.MountPoint!=null?this.MountPoint.build():null;
    }

    public A withMountPoint(MountPoint MountPoint){
            _visitables.remove(this.MountPoint);
            if (MountPoint!=null){ this.MountPoint= new MountPointBuilder(MountPoint); _visitables.add(this.MountPoint);} return (A) this;
    }

    public Boolean hasMountPoint(){
            return this.MountPoint!=null;
    }

    public DockerSchemaFluent.MountPointNested<A> withNewMountPoint(){
            return new MountPointNestedImpl();
    }

    public DockerSchemaFluent.MountPointNested<A> withNewMountPointLike(MountPoint item){
            return new MountPointNestedImpl(item);
    }

    public DockerSchemaFluent.MountPointNested<A> editMountPoint(){
            return withNewMountPointLike(getMountPoint());
    }

    public DockerSchemaFluent.MountPointNested<A> editOrNewMountPoint(){
            return withNewMountPointLike(getMountPoint() != null ? getMountPoint(): new MountPointBuilder().build());
    }

    public DockerSchemaFluent.MountPointNested<A> editOrNewMountPointLike(MountPoint item){
            return withNewMountPointLike(getMountPoint() != null ? getMountPoint(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNetworkConnect instead.
 */
@Deprecated public NetworkConnect getNetworkConnect(){
            return this.NetworkConnect!=null?this.NetworkConnect.build():null;
    }

    public NetworkConnect buildNetworkConnect(){
            return this.NetworkConnect!=null?this.NetworkConnect.build():null;
    }

    public A withNetworkConnect(NetworkConnect NetworkConnect){
            _visitables.remove(this.NetworkConnect);
            if (NetworkConnect!=null){ this.NetworkConnect= new NetworkConnectBuilder(NetworkConnect); _visitables.add(this.NetworkConnect);} return (A) this;
    }

    public Boolean hasNetworkConnect(){
            return this.NetworkConnect!=null;
    }

    public DockerSchemaFluent.NetworkConnectNested<A> withNewNetworkConnect(){
            return new NetworkConnectNestedImpl();
    }

    public DockerSchemaFluent.NetworkConnectNested<A> withNewNetworkConnectLike(NetworkConnect item){
            return new NetworkConnectNestedImpl(item);
    }

    public DockerSchemaFluent.NetworkConnectNested<A> editNetworkConnect(){
            return withNewNetworkConnectLike(getNetworkConnect());
    }

    public DockerSchemaFluent.NetworkConnectNested<A> editOrNewNetworkConnect(){
            return withNewNetworkConnectLike(getNetworkConnect() != null ? getNetworkConnect(): new NetworkConnectBuilder().build());
    }

    public DockerSchemaFluent.NetworkConnectNested<A> editOrNewNetworkConnectLike(NetworkConnect item){
            return withNewNetworkConnectLike(getNetworkConnect() != null ? getNetworkConnect(): item);
    }

    public A withNewNetworkConnect(String Container){
            return (A)withNetworkConnect(new NetworkConnect(Container));
    }

    
/**
 * This method has been deprecated, please use method buildNetworkCreate instead.
 */
@Deprecated public NetworkCreate getNetworkCreate(){
            return this.NetworkCreate!=null?this.NetworkCreate.build():null;
    }

    public NetworkCreate buildNetworkCreate(){
            return this.NetworkCreate!=null?this.NetworkCreate.build():null;
    }

    public A withNetworkCreate(NetworkCreate NetworkCreate){
            _visitables.remove(this.NetworkCreate);
            if (NetworkCreate!=null){ this.NetworkCreate= new NetworkCreateBuilder(NetworkCreate); _visitables.add(this.NetworkCreate);} return (A) this;
    }

    public Boolean hasNetworkCreate(){
            return this.NetworkCreate!=null;
    }

    public DockerSchemaFluent.NetworkCreateNested<A> withNewNetworkCreate(){
            return new NetworkCreateNestedImpl();
    }

    public DockerSchemaFluent.NetworkCreateNested<A> withNewNetworkCreateLike(NetworkCreate item){
            return new NetworkCreateNestedImpl(item);
    }

    public DockerSchemaFluent.NetworkCreateNested<A> editNetworkCreate(){
            return withNewNetworkCreateLike(getNetworkCreate());
    }

    public DockerSchemaFluent.NetworkCreateNested<A> editOrNewNetworkCreate(){
            return withNewNetworkCreateLike(getNetworkCreate() != null ? getNetworkCreate(): new NetworkCreateBuilder().build());
    }

    public DockerSchemaFluent.NetworkCreateNested<A> editOrNewNetworkCreateLike(NetworkCreate item){
            return withNewNetworkCreateLike(getNetworkCreate() != null ? getNetworkCreate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNetworkCreateResponse instead.
 */
@Deprecated public NetworkCreateResponse getNetworkCreateResponse(){
            return this.NetworkCreateResponse!=null?this.NetworkCreateResponse.build():null;
    }

    public NetworkCreateResponse buildNetworkCreateResponse(){
            return this.NetworkCreateResponse!=null?this.NetworkCreateResponse.build():null;
    }

    public A withNetworkCreateResponse(NetworkCreateResponse NetworkCreateResponse){
            _visitables.remove(this.NetworkCreateResponse);
            if (NetworkCreateResponse!=null){ this.NetworkCreateResponse= new NetworkCreateResponseBuilder(NetworkCreateResponse); _visitables.add(this.NetworkCreateResponse);} return (A) this;
    }

    public Boolean hasNetworkCreateResponse(){
            return this.NetworkCreateResponse!=null;
    }

    public DockerSchemaFluent.NetworkCreateResponseNested<A> withNewNetworkCreateResponse(){
            return new NetworkCreateResponseNestedImpl();
    }

    public DockerSchemaFluent.NetworkCreateResponseNested<A> withNewNetworkCreateResponseLike(NetworkCreateResponse item){
            return new NetworkCreateResponseNestedImpl(item);
    }

    public DockerSchemaFluent.NetworkCreateResponseNested<A> editNetworkCreateResponse(){
            return withNewNetworkCreateResponseLike(getNetworkCreateResponse());
    }

    public DockerSchemaFluent.NetworkCreateResponseNested<A> editOrNewNetworkCreateResponse(){
            return withNewNetworkCreateResponseLike(getNetworkCreateResponse() != null ? getNetworkCreateResponse(): new NetworkCreateResponseBuilder().build());
    }

    public DockerSchemaFluent.NetworkCreateResponseNested<A> editOrNewNetworkCreateResponseLike(NetworkCreateResponse item){
            return withNewNetworkCreateResponseLike(getNetworkCreateResponse() != null ? getNetworkCreateResponse(): item);
    }

    public A withNewNetworkCreateResponse(String Id,String Warning){
            return (A)withNetworkCreateResponse(new NetworkCreateResponse(Id, Warning));
    }

    
/**
 * This method has been deprecated, please use method buildNetworkDisconnect instead.
 */
@Deprecated public NetworkDisconnect getNetworkDisconnect(){
            return this.NetworkDisconnect!=null?this.NetworkDisconnect.build():null;
    }

    public NetworkDisconnect buildNetworkDisconnect(){
            return this.NetworkDisconnect!=null?this.NetworkDisconnect.build():null;
    }

    public A withNetworkDisconnect(NetworkDisconnect NetworkDisconnect){
            _visitables.remove(this.NetworkDisconnect);
            if (NetworkDisconnect!=null){ this.NetworkDisconnect= new NetworkDisconnectBuilder(NetworkDisconnect); _visitables.add(this.NetworkDisconnect);} return (A) this;
    }

    public Boolean hasNetworkDisconnect(){
            return this.NetworkDisconnect!=null;
    }

    public DockerSchemaFluent.NetworkDisconnectNested<A> withNewNetworkDisconnect(){
            return new NetworkDisconnectNestedImpl();
    }

    public DockerSchemaFluent.NetworkDisconnectNested<A> withNewNetworkDisconnectLike(NetworkDisconnect item){
            return new NetworkDisconnectNestedImpl(item);
    }

    public DockerSchemaFluent.NetworkDisconnectNested<A> editNetworkDisconnect(){
            return withNewNetworkDisconnectLike(getNetworkDisconnect());
    }

    public DockerSchemaFluent.NetworkDisconnectNested<A> editOrNewNetworkDisconnect(){
            return withNewNetworkDisconnectLike(getNetworkDisconnect() != null ? getNetworkDisconnect(): new NetworkDisconnectBuilder().build());
    }

    public DockerSchemaFluent.NetworkDisconnectNested<A> editOrNewNetworkDisconnectLike(NetworkDisconnect item){
            return withNewNetworkDisconnectLike(getNetworkDisconnect() != null ? getNetworkDisconnect(): item);
    }

    public A withNewNetworkDisconnect(String Container){
            return (A)withNetworkDisconnect(new NetworkDisconnect(Container));
    }

    
/**
 * This method has been deprecated, please use method buildNetworkResource instead.
 */
@Deprecated public NetworkResource getNetworkResource(){
            return this.NetworkResource!=null?this.NetworkResource.build():null;
    }

    public NetworkResource buildNetworkResource(){
            return this.NetworkResource!=null?this.NetworkResource.build():null;
    }

    public A withNetworkResource(NetworkResource NetworkResource){
            _visitables.remove(this.NetworkResource);
            if (NetworkResource!=null){ this.NetworkResource= new NetworkResourceBuilder(NetworkResource); _visitables.add(this.NetworkResource);} return (A) this;
    }

    public Boolean hasNetworkResource(){
            return this.NetworkResource!=null;
    }

    public DockerSchemaFluent.NetworkResourceNested<A> withNewNetworkResource(){
            return new NetworkResourceNestedImpl();
    }

    public DockerSchemaFluent.NetworkResourceNested<A> withNewNetworkResourceLike(NetworkResource item){
            return new NetworkResourceNestedImpl(item);
    }

    public DockerSchemaFluent.NetworkResourceNested<A> editNetworkResource(){
            return withNewNetworkResourceLike(getNetworkResource());
    }

    public DockerSchemaFluent.NetworkResourceNested<A> editOrNewNetworkResource(){
            return withNewNetworkResourceLike(getNetworkResource() != null ? getNetworkResource(): new NetworkResourceBuilder().build());
    }

    public DockerSchemaFluent.NetworkResourceNested<A> editOrNewNetworkResourceLike(NetworkResource item){
            return withNewNetworkResourceLike(getNetworkResource() != null ? getNetworkResource(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNetworkSettings instead.
 */
@Deprecated public NetworkSettings getNetworkSettings(){
            return this.NetworkSettings!=null?this.NetworkSettings.build():null;
    }

    public NetworkSettings buildNetworkSettings(){
            return this.NetworkSettings!=null?this.NetworkSettings.build():null;
    }

    public A withNetworkSettings(NetworkSettings NetworkSettings){
            _visitables.remove(this.NetworkSettings);
            if (NetworkSettings!=null){ this.NetworkSettings= new NetworkSettingsBuilder(NetworkSettings); _visitables.add(this.NetworkSettings);} return (A) this;
    }

    public Boolean hasNetworkSettings(){
            return this.NetworkSettings!=null;
    }

    public DockerSchemaFluent.NetworkSettingsNested<A> withNewNetworkSettings(){
            return new NetworkSettingsNestedImpl();
    }

    public DockerSchemaFluent.NetworkSettingsNested<A> withNewNetworkSettingsLike(NetworkSettings item){
            return new NetworkSettingsNestedImpl(item);
    }

    public DockerSchemaFluent.NetworkSettingsNested<A> editNetworkSettings(){
            return withNewNetworkSettingsLike(getNetworkSettings());
    }

    public DockerSchemaFluent.NetworkSettingsNested<A> editOrNewNetworkSettings(){
            return withNewNetworkSettingsLike(getNetworkSettings() != null ? getNetworkSettings(): new NetworkSettingsBuilder().build());
    }

    public DockerSchemaFluent.NetworkSettingsNested<A> editOrNewNetworkSettingsLike(NetworkSettings item){
            return withNewNetworkSettingsLike(getNetworkSettings() != null ? getNetworkSettings(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNetworkSettingsBase instead.
 */
@Deprecated public NetworkSettingsBase getNetworkSettingsBase(){
            return this.NetworkSettingsBase!=null?this.NetworkSettingsBase.build():null;
    }

    public NetworkSettingsBase buildNetworkSettingsBase(){
            return this.NetworkSettingsBase!=null?this.NetworkSettingsBase.build():null;
    }

    public A withNetworkSettingsBase(NetworkSettingsBase NetworkSettingsBase){
            _visitables.remove(this.NetworkSettingsBase);
            if (NetworkSettingsBase!=null){ this.NetworkSettingsBase= new NetworkSettingsBaseBuilder(NetworkSettingsBase); _visitables.add(this.NetworkSettingsBase);} return (A) this;
    }

    public Boolean hasNetworkSettingsBase(){
            return this.NetworkSettingsBase!=null;
    }

    public DockerSchemaFluent.NetworkSettingsBaseNested<A> withNewNetworkSettingsBase(){
            return new NetworkSettingsBaseNestedImpl();
    }

    public DockerSchemaFluent.NetworkSettingsBaseNested<A> withNewNetworkSettingsBaseLike(NetworkSettingsBase item){
            return new NetworkSettingsBaseNestedImpl(item);
    }

    public DockerSchemaFluent.NetworkSettingsBaseNested<A> editNetworkSettingsBase(){
            return withNewNetworkSettingsBaseLike(getNetworkSettingsBase());
    }

    public DockerSchemaFluent.NetworkSettingsBaseNested<A> editOrNewNetworkSettingsBase(){
            return withNewNetworkSettingsBaseLike(getNetworkSettingsBase() != null ? getNetworkSettingsBase(): new NetworkSettingsBaseBuilder().build());
    }

    public DockerSchemaFluent.NetworkSettingsBaseNested<A> editOrNewNetworkSettingsBaseLike(NetworkSettingsBase item){
            return withNewNetworkSettingsBaseLike(getNetworkSettingsBase() != null ? getNetworkSettingsBase(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 */
@Deprecated public Port getPort(){
            return this.Port!=null?this.Port.build():null;
    }

    public Port buildPort(){
            return this.Port!=null?this.Port.build():null;
    }

    public A withPort(Port Port){
            _visitables.remove(this.Port);
            if (Port!=null){ this.Port= new PortBuilder(Port); _visitables.add(this.Port);} return (A) this;
    }

    public Boolean hasPort(){
            return this.Port!=null;
    }

    public DockerSchemaFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public DockerSchemaFluent.PortNested<A> withNewPortLike(Port item){
            return new PortNestedImpl(item);
    }

    public DockerSchemaFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public DockerSchemaFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new PortBuilder().build());
    }

    public DockerSchemaFluent.PortNested<A> editOrNewPortLike(Port item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    public A withNewPort(String IP,Integer PrivatePort,Integer PublicPort,String Type){
            return (A)withPort(new Port(IP, PrivatePort, PublicPort, Type));
    }

    
/**
 * This method has been deprecated, please use method buildPortBinding instead.
 */
@Deprecated public PortBinding getPortBinding(){
            return this.PortBinding!=null?this.PortBinding.build():null;
    }

    public PortBinding buildPortBinding(){
            return this.PortBinding!=null?this.PortBinding.build():null;
    }

    public A withPortBinding(PortBinding PortBinding){
            _visitables.remove(this.PortBinding);
            if (PortBinding!=null){ this.PortBinding= new PortBindingBuilder(PortBinding); _visitables.add(this.PortBinding);} return (A) this;
    }

    public Boolean hasPortBinding(){
            return this.PortBinding!=null;
    }

    public DockerSchemaFluent.PortBindingNested<A> withNewPortBinding(){
            return new PortBindingNestedImpl();
    }

    public DockerSchemaFluent.PortBindingNested<A> withNewPortBindingLike(PortBinding item){
            return new PortBindingNestedImpl(item);
    }

    public DockerSchemaFluent.PortBindingNested<A> editPortBinding(){
            return withNewPortBindingLike(getPortBinding());
    }

    public DockerSchemaFluent.PortBindingNested<A> editOrNewPortBinding(){
            return withNewPortBindingLike(getPortBinding() != null ? getPortBinding(): new PortBindingBuilder().build());
    }

    public DockerSchemaFluent.PortBindingNested<A> editOrNewPortBindingLike(PortBinding item){
            return withNewPortBindingLike(getPortBinding() != null ? getPortBinding(): item);
    }

    public A withNewPortBinding(String HostIp,String HostPort){
            return (A)withPortBinding(new PortBinding(HostIp, HostPort));
    }

    
/**
 * This method has been deprecated, please use method buildSearchResult instead.
 */
@Deprecated public SearchResult getSearchResult(){
            return this.SearchResult!=null?this.SearchResult.build():null;
    }

    public SearchResult buildSearchResult(){
            return this.SearchResult!=null?this.SearchResult.build():null;
    }

    public A withSearchResult(SearchResult SearchResult){
            _visitables.remove(this.SearchResult);
            if (SearchResult!=null){ this.SearchResult= new SearchResultBuilder(SearchResult); _visitables.add(this.SearchResult);} return (A) this;
    }

    public Boolean hasSearchResult(){
            return this.SearchResult!=null;
    }

    public DockerSchemaFluent.SearchResultNested<A> withNewSearchResult(){
            return new SearchResultNestedImpl();
    }

    public DockerSchemaFluent.SearchResultNested<A> withNewSearchResultLike(SearchResult item){
            return new SearchResultNestedImpl(item);
    }

    public DockerSchemaFluent.SearchResultNested<A> editSearchResult(){
            return withNewSearchResultLike(getSearchResult());
    }

    public DockerSchemaFluent.SearchResultNested<A> editOrNewSearchResult(){
            return withNewSearchResultLike(getSearchResult() != null ? getSearchResult(): new SearchResultBuilder().build());
    }

    public DockerSchemaFluent.SearchResultNested<A> editOrNewSearchResultLike(SearchResult item){
            return withNewSearchResultLike(getSearchResult() != null ? getSearchResult(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSearchResults instead.
 */
@Deprecated public SearchResults getSearchResults(){
            return this.SearchResults!=null?this.SearchResults.build():null;
    }

    public SearchResults buildSearchResults(){
            return this.SearchResults!=null?this.SearchResults.build():null;
    }

    public A withSearchResults(SearchResults SearchResults){
            _visitables.remove(this.SearchResults);
            if (SearchResults!=null){ this.SearchResults= new SearchResultsBuilder(SearchResults); _visitables.add(this.SearchResults);} return (A) this;
    }

    public Boolean hasSearchResults(){
            return this.SearchResults!=null;
    }

    public DockerSchemaFluent.SearchResultsNested<A> withNewSearchResults(){
            return new SearchResultsNestedImpl();
    }

    public DockerSchemaFluent.SearchResultsNested<A> withNewSearchResultsLike(SearchResults item){
            return new SearchResultsNestedImpl(item);
    }

    public DockerSchemaFluent.SearchResultsNested<A> editSearchResults(){
            return withNewSearchResultsLike(getSearchResults());
    }

    public DockerSchemaFluent.SearchResultsNested<A> editOrNewSearchResults(){
            return withNewSearchResultsLike(getSearchResults() != null ? getSearchResults(): new SearchResultsBuilder().build());
    }

    public DockerSchemaFluent.SearchResultsNested<A> editOrNewSearchResultsLike(SearchResults item){
            return withNewSearchResultsLike(getSearchResults() != null ? getSearchResults(): item);
    }

    
/**
 * This method has been deprecated, please use method buildServiceConfig instead.
 */
@Deprecated public ServiceConfig getServiceConfig(){
            return this.ServiceConfig!=null?this.ServiceConfig.build():null;
    }

    public ServiceConfig buildServiceConfig(){
            return this.ServiceConfig!=null?this.ServiceConfig.build():null;
    }

    public A withServiceConfig(ServiceConfig ServiceConfig){
            _visitables.remove(this.ServiceConfig);
            if (ServiceConfig!=null){ this.ServiceConfig= new ServiceConfigBuilder(ServiceConfig); _visitables.add(this.ServiceConfig);} return (A) this;
    }

    public Boolean hasServiceConfig(){
            return this.ServiceConfig!=null;
    }

    public DockerSchemaFluent.ServiceConfigNested<A> withNewServiceConfig(){
            return new ServiceConfigNestedImpl();
    }

    public DockerSchemaFluent.ServiceConfigNested<A> withNewServiceConfigLike(ServiceConfig item){
            return new ServiceConfigNestedImpl(item);
    }

    public DockerSchemaFluent.ServiceConfigNested<A> editServiceConfig(){
            return withNewServiceConfigLike(getServiceConfig());
    }

    public DockerSchemaFluent.ServiceConfigNested<A> editOrNewServiceConfig(){
            return withNewServiceConfigLike(getServiceConfig() != null ? getServiceConfig(): new ServiceConfigBuilder().build());
    }

    public DockerSchemaFluent.ServiceConfigNested<A> editOrNewServiceConfigLike(ServiceConfig item){
            return withNewServiceConfigLike(getServiceConfig() != null ? getServiceConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStats instead.
 */
@Deprecated public Stats getStats(){
            return this.Stats!=null?this.Stats.build():null;
    }

    public Stats buildStats(){
            return this.Stats!=null?this.Stats.build():null;
    }

    public A withStats(Stats Stats){
            _visitables.remove(this.Stats);
            if (Stats!=null){ this.Stats= new StatsBuilder(Stats); _visitables.add(this.Stats);} return (A) this;
    }

    public Boolean hasStats(){
            return this.Stats!=null;
    }

    public DockerSchemaFluent.StatsNested<A> withNewStats(){
            return new StatsNestedImpl();
    }

    public DockerSchemaFluent.StatsNested<A> withNewStatsLike(Stats item){
            return new StatsNestedImpl(item);
    }

    public DockerSchemaFluent.StatsNested<A> editStats(){
            return withNewStatsLike(getStats());
    }

    public DockerSchemaFluent.StatsNested<A> editOrNewStats(){
            return withNewStatsLike(getStats() != null ? getStats(): new StatsBuilder().build());
    }

    public DockerSchemaFluent.StatsNested<A> editOrNewStatsLike(Stats item){
            return withNewStatsLike(getStats() != null ? getStats(): item);
    }

    public A addToStrSlice(int index,String item){
            this.StrSlice.add(index, item); return (A)this;
    }

    public A setToStrSlice(int index,String item){
            this.StrSlice.set(index, item); return (A)this;
    }

    public A addToStrSlice(String... items){
            for (String item : items) {this.StrSlice.add(item);} return (A)this;
    }

    public A addAllToStrSlice(Collection<String> items){
            for (String item : items) {this.StrSlice.add(item);} return (A)this;
    }

    public A removeFromStrSlice(String... items){
            for (String item : items) {this.StrSlice.remove(item);} return (A)this;
    }

    public A removeAllFromStrSlice(Collection<String> items){
            for (String item : items) {this.StrSlice.remove(item);} return (A)this;
    }

    public List<String> getStrSlice(){
            return this.StrSlice;
    }

    public String getStrSlouse(int index){
            return this.StrSlice.get(index);
    }

    public String getFirstStrSlouse(){
            return this.StrSlice.get(0);
    }

    public String getLastStrSlouse(){
            return this.StrSlice.get(StrSlice.size() - 1);
    }

    public String getMatchingStrSlouse(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: StrSlice) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withStrSlice(List<String> StrSlice){
            this.StrSlice.clear();
            if (StrSlice != null) {for (String item : StrSlice){this.addToStrSlice(item);}} return (A) this;
    }

    public A withStrSlice(String... StrSlice){
            this.StrSlice.clear(); if (StrSlice != null) {for (String item :StrSlice){ this.addToStrSlice(item);}} return (A) this;
    }

    public Boolean hasStrSlice(){
            return StrSlice!= null && !StrSlice.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildVersion instead.
 */
@Deprecated public io.fabric8.docker.api.model.Version getVersion(){
            return this.Version!=null?this.Version.build():null;
    }

    public io.fabric8.docker.api.model.Version buildVersion(){
            return this.Version!=null?this.Version.build():null;
    }

    public A withVersion(io.fabric8.docker.api.model.Version Version){
            _visitables.remove(this.Version);
            if (Version!=null){ this.Version= new VersionBuilder(Version); _visitables.add(this.Version);} return (A) this;
    }

    public Boolean hasVersion(){
            return this.Version!=null;
    }

    public DockerSchemaFluent.VersionNested<A> withNewVersion(){
            return new VersionNestedImpl();
    }

    public DockerSchemaFluent.VersionNested<A> withNewVersionLike(io.fabric8.docker.api.model.Version item){
            return new VersionNestedImpl(item);
    }

    public DockerSchemaFluent.VersionNested<A> editVersion(){
            return withNewVersionLike(getVersion());
    }

    public DockerSchemaFluent.VersionNested<A> editOrNewVersion(){
            return withNewVersionLike(getVersion() != null ? getVersion(): new VersionBuilder().build());
    }

    public DockerSchemaFluent.VersionNested<A> editOrNewVersionLike(io.fabric8.docker.api.model.Version item){
            return withNewVersionLike(getVersion() != null ? getVersion(): item);
    }

    
/**
 * This method has been deprecated, please use method buildVolume instead.
 */
@Deprecated public Volume getVolume(){
            return this.Volume!=null?this.Volume.build():null;
    }

    public Volume buildVolume(){
            return this.Volume!=null?this.Volume.build():null;
    }

    public A withVolume(Volume Volume){
            _visitables.remove(this.Volume);
            if (Volume!=null){ this.Volume= new VolumeBuilder(Volume); _visitables.add(this.Volume);} return (A) this;
    }

    public Boolean hasVolume(){
            return this.Volume!=null;
    }

    public DockerSchemaFluent.VolumeNested<A> withNewVolume(){
            return new VolumeNestedImpl();
    }

    public DockerSchemaFluent.VolumeNested<A> withNewVolumeLike(Volume item){
            return new VolumeNestedImpl(item);
    }

    public DockerSchemaFluent.VolumeNested<A> editVolume(){
            return withNewVolumeLike(getVolume());
    }

    public DockerSchemaFluent.VolumeNested<A> editOrNewVolume(){
            return withNewVolumeLike(getVolume() != null ? getVolume(): new VolumeBuilder().build());
    }

    public DockerSchemaFluent.VolumeNested<A> editOrNewVolumeLike(Volume item){
            return withNewVolumeLike(getVolume() != null ? getVolume(): item);
    }

    public A withNewVolume(String Driver,String Mountpoint,String Name){
            return (A)withVolume(new Volume(Driver, Mountpoint, Name));
    }

    
/**
 * This method has been deprecated, please use method buildVolumeCreateRequest instead.
 */
@Deprecated public VolumeCreateRequest getVolumeCreateRequest(){
            return this.VolumeCreateRequest!=null?this.VolumeCreateRequest.build():null;
    }

    public VolumeCreateRequest buildVolumeCreateRequest(){
            return this.VolumeCreateRequest!=null?this.VolumeCreateRequest.build():null;
    }

    public A withVolumeCreateRequest(VolumeCreateRequest VolumeCreateRequest){
            _visitables.remove(this.VolumeCreateRequest);
            if (VolumeCreateRequest!=null){ this.VolumeCreateRequest= new VolumeCreateRequestBuilder(VolumeCreateRequest); _visitables.add(this.VolumeCreateRequest);} return (A) this;
    }

    public Boolean hasVolumeCreateRequest(){
            return this.VolumeCreateRequest!=null;
    }

    public DockerSchemaFluent.VolumeCreateRequestNested<A> withNewVolumeCreateRequest(){
            return new VolumeCreateRequestNestedImpl();
    }

    public DockerSchemaFluent.VolumeCreateRequestNested<A> withNewVolumeCreateRequestLike(VolumeCreateRequest item){
            return new VolumeCreateRequestNestedImpl(item);
    }

    public DockerSchemaFluent.VolumeCreateRequestNested<A> editVolumeCreateRequest(){
            return withNewVolumeCreateRequestLike(getVolumeCreateRequest());
    }

    public DockerSchemaFluent.VolumeCreateRequestNested<A> editOrNewVolumeCreateRequest(){
            return withNewVolumeCreateRequestLike(getVolumeCreateRequest() != null ? getVolumeCreateRequest(): new VolumeCreateRequestBuilder().build());
    }

    public DockerSchemaFluent.VolumeCreateRequestNested<A> editOrNewVolumeCreateRequestLike(VolumeCreateRequest item){
            return withNewVolumeCreateRequestLike(getVolumeCreateRequest() != null ? getVolumeCreateRequest(): item);
    }

    
/**
 * This method has been deprecated, please use method buildVolumesListResponse instead.
 */
@Deprecated public VolumesListResponse getVolumesListResponse(){
            return this.VolumesListResponse!=null?this.VolumesListResponse.build():null;
    }

    public VolumesListResponse buildVolumesListResponse(){
            return this.VolumesListResponse!=null?this.VolumesListResponse.build():null;
    }

    public A withVolumesListResponse(VolumesListResponse VolumesListResponse){
            _visitables.remove(this.VolumesListResponse);
            if (VolumesListResponse!=null){ this.VolumesListResponse= new VolumesListResponseBuilder(VolumesListResponse); _visitables.add(this.VolumesListResponse);} return (A) this;
    }

    public Boolean hasVolumesListResponse(){
            return this.VolumesListResponse!=null;
    }

    public DockerSchemaFluent.VolumesListResponseNested<A> withNewVolumesListResponse(){
            return new VolumesListResponseNestedImpl();
    }

    public DockerSchemaFluent.VolumesListResponseNested<A> withNewVolumesListResponseLike(VolumesListResponse item){
            return new VolumesListResponseNestedImpl(item);
    }

    public DockerSchemaFluent.VolumesListResponseNested<A> editVolumesListResponse(){
            return withNewVolumesListResponseLike(getVolumesListResponse());
    }

    public DockerSchemaFluent.VolumesListResponseNested<A> editOrNewVolumesListResponse(){
            return withNewVolumesListResponseLike(getVolumesListResponse() != null ? getVolumesListResponse(): new VolumesListResponseBuilder().build());
    }

    public DockerSchemaFluent.VolumesListResponseNested<A> editOrNewVolumesListResponseLike(VolumesListResponse item){
            return withNewVolumesListResponseLike(getVolumesListResponse() != null ? getVolumesListResponse(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerSchemaFluentImpl that = (DockerSchemaFluentImpl) o;
            if (Address != null ? !Address.equals(that.Address) :that.Address != null) return false;
            if (AuthConfig != null ? !AuthConfig.equals(that.AuthConfig) :that.AuthConfig != null) return false;
            if (AuthResponse != null ? !AuthResponse.equals(that.AuthResponse) :that.AuthResponse != null) return false;
            if (ContainerChange != null ? !ContainerChange.equals(that.ContainerChange) :that.ContainerChange != null) return false;
            if (ContainerCommitResponse != null ? !ContainerCommitResponse.equals(that.ContainerCommitResponse) :that.ContainerCommitResponse != null) return false;
            if (ContainerCreateResponse != null ? !ContainerCreateResponse.equals(that.ContainerCreateResponse) :that.ContainerCreateResponse != null) return false;
            if (ContainerExecCreateResponse != null ? !ContainerExecCreateResponse.equals(that.ContainerExecCreateResponse) :that.ContainerExecCreateResponse != null) return false;
            if (ContainerJSONBase != null ? !ContainerJSONBase.equals(that.ContainerJSONBase) :that.ContainerJSONBase != null) return false;
            if (ContainerPathStat != null ? !ContainerPathStat.equals(that.ContainerPathStat) :that.ContainerPathStat != null) return false;
            if (ContainerProcessList != null ? !ContainerProcessList.equals(that.ContainerProcessList) :that.ContainerProcessList != null) return false;
            if (ContainerState != null ? !ContainerState.equals(that.ContainerState) :that.ContainerState != null) return false;
            if (ContainerWaitResponse != null ? !ContainerWaitResponse.equals(that.ContainerWaitResponse) :that.ContainerWaitResponse != null) return false;
            if (CopyConfig != null ? !CopyConfig.equals(that.CopyConfig) :that.CopyConfig != null) return false;
            if (DefaultNetworkSettings != null ? !DefaultNetworkSettings.equals(that.DefaultNetworkSettings) :that.DefaultNetworkSettings != null) return false;
            if (EndpointResource != null ? !EndpointResource.equals(that.EndpointResource) :that.EndpointResource != null) return false;
            if (EndpointSettings != null ? !EndpointSettings.equals(that.EndpointSettings) :that.EndpointSettings != null) return false;
            if (ExecConfig != null ? !ExecConfig.equals(that.ExecConfig) :that.ExecConfig != null) return false;
            if (ExecStartCheck != null ? !ExecStartCheck.equals(that.ExecStartCheck) :that.ExecStartCheck != null) return false;
            if (GraphDriverData != null ? !GraphDriverData.equals(that.GraphDriverData) :that.GraphDriverData != null) return false;
            if (HostConfig != null ? !HostConfig.equals(that.HostConfig) :that.HostConfig != null) return false;
            if (IPAM != null ? !IPAM.equals(that.IPAM) :that.IPAM != null) return false;
            if (IPAMConfig != null ? !IPAMConfig.equals(that.IPAMConfig) :that.IPAMConfig != null) return false;
            if (Image != null ? !Image.equals(that.Image) :that.Image != null) return false;
            if (ImageDelete != null ? !ImageDelete.equals(that.ImageDelete) :that.ImageDelete != null) return false;
            if (ImageHistory != null ? !ImageHistory.equals(that.ImageHistory) :that.ImageHistory != null) return false;
            if (ImageInspect != null ? !ImageInspect.equals(that.ImageInspect) :that.ImageInspect != null) return false;
            if (IndexInfo != null ? !IndexInfo.equals(that.IndexInfo) :that.IndexInfo != null) return false;
            if (Info != null ? !Info.equals(that.Info) :that.Info != null) return false;
            if (KeyValuePair != null ? !KeyValuePair.equals(that.KeyValuePair) :that.KeyValuePair != null) return false;
            if (LogConfig != null ? !LogConfig.equals(that.LogConfig) :that.LogConfig != null) return false;
            if (MountPoint != null ? !MountPoint.equals(that.MountPoint) :that.MountPoint != null) return false;
            if (NetworkConnect != null ? !NetworkConnect.equals(that.NetworkConnect) :that.NetworkConnect != null) return false;
            if (NetworkCreate != null ? !NetworkCreate.equals(that.NetworkCreate) :that.NetworkCreate != null) return false;
            if (NetworkCreateResponse != null ? !NetworkCreateResponse.equals(that.NetworkCreateResponse) :that.NetworkCreateResponse != null) return false;
            if (NetworkDisconnect != null ? !NetworkDisconnect.equals(that.NetworkDisconnect) :that.NetworkDisconnect != null) return false;
            if (NetworkResource != null ? !NetworkResource.equals(that.NetworkResource) :that.NetworkResource != null) return false;
            if (NetworkSettings != null ? !NetworkSettings.equals(that.NetworkSettings) :that.NetworkSettings != null) return false;
            if (NetworkSettingsBase != null ? !NetworkSettingsBase.equals(that.NetworkSettingsBase) :that.NetworkSettingsBase != null) return false;
            if (Port != null ? !Port.equals(that.Port) :that.Port != null) return false;
            if (PortBinding != null ? !PortBinding.equals(that.PortBinding) :that.PortBinding != null) return false;
            if (SearchResult != null ? !SearchResult.equals(that.SearchResult) :that.SearchResult != null) return false;
            if (SearchResults != null ? !SearchResults.equals(that.SearchResults) :that.SearchResults != null) return false;
            if (ServiceConfig != null ? !ServiceConfig.equals(that.ServiceConfig) :that.ServiceConfig != null) return false;
            if (Stats != null ? !Stats.equals(that.Stats) :that.Stats != null) return false;
            if (StrSlice != null ? !StrSlice.equals(that.StrSlice) :that.StrSlice != null) return false;
            if (Version != null ? !Version.equals(that.Version) :that.Version != null) return false;
            if (Volume != null ? !Volume.equals(that.Volume) :that.Volume != null) return false;
            if (VolumeCreateRequest != null ? !VolumeCreateRequest.equals(that.VolumeCreateRequest) :that.VolumeCreateRequest != null) return false;
            if (VolumesListResponse != null ? !VolumesListResponse.equals(that.VolumesListResponse) :that.VolumesListResponse != null) return false;
            return true;
    }


    public class AddressNestedImpl<N> extends AddressFluentImpl<DockerSchemaFluent.AddressNested<N>> implements DockerSchemaFluent.AddressNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final AddressBuilder builder;
    
            AddressNestedImpl(Address item){
                    this.builder = new AddressBuilder(this, item);
            }
            AddressNestedImpl(){
                    this.builder = new AddressBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class AuthConfigNestedImpl<N> extends AuthConfigFluentImpl<DockerSchemaFluent.AuthConfigNested<N>> implements DockerSchemaFluent.AuthConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final AuthConfigBuilder builder;
    
            AuthConfigNestedImpl(AuthConfig item){
                    this.builder = new AuthConfigBuilder(this, item);
            }
            AuthConfigNestedImpl(){
                    this.builder = new AuthConfigBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withAuthConfig(builder.build());
    }
    public N endAuthConfig(){
            return and();
    }

}
    public class AuthResponseNestedImpl<N> extends AuthResponseFluentImpl<DockerSchemaFluent.AuthResponseNested<N>> implements DockerSchemaFluent.AuthResponseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final AuthResponseBuilder builder;
    
            AuthResponseNestedImpl(AuthResponse item){
                    this.builder = new AuthResponseBuilder(this, item);
            }
            AuthResponseNestedImpl(){
                    this.builder = new AuthResponseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withAuthResponse(builder.build());
    }
    public N endAuthResponse(){
            return and();
    }

}
    public class ContainerChangeNestedImpl<N> extends ContainerChangeFluentImpl<DockerSchemaFluent.ContainerChangeNested<N>> implements DockerSchemaFluent.ContainerChangeNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerChangeBuilder builder;
    
            ContainerChangeNestedImpl(ContainerChange item){
                    this.builder = new ContainerChangeBuilder(this, item);
            }
            ContainerChangeNestedImpl(){
                    this.builder = new ContainerChangeBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerChange(builder.build());
    }
    public N endContainerChange(){
            return and();
    }

}
    public class ContainerCommitResponseNestedImpl<N> extends ContainerCommitResponseFluentImpl<DockerSchemaFluent.ContainerCommitResponseNested<N>> implements DockerSchemaFluent.ContainerCommitResponseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerCommitResponseBuilder builder;
    
            ContainerCommitResponseNestedImpl(ContainerCommitResponse item){
                    this.builder = new ContainerCommitResponseBuilder(this, item);
            }
            ContainerCommitResponseNestedImpl(){
                    this.builder = new ContainerCommitResponseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerCommitResponse(builder.build());
    }
    public N endContainerCommitResponse(){
            return and();
    }

}
    public class ContainerCreateResponseNestedImpl<N> extends ContainerCreateResponseFluentImpl<DockerSchemaFluent.ContainerCreateResponseNested<N>> implements DockerSchemaFluent.ContainerCreateResponseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerCreateResponseBuilder builder;
    
            ContainerCreateResponseNestedImpl(ContainerCreateResponse item){
                    this.builder = new ContainerCreateResponseBuilder(this, item);
            }
            ContainerCreateResponseNestedImpl(){
                    this.builder = new ContainerCreateResponseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerCreateResponse(builder.build());
    }
    public N endContainerCreateResponse(){
            return and();
    }

}
    public class ContainerExecCreateResponseNestedImpl<N> extends ContainerExecCreateResponseFluentImpl<DockerSchemaFluent.ContainerExecCreateResponseNested<N>> implements DockerSchemaFluent.ContainerExecCreateResponseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerExecCreateResponseBuilder builder;
    
            ContainerExecCreateResponseNestedImpl(ContainerExecCreateResponse item){
                    this.builder = new ContainerExecCreateResponseBuilder(this, item);
            }
            ContainerExecCreateResponseNestedImpl(){
                    this.builder = new ContainerExecCreateResponseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerExecCreateResponse(builder.build());
    }
    public N endContainerExecCreateResponse(){
            return and();
    }

}
    public class ContainerJSONBaseNestedImpl<N> extends ContainerJSONBaseFluentImpl<DockerSchemaFluent.ContainerJSONBaseNested<N>> implements DockerSchemaFluent.ContainerJSONBaseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerJSONBaseBuilder builder;
    
            ContainerJSONBaseNestedImpl(ContainerJSONBase item){
                    this.builder = new ContainerJSONBaseBuilder(this, item);
            }
            ContainerJSONBaseNestedImpl(){
                    this.builder = new ContainerJSONBaseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerJSONBase(builder.build());
    }
    public N endContainerJSONBase(){
            return and();
    }

}
    public class ContainerPathStatNestedImpl<N> extends ContainerPathStatFluentImpl<DockerSchemaFluent.ContainerPathStatNested<N>> implements DockerSchemaFluent.ContainerPathStatNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerPathStatBuilder builder;
    
            ContainerPathStatNestedImpl(ContainerPathStat item){
                    this.builder = new ContainerPathStatBuilder(this, item);
            }
            ContainerPathStatNestedImpl(){
                    this.builder = new ContainerPathStatBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerPathStat(builder.build());
    }
    public N endContainerPathStat(){
            return and();
    }

}
    public class ContainerProcessListNestedImpl<N> extends ContainerProcessListFluentImpl<DockerSchemaFluent.ContainerProcessListNested<N>> implements DockerSchemaFluent.ContainerProcessListNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerProcessListBuilder builder;
    
            ContainerProcessListNestedImpl(ContainerProcessList item){
                    this.builder = new ContainerProcessListBuilder(this, item);
            }
            ContainerProcessListNestedImpl(){
                    this.builder = new ContainerProcessListBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerProcessList(builder.build());
    }
    public N endContainerProcessList(){
            return and();
    }

}
    public class ContainerStateNestedImpl<N> extends ContainerStateFluentImpl<DockerSchemaFluent.ContainerStateNested<N>> implements DockerSchemaFluent.ContainerStateNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerStateBuilder builder;
    
            ContainerStateNestedImpl(ContainerState item){
                    this.builder = new ContainerStateBuilder(this, item);
            }
            ContainerStateNestedImpl(){
                    this.builder = new ContainerStateBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerState(builder.build());
    }
    public N endContainerState(){
            return and();
    }

}
    public class ContainerWaitResponseNestedImpl<N> extends ContainerWaitResponseFluentImpl<DockerSchemaFluent.ContainerWaitResponseNested<N>> implements DockerSchemaFluent.ContainerWaitResponseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ContainerWaitResponseBuilder builder;
    
            ContainerWaitResponseNestedImpl(ContainerWaitResponse item){
                    this.builder = new ContainerWaitResponseBuilder(this, item);
            }
            ContainerWaitResponseNestedImpl(){
                    this.builder = new ContainerWaitResponseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withContainerWaitResponse(builder.build());
    }
    public N endContainerWaitResponse(){
            return and();
    }

}
    public class CopyConfigNestedImpl<N> extends CopyConfigFluentImpl<DockerSchemaFluent.CopyConfigNested<N>> implements DockerSchemaFluent.CopyConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final CopyConfigBuilder builder;
    
            CopyConfigNestedImpl(CopyConfig item){
                    this.builder = new CopyConfigBuilder(this, item);
            }
            CopyConfigNestedImpl(){
                    this.builder = new CopyConfigBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withCopyConfig(builder.build());
    }
    public N endCopyConfig(){
            return and();
    }

}
    public class DefaultNetworkSettingsNestedImpl<N> extends DefaultNetworkSettingsFluentImpl<DockerSchemaFluent.DefaultNetworkSettingsNested<N>> implements DockerSchemaFluent.DefaultNetworkSettingsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final DefaultNetworkSettingsBuilder builder;
    
            DefaultNetworkSettingsNestedImpl(DefaultNetworkSettings item){
                    this.builder = new DefaultNetworkSettingsBuilder(this, item);
            }
            DefaultNetworkSettingsNestedImpl(){
                    this.builder = new DefaultNetworkSettingsBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withDefaultNetworkSettings(builder.build());
    }
    public N endDefaultNetworkSettings(){
            return and();
    }

}
    public class EndpointResourceNestedImpl<N> extends EndpointResourceFluentImpl<DockerSchemaFluent.EndpointResourceNested<N>> implements DockerSchemaFluent.EndpointResourceNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final EndpointResourceBuilder builder;
    
            EndpointResourceNestedImpl(EndpointResource item){
                    this.builder = new EndpointResourceBuilder(this, item);
            }
            EndpointResourceNestedImpl(){
                    this.builder = new EndpointResourceBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withEndpointResource(builder.build());
    }
    public N endEndpointResource(){
            return and();
    }

}
    public class EndpointSettingsNestedImpl<N> extends EndpointSettingsFluentImpl<DockerSchemaFluent.EndpointSettingsNested<N>> implements DockerSchemaFluent.EndpointSettingsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final EndpointSettingsBuilder builder;
    
            EndpointSettingsNestedImpl(EndpointSettings item){
                    this.builder = new EndpointSettingsBuilder(this, item);
            }
            EndpointSettingsNestedImpl(){
                    this.builder = new EndpointSettingsBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withEndpointSettings(builder.build());
    }
    public N endEndpointSettings(){
            return and();
    }

}
    public class ExecConfigNestedImpl<N> extends ExecConfigFluentImpl<DockerSchemaFluent.ExecConfigNested<N>> implements DockerSchemaFluent.ExecConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ExecConfigBuilder builder;
    
            ExecConfigNestedImpl(ExecConfig item){
                    this.builder = new ExecConfigBuilder(this, item);
            }
            ExecConfigNestedImpl(){
                    this.builder = new ExecConfigBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withExecConfig(builder.build());
    }
    public N endExecConfig(){
            return and();
    }

}
    public class ExecStartCheckNestedImpl<N> extends ExecStartCheckFluentImpl<DockerSchemaFluent.ExecStartCheckNested<N>> implements DockerSchemaFluent.ExecStartCheckNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ExecStartCheckBuilder builder;
    
            ExecStartCheckNestedImpl(ExecStartCheck item){
                    this.builder = new ExecStartCheckBuilder(this, item);
            }
            ExecStartCheckNestedImpl(){
                    this.builder = new ExecStartCheckBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withExecStartCheck(builder.build());
    }
    public N endExecStartCheck(){
            return and();
    }

}
    public class GraphDriverDataNestedImpl<N> extends GraphDriverDataFluentImpl<DockerSchemaFluent.GraphDriverDataNested<N>> implements DockerSchemaFluent.GraphDriverDataNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final GraphDriverDataBuilder builder;
    
            GraphDriverDataNestedImpl(GraphDriverData item){
                    this.builder = new GraphDriverDataBuilder(this, item);
            }
            GraphDriverDataNestedImpl(){
                    this.builder = new GraphDriverDataBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withGraphDriverData(builder.build());
    }
    public N endGraphDriverData(){
            return and();
    }

}
    public class HostConfigNestedImpl<N> extends HostConfigFluentImpl<DockerSchemaFluent.HostConfigNested<N>> implements DockerSchemaFluent.HostConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final HostConfigBuilder builder;
    
            HostConfigNestedImpl(HostConfig item){
                    this.builder = new HostConfigBuilder(this, item);
            }
            HostConfigNestedImpl(){
                    this.builder = new HostConfigBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withHostConfig(builder.build());
    }
    public N endHostConfig(){
            return and();
    }

}
    public class IPAMNestedImpl<N> extends IPAMFluentImpl<DockerSchemaFluent.IPAMNested<N>> implements DockerSchemaFluent.IPAMNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final IPAMBuilder builder;
    
            IPAMNestedImpl(IPAM item){
                    this.builder = new IPAMBuilder(this, item);
            }
            IPAMNestedImpl(){
                    this.builder = new IPAMBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withIPAM(builder.build());
    }
    public N endIPAM(){
            return and();
    }

}
    public class IPAMConfigNestedImpl<N> extends IPAMConfigFluentImpl<DockerSchemaFluent.IPAMConfigNested<N>> implements DockerSchemaFluent.IPAMConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final IPAMConfigBuilder builder;
    
            IPAMConfigNestedImpl(IPAMConfig item){
                    this.builder = new IPAMConfigBuilder(this, item);
            }
            IPAMConfigNestedImpl(){
                    this.builder = new IPAMConfigBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withIPAMConfig(builder.build());
    }
    public N endIPAMConfig(){
            return and();
    }

}
    public class ImageNestedImpl<N> extends ImageFluentImpl<DockerSchemaFluent.ImageNested<N>> implements DockerSchemaFluent.ImageNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ImageBuilder builder;
    
            ImageNestedImpl(Image item){
                    this.builder = new ImageBuilder(this, item);
            }
            ImageNestedImpl(){
                    this.builder = new ImageBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withImage(builder.build());
    }
    public N endImage(){
            return and();
    }

}
    public class ImageDeleteNestedImpl<N> extends ImageDeleteFluentImpl<DockerSchemaFluent.ImageDeleteNested<N>> implements DockerSchemaFluent.ImageDeleteNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ImageDeleteBuilder builder;
    
            ImageDeleteNestedImpl(ImageDelete item){
                    this.builder = new ImageDeleteBuilder(this, item);
            }
            ImageDeleteNestedImpl(){
                    this.builder = new ImageDeleteBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withImageDelete(builder.build());
    }
    public N endImageDelete(){
            return and();
    }

}
    public class ImageHistoryNestedImpl<N> extends ImageHistoryFluentImpl<DockerSchemaFluent.ImageHistoryNested<N>> implements DockerSchemaFluent.ImageHistoryNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ImageHistoryBuilder builder;
    
            ImageHistoryNestedImpl(ImageHistory item){
                    this.builder = new ImageHistoryBuilder(this, item);
            }
            ImageHistoryNestedImpl(){
                    this.builder = new ImageHistoryBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withImageHistory(builder.build());
    }
    public N endImageHistory(){
            return and();
    }

}
    public class ImageInspectNestedImpl<N> extends ImageInspectFluentImpl<DockerSchemaFluent.ImageInspectNested<N>> implements DockerSchemaFluent.ImageInspectNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ImageInspectBuilder builder;
    
            ImageInspectNestedImpl(ImageInspect item){
                    this.builder = new ImageInspectBuilder(this, item);
            }
            ImageInspectNestedImpl(){
                    this.builder = new ImageInspectBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withImageInspect(builder.build());
    }
    public N endImageInspect(){
            return and();
    }

}
    public class IndexInfoNestedImpl<N> extends IndexInfoFluentImpl<DockerSchemaFluent.IndexInfoNested<N>> implements DockerSchemaFluent.IndexInfoNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final IndexInfoBuilder builder;
    
            IndexInfoNestedImpl(IndexInfo item){
                    this.builder = new IndexInfoBuilder(this, item);
            }
            IndexInfoNestedImpl(){
                    this.builder = new IndexInfoBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withIndexInfo(builder.build());
    }
    public N endIndexInfo(){
            return and();
    }

}
    public class InfoNestedImpl<N> extends InfoFluentImpl<DockerSchemaFluent.InfoNested<N>> implements DockerSchemaFluent.InfoNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final InfoBuilder builder;
    
            InfoNestedImpl(Info item){
                    this.builder = new InfoBuilder(this, item);
            }
            InfoNestedImpl(){
                    this.builder = new InfoBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withInfo(builder.build());
    }
    public N endInfo(){
            return and();
    }

}
    public class KeyValuePairNestedImpl<N> extends KeyValuePairFluentImpl<DockerSchemaFluent.KeyValuePairNested<N>> implements DockerSchemaFluent.KeyValuePairNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final KeyValuePairBuilder builder;
    
            KeyValuePairNestedImpl(KeyValuePair item){
                    this.builder = new KeyValuePairBuilder(this, item);
            }
            KeyValuePairNestedImpl(){
                    this.builder = new KeyValuePairBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withKeyValuePair(builder.build());
    }
    public N endKeyValuePair(){
            return and();
    }

}
    public class LogConfigNestedImpl<N> extends LogConfigFluentImpl<DockerSchemaFluent.LogConfigNested<N>> implements DockerSchemaFluent.LogConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final LogConfigBuilder builder;
    
            LogConfigNestedImpl(LogConfig item){
                    this.builder = new LogConfigBuilder(this, item);
            }
            LogConfigNestedImpl(){
                    this.builder = new LogConfigBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withLogConfig(builder.build());
    }
    public N endLogConfig(){
            return and();
    }

}
    public class MountPointNestedImpl<N> extends MountPointFluentImpl<DockerSchemaFluent.MountPointNested<N>> implements DockerSchemaFluent.MountPointNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final MountPointBuilder builder;
    
            MountPointNestedImpl(MountPoint item){
                    this.builder = new MountPointBuilder(this, item);
            }
            MountPointNestedImpl(){
                    this.builder = new MountPointBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withMountPoint(builder.build());
    }
    public N endMountPoint(){
            return and();
    }

}
    public class NetworkConnectNestedImpl<N> extends NetworkConnectFluentImpl<DockerSchemaFluent.NetworkConnectNested<N>> implements DockerSchemaFluent.NetworkConnectNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkConnectBuilder builder;
    
            NetworkConnectNestedImpl(NetworkConnect item){
                    this.builder = new NetworkConnectBuilder(this, item);
            }
            NetworkConnectNestedImpl(){
                    this.builder = new NetworkConnectBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withNetworkConnect(builder.build());
    }
    public N endNetworkConnect(){
            return and();
    }

}
    public class NetworkCreateNestedImpl<N> extends NetworkCreateFluentImpl<DockerSchemaFluent.NetworkCreateNested<N>> implements DockerSchemaFluent.NetworkCreateNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkCreateBuilder builder;
    
            NetworkCreateNestedImpl(NetworkCreate item){
                    this.builder = new NetworkCreateBuilder(this, item);
            }
            NetworkCreateNestedImpl(){
                    this.builder = new NetworkCreateBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withNetworkCreate(builder.build());
    }
    public N endNetworkCreate(){
            return and();
    }

}
    public class NetworkCreateResponseNestedImpl<N> extends NetworkCreateResponseFluentImpl<DockerSchemaFluent.NetworkCreateResponseNested<N>> implements DockerSchemaFluent.NetworkCreateResponseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkCreateResponseBuilder builder;
    
            NetworkCreateResponseNestedImpl(NetworkCreateResponse item){
                    this.builder = new NetworkCreateResponseBuilder(this, item);
            }
            NetworkCreateResponseNestedImpl(){
                    this.builder = new NetworkCreateResponseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withNetworkCreateResponse(builder.build());
    }
    public N endNetworkCreateResponse(){
            return and();
    }

}
    public class NetworkDisconnectNestedImpl<N> extends NetworkDisconnectFluentImpl<DockerSchemaFluent.NetworkDisconnectNested<N>> implements DockerSchemaFluent.NetworkDisconnectNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkDisconnectBuilder builder;
    
            NetworkDisconnectNestedImpl(NetworkDisconnect item){
                    this.builder = new NetworkDisconnectBuilder(this, item);
            }
            NetworkDisconnectNestedImpl(){
                    this.builder = new NetworkDisconnectBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withNetworkDisconnect(builder.build());
    }
    public N endNetworkDisconnect(){
            return and();
    }

}
    public class NetworkResourceNestedImpl<N> extends NetworkResourceFluentImpl<DockerSchemaFluent.NetworkResourceNested<N>> implements DockerSchemaFluent.NetworkResourceNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkResourceBuilder builder;
    
            NetworkResourceNestedImpl(NetworkResource item){
                    this.builder = new NetworkResourceBuilder(this, item);
            }
            NetworkResourceNestedImpl(){
                    this.builder = new NetworkResourceBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withNetworkResource(builder.build());
    }
    public N endNetworkResource(){
            return and();
    }

}
    public class NetworkSettingsNestedImpl<N> extends NetworkSettingsFluentImpl<DockerSchemaFluent.NetworkSettingsNested<N>> implements DockerSchemaFluent.NetworkSettingsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkSettingsBuilder builder;
    
            NetworkSettingsNestedImpl(NetworkSettings item){
                    this.builder = new NetworkSettingsBuilder(this, item);
            }
            NetworkSettingsNestedImpl(){
                    this.builder = new NetworkSettingsBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withNetworkSettings(builder.build());
    }
    public N endNetworkSettings(){
            return and();
    }

}
    public class NetworkSettingsBaseNestedImpl<N> extends NetworkSettingsBaseFluentImpl<DockerSchemaFluent.NetworkSettingsBaseNested<N>> implements DockerSchemaFluent.NetworkSettingsBaseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final NetworkSettingsBaseBuilder builder;
    
            NetworkSettingsBaseNestedImpl(NetworkSettingsBase item){
                    this.builder = new NetworkSettingsBaseBuilder(this, item);
            }
            NetworkSettingsBaseNestedImpl(){
                    this.builder = new NetworkSettingsBaseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withNetworkSettingsBase(builder.build());
    }
    public N endNetworkSettingsBase(){
            return and();
    }

}
    public class PortNestedImpl<N> extends PortFluentImpl<DockerSchemaFluent.PortNested<N>> implements DockerSchemaFluent.PortNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final PortBuilder builder;
    
            PortNestedImpl(Port item){
                    this.builder = new PortBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new PortBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class PortBindingNestedImpl<N> extends PortBindingFluentImpl<DockerSchemaFluent.PortBindingNested<N>> implements DockerSchemaFluent.PortBindingNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final PortBindingBuilder builder;
    
            PortBindingNestedImpl(PortBinding item){
                    this.builder = new PortBindingBuilder(this, item);
            }
            PortBindingNestedImpl(){
                    this.builder = new PortBindingBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withPortBinding(builder.build());
    }
    public N endPortBinding(){
            return and();
    }

}
    public class SearchResultNestedImpl<N> extends SearchResultFluentImpl<DockerSchemaFluent.SearchResultNested<N>> implements DockerSchemaFluent.SearchResultNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final SearchResultBuilder builder;
    
            SearchResultNestedImpl(SearchResult item){
                    this.builder = new SearchResultBuilder(this, item);
            }
            SearchResultNestedImpl(){
                    this.builder = new SearchResultBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withSearchResult(builder.build());
    }
    public N endSearchResult(){
            return and();
    }

}
    public class SearchResultsNestedImpl<N> extends SearchResultsFluentImpl<DockerSchemaFluent.SearchResultsNested<N>> implements DockerSchemaFluent.SearchResultsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final SearchResultsBuilder builder;
    
            SearchResultsNestedImpl(SearchResults item){
                    this.builder = new SearchResultsBuilder(this, item);
            }
            SearchResultsNestedImpl(){
                    this.builder = new SearchResultsBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withSearchResults(builder.build());
    }
    public N endSearchResults(){
            return and();
    }

}
    public class ServiceConfigNestedImpl<N> extends ServiceConfigFluentImpl<DockerSchemaFluent.ServiceConfigNested<N>> implements DockerSchemaFluent.ServiceConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final ServiceConfigBuilder builder;
    
            ServiceConfigNestedImpl(ServiceConfig item){
                    this.builder = new ServiceConfigBuilder(this, item);
            }
            ServiceConfigNestedImpl(){
                    this.builder = new ServiceConfigBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withServiceConfig(builder.build());
    }
    public N endServiceConfig(){
            return and();
    }

}
    public class StatsNestedImpl<N> extends StatsFluentImpl<DockerSchemaFluent.StatsNested<N>> implements DockerSchemaFluent.StatsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final StatsBuilder builder;
    
            StatsNestedImpl(Stats item){
                    this.builder = new StatsBuilder(this, item);
            }
            StatsNestedImpl(){
                    this.builder = new StatsBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withStats(builder.build());
    }
    public N endStats(){
            return and();
    }

}
    public class VersionNestedImpl<N> extends VersionFluentImpl<DockerSchemaFluent.VersionNested<N>> implements DockerSchemaFluent.VersionNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final VersionBuilder builder;
    
            VersionNestedImpl(io.fabric8.docker.api.model.Version item){
                    this.builder = new VersionBuilder(this, item);
            }
            VersionNestedImpl(){
                    this.builder = new VersionBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withVersion(builder.build());
    }
    public N endVersion(){
            return and();
    }

}
    public class VolumeNestedImpl<N> extends VolumeFluentImpl<DockerSchemaFluent.VolumeNested<N>> implements DockerSchemaFluent.VolumeNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final VolumeBuilder builder;
    
            VolumeNestedImpl(Volume item){
                    this.builder = new VolumeBuilder(this, item);
            }
            VolumeNestedImpl(){
                    this.builder = new VolumeBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withVolume(builder.build());
    }
    public N endVolume(){
            return and();
    }

}
    public class VolumeCreateRequestNestedImpl<N> extends VolumeCreateRequestFluentImpl<DockerSchemaFluent.VolumeCreateRequestNested<N>> implements DockerSchemaFluent.VolumeCreateRequestNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final VolumeCreateRequestBuilder builder;
    
            VolumeCreateRequestNestedImpl(VolumeCreateRequest item){
                    this.builder = new VolumeCreateRequestBuilder(this, item);
            }
            VolumeCreateRequestNestedImpl(){
                    this.builder = new VolumeCreateRequestBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withVolumeCreateRequest(builder.build());
    }
    public N endVolumeCreateRequest(){
            return and();
    }

}
    public class VolumesListResponseNestedImpl<N> extends VolumesListResponseFluentImpl<DockerSchemaFluent.VolumesListResponseNested<N>> implements DockerSchemaFluent.VolumesListResponseNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final VolumesListResponseBuilder builder;
    
            VolumesListResponseNestedImpl(VolumesListResponse item){
                    this.builder = new VolumesListResponseBuilder(this, item);
            }
            VolumesListResponseNestedImpl(){
                    this.builder = new VolumesListResponseBuilder(this);
            }
    
    public N and(){
            return (N) DockerSchemaFluentImpl.this.withVolumesListResponse(builder.build());
    }
    public N endVolumesListResponse(){
            return and();
    }

}


}
