package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EndpointResourceFluentImpl<A extends EndpointResourceFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements EndpointResourceFluent<A>{

    private String EndpointID;
    private String IPv4Address;
    private String IPv6Address;
    private String MacAddress;

    public EndpointResourceFluentImpl(){
    }
    public EndpointResourceFluentImpl(EndpointResource instance){
            this.withEndpointID(instance.getEndpointID()); 
            this.withIPv4Address(instance.getIPv4Address()); 
            this.withIPv6Address(instance.getIPv6Address()); 
            this.withMacAddress(instance.getMacAddress()); 
    }

    public String getEndpointID(){
            return this.EndpointID;
    }

    public A withEndpointID(String EndpointID){
            this.EndpointID=EndpointID; return (A) this;
    }

    public Boolean hasEndpointID(){
            return this.EndpointID!=null;
    }

    public String getIPv4Address(){
            return this.IPv4Address;
    }

    public A withIPv4Address(String IPv4Address){
            this.IPv4Address=IPv4Address; return (A) this;
    }

    public Boolean hasIPv4Address(){
            return this.IPv4Address!=null;
    }

    public String getIPv6Address(){
            return this.IPv6Address;
    }

    public A withIPv6Address(String IPv6Address){
            this.IPv6Address=IPv6Address; return (A) this;
    }

    public Boolean hasIPv6Address(){
            return this.IPv6Address!=null;
    }

    public String getMacAddress(){
            return this.MacAddress;
    }

    public A withMacAddress(String MacAddress){
            this.MacAddress=MacAddress; return (A) this;
    }

    public Boolean hasMacAddress(){
            return this.MacAddress!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointResourceFluentImpl that = (EndpointResourceFluentImpl) o;
            if (EndpointID != null ? !EndpointID.equals(that.EndpointID) :that.EndpointID != null) return false;
            if (IPv4Address != null ? !IPv4Address.equals(that.IPv4Address) :that.IPv4Address != null) return false;
            if (IPv6Address != null ? !IPv6Address.equals(that.IPv6Address) :that.IPv6Address != null) return false;
            if (MacAddress != null ? !MacAddress.equals(that.MacAddress) :that.MacAddress != null) return false;
            return true;
    }




}
