package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface GraphDriverDataFluent<A extends GraphDriverDataFluent<A>> extends Fluent<A>{


    public A addToData(String key,String value);
    public A addToData(Map<String,String> map);
    public A removeFromData(String key);
    public A removeFromData(Map<String,String> map);
    public Map<String,String> getData();
    public A withData(Map<String,String> Data);
    public Boolean hasData();
    public String getName();
    public A withName(String Name);
    public Boolean hasName();



}
