package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface HostConfigFluent<A extends HostConfigFluent<A>> extends Fluent<A>{


    public A addToBinds(int index,String item);
    public A setToBinds(int index,String item);
    public A addToBinds(String... items);
    public A addAllToBinds(Collection<String> items);
    public A removeFromBinds(String... items);
    public A removeAllFromBinds(Collection<String> items);
    public List<String> getBinds();
    public String getBind(int index);
    public String getFirstBind();
    public String getLastBind();
    public String getMatchingBind(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withBinds(List<String> Binds);
    public A withBinds(String... Binds);
    public Boolean hasBinds();
    public Integer getBlkioWeight();
    public A withBlkioWeight(Integer BlkioWeight);
    public Boolean hasBlkioWeight();
    public A addToCapAdd(int index,String item);
    public A setToCapAdd(int index,String item);
    public A addToCapAdd(String... items);
    public A addAllToCapAdd(Collection<String> items);
    public A removeFromCapAdd(String... items);
    public A removeAllFromCapAdd(Collection<String> items);
    public List<String> getCapAdd();
    public String getCapAdd(int index);
    public String getFirstCapAdd();
    public String getLastCapAdd();
    public String getMatchingCapAdd(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withCapAdd(List<String> CapAdd);
    public A withCapAdd(String... CapAdd);
    public Boolean hasCapAdd();
    public A addToCapDrop(int index,String item);
    public A setToCapDrop(int index,String item);
    public A addToCapDrop(String... items);
    public A addAllToCapDrop(Collection<String> items);
    public A removeFromCapDrop(String... items);
    public A removeAllFromCapDrop(Collection<String> items);
    public List<String> getCapDrop();
    public String getCapDrop(int index);
    public String getFirstCapDrop();
    public String getLastCapDrop();
    public String getMatchingCapDrop(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withCapDrop(List<String> CapDrop);
    public A withCapDrop(String... CapDrop);
    public Boolean hasCapDrop();
    public String getCgroupParent();
    public A withCgroupParent(String CgroupParent);
    public Boolean hasCgroupParent();
    public Object getConsoleSize();
    public A withConsoleSize(Object ConsoleSize);
    public Boolean hasConsoleSize();
    public String getContainerIDFile();
    public A withContainerIDFile(String ContainerIDFile);
    public Boolean hasContainerIDFile();
    public Long getCpuPeriod();
    public A withCpuPeriod(Long CpuPeriod);
    public Boolean hasCpuPeriod();
    public Long getCpuQuota();
    public A withCpuQuota(Long CpuQuota);
    public Boolean hasCpuQuota();
    public Long getCpuShares();
    public A withCpuShares(Long CpuShares);
    public Boolean hasCpuShares();
    public String getCpusetCpus();
    public A withCpusetCpus(String CpusetCpus);
    public Boolean hasCpusetCpus();
    public String getCpusetMems();
    public A withCpusetMems(String CpusetMems);
    public Boolean hasCpusetMems();
    public A addToDevices(int index,DeviceMapping item);
    public A setToDevices(int index,DeviceMapping item);
    public A addToDevices(DeviceMapping... items);
    public A addAllToDevices(Collection<DeviceMapping> items);
    public A removeFromDevices(DeviceMapping... items);
    public A removeAllFromDevices(Collection<DeviceMapping> items);
    
/**
 * This method has been deprecated, please use method buildDevices instead.
 */
@Deprecated public List<DeviceMapping> getDevices();
    public List<DeviceMapping> buildDevices();
    public DeviceMapping buildDevice(int index);
    public DeviceMapping buildFirstDevice();
    public DeviceMapping buildLastDevice();
    public DeviceMapping buildMatchingDevice(io.fabric8.docker.api.builder.Predicate<DeviceMappingBuilder> predicate);
    public A withDevices(List<DeviceMapping> Devices);
    public A withDevices(DeviceMapping... Devices);
    public Boolean hasDevices();
    public HostConfigFluent.DevicesNested<A> addNewDevice();
    public HostConfigFluent.DevicesNested<A> addNewDeviceLike(DeviceMapping item);
    public HostConfigFluent.DevicesNested<A> setNewDeviceLike(int index,DeviceMapping item);
    public HostConfigFluent.DevicesNested<A> editDevice(int index);
    public HostConfigFluent.DevicesNested<A> editFirstDevice();
    public HostConfigFluent.DevicesNested<A> editLastDevice();
    public HostConfigFluent.DevicesNested<A> editMatchingDevice(io.fabric8.docker.api.builder.Predicate<DeviceMappingBuilder> predicate);
    public A addNewDevice(String CgroupPermissions,String PathInContainer,String PathOnHost);
    public A addToDns(int index,String item);
    public A setToDns(int index,String item);
    public A addToDns(String... items);
    public A addAllToDns(Collection<String> items);
    public A removeFromDns(String... items);
    public A removeAllFromDns(Collection<String> items);
    public List<String> getDns();
    public String getDn(int index);
    public String getFirstDn();
    public String getLastDn();
    public String getMatchingDn(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withDns(List<String> Dns);
    public A withDns(String... Dns);
    public Boolean hasDns();
    public A addToDnsOptions(int index,String item);
    public A setToDnsOptions(int index,String item);
    public A addToDnsOptions(String... items);
    public A addAllToDnsOptions(Collection<String> items);
    public A removeFromDnsOptions(String... items);
    public A removeAllFromDnsOptions(Collection<String> items);
    public List<String> getDnsOptions();
    public String getDnsOption(int index);
    public String getFirstDnsOption();
    public String getLastDnsOption();
    public String getMatchingDnsOption(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withDnsOptions(List<String> DnsOptions);
    public A withDnsOptions(String... DnsOptions);
    public Boolean hasDnsOptions();
    public A addToDnsSearch(int index,String item);
    public A setToDnsSearch(int index,String item);
    public A addToDnsSearch(String... items);
    public A addAllToDnsSearch(Collection<String> items);
    public A removeFromDnsSearch(String... items);
    public A removeAllFromDnsSearch(Collection<String> items);
    public List<String> getDnsSearch();
    public String getDnsSearch(int index);
    public String getFirstDnsSearch();
    public String getLastDnsSearch();
    public String getMatchingDnsSearch(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withDnsSearch(List<String> DnsSearch);
    public A withDnsSearch(String... DnsSearch);
    public Boolean hasDnsSearch();
    public A addToExtraHosts(int index,String item);
    public A setToExtraHosts(int index,String item);
    public A addToExtraHosts(String... items);
    public A addAllToExtraHosts(Collection<String> items);
    public A removeFromExtraHosts(String... items);
    public A removeAllFromExtraHosts(Collection<String> items);
    public List<String> getExtraHosts();
    public String getExtraHost(int index);
    public String getFirstExtraHost();
    public String getLastExtraHost();
    public String getMatchingExtraHost(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withExtraHosts(List<String> ExtraHosts);
    public A withExtraHosts(String... ExtraHosts);
    public Boolean hasExtraHosts();
    public A addToGroupAdd(int index,String item);
    public A setToGroupAdd(int index,String item);
    public A addToGroupAdd(String... items);
    public A addAllToGroupAdd(Collection<String> items);
    public A removeFromGroupAdd(String... items);
    public A removeAllFromGroupAdd(Collection<String> items);
    public List<String> getGroupAdd();
    public String getGroupAdd(int index);
    public String getFirstGroupAdd();
    public String getLastGroupAdd();
    public String getMatchingGroupAdd(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withGroupAdd(List<String> GroupAdd);
    public A withGroupAdd(String... GroupAdd);
    public Boolean hasGroupAdd();
    public String getIpcMode();
    public A withIpcMode(String IpcMode);
    public Boolean hasIpcMode();
    public Long getKernelMemory();
    public A withKernelMemory(Long KernelMemory);
    public Boolean hasKernelMemory();
    public A addToLinks(int index,String item);
    public A setToLinks(int index,String item);
    public A addToLinks(String... items);
    public A addAllToLinks(Collection<String> items);
    public A removeFromLinks(String... items);
    public A removeAllFromLinks(Collection<String> items);
    public List<String> getLinks();
    public String getLink(int index);
    public String getFirstLink();
    public String getLastLink();
    public String getMatchingLink(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withLinks(List<String> Links);
    public A withLinks(String... Links);
    public Boolean hasLinks();
    
/**
 * This method has been deprecated, please use method buildLogConfig instead.
 */
@Deprecated public LogConfig getLogConfig();
    public LogConfig buildLogConfig();
    public A withLogConfig(LogConfig LogConfig);
    public Boolean hasLogConfig();
    public HostConfigFluent.LogConfigNested<A> withNewLogConfig();
    public HostConfigFluent.LogConfigNested<A> withNewLogConfigLike(LogConfig item);
    public HostConfigFluent.LogConfigNested<A> editLogConfig();
    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfig();
    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfigLike(LogConfig item);
    public LxcConfig getLxcConf();
    public A withLxcConf(LxcConfig LxcConf);
    public Boolean hasLxcConf();
    public Long getMemory();
    public A withMemory(Long Memory);
    public Boolean hasMemory();
    public Long getMemoryReservation();
    public A withMemoryReservation(Long MemoryReservation);
    public Boolean hasMemoryReservation();
    public Long getMemorySwap();
    public A withMemorySwap(Long MemorySwap);
    public Boolean hasMemorySwap();
    public Long getMemorySwappiness();
    public A withMemorySwappiness(Long MemorySwappiness);
    public Boolean hasMemorySwappiness();
    public String getNetworkMode();
    public A withNetworkMode(String NetworkMode);
    public Boolean hasNetworkMode();
    public Boolean isOomKillDisable();
    public A withOomKillDisable(Boolean OomKillDisable);
    public Boolean hasOomKillDisable();
    public String getPidMode();
    public A withPidMode(String PidMode);
    public Boolean hasPidMode();
    public A addToPortBindings(String key,ArrayList<PortBinding> value);
    public A addToPortBindings(Map<String,ArrayList<PortBinding>> map);
    public A removeFromPortBindings(String key);
    public A removeFromPortBindings(Map<String,ArrayList<PortBinding>> map);
    public Map<String,ArrayList<PortBinding>> getPortBindings();
    public A withPortBindings(Map<String,ArrayList<PortBinding>> PortBindings);
    public Boolean hasPortBindings();
    public Boolean isPrivileged();
    public A withPrivileged(Boolean Privileged);
    public Boolean hasPrivileged();
    public Boolean isPublishAllPorts();
    public A withPublishAllPorts(Boolean PublishAllPorts);
    public Boolean hasPublishAllPorts();
    public Boolean isReadonlyRootfs();
    public A withReadonlyRootfs(Boolean ReadonlyRootfs);
    public Boolean hasReadonlyRootfs();
    
/**
 * This method has been deprecated, please use method buildRestartPolicy instead.
 */
@Deprecated public RestartPolicy getRestartPolicy();
    public RestartPolicy buildRestartPolicy();
    public A withRestartPolicy(RestartPolicy RestartPolicy);
    public Boolean hasRestartPolicy();
    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicy();
    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicyLike(RestartPolicy item);
    public HostConfigFluent.RestartPolicyNested<A> editRestartPolicy();
    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicy();
    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicyLike(RestartPolicy item);
    public A withNewRestartPolicy(Integer MaximumRetryCount,String Name);
    public A addToSecurityOpt(int index,String item);
    public A setToSecurityOpt(int index,String item);
    public A addToSecurityOpt(String... items);
    public A addAllToSecurityOpt(Collection<String> items);
    public A removeFromSecurityOpt(String... items);
    public A removeAllFromSecurityOpt(Collection<String> items);
    public List<String> getSecurityOpt();
    public String getSecurityOpt(int index);
    public String getFirstSecurityOpt();
    public String getLastSecurityOpt();
    public String getMatchingSecurityOpt(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withSecurityOpt(List<String> SecurityOpt);
    public A withSecurityOpt(String... SecurityOpt);
    public Boolean hasSecurityOpt();
    public String getUTSMode();
    public A withUTSMode(String UTSMode);
    public Boolean hasUTSMode();
    public A addToUlimits(int index,Ulimit item);
    public A setToUlimits(int index,Ulimit item);
    public A addToUlimits(Ulimit... items);
    public A addAllToUlimits(Collection<Ulimit> items);
    public A removeFromUlimits(Ulimit... items);
    public A removeAllFromUlimits(Collection<Ulimit> items);
    
/**
 * This method has been deprecated, please use method buildUlimits instead.
 */
@Deprecated public List<Ulimit> getUlimits();
    public List<Ulimit> buildUlimits();
    public Ulimit buildUlimit(int index);
    public Ulimit buildFirstUlimit();
    public Ulimit buildLastUlimit();
    public Ulimit buildMatchingUlimit(io.fabric8.docker.api.builder.Predicate<UlimitBuilder> predicate);
    public A withUlimits(List<Ulimit> Ulimits);
    public A withUlimits(Ulimit... Ulimits);
    public Boolean hasUlimits();
    public HostConfigFluent.UlimitsNested<A> addNewUlimit();
    public HostConfigFluent.UlimitsNested<A> addNewUlimitLike(Ulimit item);
    public HostConfigFluent.UlimitsNested<A> setNewUlimitLike(int index,Ulimit item);
    public HostConfigFluent.UlimitsNested<A> editUlimit(int index);
    public HostConfigFluent.UlimitsNested<A> editFirstUlimit();
    public HostConfigFluent.UlimitsNested<A> editLastUlimit();
    public HostConfigFluent.UlimitsNested<A> editMatchingUlimit(io.fabric8.docker.api.builder.Predicate<UlimitBuilder> predicate);
    public A addNewUlimit(Long Hard,String Name,Long Soft);
    public String getVolumeDriver();
    public A withVolumeDriver(String VolumeDriver);
    public Boolean hasVolumeDriver();
    public A addToVolumesFrom(int index,String item);
    public A setToVolumesFrom(int index,String item);
    public A addToVolumesFrom(String... items);
    public A addAllToVolumesFrom(Collection<String> items);
    public A removeFromVolumesFrom(String... items);
    public A removeAllFromVolumesFrom(Collection<String> items);
    public List<String> getVolumesFrom();
    public String getVolumesFrom(int index);
    public String getFirstVolumesFrom();
    public String getLastVolumesFrom();
    public String getMatchingVolumesFrom(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withVolumesFrom(List<String> VolumesFrom);
    public A withVolumesFrom(String... VolumesFrom);
    public Boolean hasVolumesFrom();

    public interface DevicesNested<N> extends io.fabric8.docker.api.builder.Nested<N>,DeviceMappingFluent<HostConfigFluent.DevicesNested<N>>{

        
    public N and();    public N endDevice();
}
    public interface LogConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,LogConfigFluent<HostConfigFluent.LogConfigNested<N>>{

        
    public N and();    public N endLogConfig();
}
    public interface RestartPolicyNested<N> extends io.fabric8.docker.api.builder.Nested<N>,RestartPolicyFluent<HostConfigFluent.RestartPolicyNested<N>>{

        
    public N and();    public N endRestartPolicy();
}
    public interface UlimitsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,UlimitFluent<HostConfigFluent.UlimitsNested<N>>{

        
    public N and();    public N endUlimit();
}


}
