package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class HostConfigFluentImpl<A extends HostConfigFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements HostConfigFluent<A>{

    private List<String> Binds = new ArrayList<String>();
    private Integer BlkioWeight;
    private List<String> CapAdd = new ArrayList<String>();
    private List<String> CapDrop = new ArrayList<String>();
    private String CgroupParent;
    private Object ConsoleSize;
    private String ContainerIDFile;
    private Long CpuPeriod;
    private Long CpuQuota;
    private Long CpuShares;
    private String CpusetCpus;
    private String CpusetMems;
    private List<DeviceMappingBuilder> Devices =  new ArrayList<DeviceMappingBuilder>();
    private List<String> Dns = new ArrayList<String>();
    private List<String> DnsOptions = new ArrayList<String>();
    private List<String> DnsSearch = new ArrayList<String>();
    private List<String> ExtraHosts = new ArrayList<String>();
    private List<String> GroupAdd = new ArrayList<String>();
    private String IpcMode;
    private Long KernelMemory;
    private List<String> Links = new ArrayList<String>();
    private LogConfigBuilder LogConfig;
    private LxcConfig LxcConf;
    private Long Memory;
    private Long MemoryReservation;
    private Long MemorySwap;
    private Long MemorySwappiness;
    private String NetworkMode;
    private Boolean OomKillDisable;
    private String PidMode;
    private Map<String,ArrayList<PortBinding>> PortBindings = new LinkedHashMap<String,ArrayList<PortBinding>>();
    private Boolean Privileged;
    private Boolean PublishAllPorts;
    private Boolean ReadonlyRootfs;
    private RestartPolicyBuilder RestartPolicy;
    private List<String> SecurityOpt = new ArrayList<String>();
    private String UTSMode;
    private List<UlimitBuilder> Ulimits =  new ArrayList<UlimitBuilder>();
    private String VolumeDriver;
    private List<String> VolumesFrom = new ArrayList<String>();

    public HostConfigFluentImpl(){
    }
    public HostConfigFluentImpl(HostConfig instance){
            this.withBinds(instance.getBinds()); 
            this.withBlkioWeight(instance.getBlkioWeight()); 
            this.withCapAdd(instance.getCapAdd()); 
            this.withCapDrop(instance.getCapDrop()); 
            this.withCgroupParent(instance.getCgroupParent()); 
            this.withConsoleSize(instance.getConsoleSize()); 
            this.withContainerIDFile(instance.getContainerIDFile()); 
            this.withCpuPeriod(instance.getCpuPeriod()); 
            this.withCpuQuota(instance.getCpuQuota()); 
            this.withCpuShares(instance.getCpuShares()); 
            this.withCpusetCpus(instance.getCpusetCpus()); 
            this.withCpusetMems(instance.getCpusetMems()); 
            this.withDevices(instance.getDevices()); 
            this.withDns(instance.getDns()); 
            this.withDnsOptions(instance.getDnsOptions()); 
            this.withDnsSearch(instance.getDnsSearch()); 
            this.withExtraHosts(instance.getExtraHosts()); 
            this.withGroupAdd(instance.getGroupAdd()); 
            this.withIpcMode(instance.getIpcMode()); 
            this.withKernelMemory(instance.getKernelMemory()); 
            this.withLinks(instance.getLinks()); 
            this.withLogConfig(instance.getLogConfig()); 
            this.withLxcConf(instance.getLxcConf()); 
            this.withMemory(instance.getMemory()); 
            this.withMemoryReservation(instance.getMemoryReservation()); 
            this.withMemorySwap(instance.getMemorySwap()); 
            this.withMemorySwappiness(instance.getMemorySwappiness()); 
            this.withNetworkMode(instance.getNetworkMode()); 
            this.withOomKillDisable(instance.getOomKillDisable()); 
            this.withPidMode(instance.getPidMode()); 
            this.withPortBindings(instance.getPortBindings()); 
            this.withPrivileged(instance.getPrivileged()); 
            this.withPublishAllPorts(instance.getPublishAllPorts()); 
            this.withReadonlyRootfs(instance.getReadonlyRootfs()); 
            this.withRestartPolicy(instance.getRestartPolicy()); 
            this.withSecurityOpt(instance.getSecurityOpt()); 
            this.withUTSMode(instance.getUTSMode()); 
            this.withUlimits(instance.getUlimits()); 
            this.withVolumeDriver(instance.getVolumeDriver()); 
            this.withVolumesFrom(instance.getVolumesFrom()); 
    }

    public A addToBinds(int index,String item){
            this.Binds.add(index, item); return (A)this;
    }

    public A setToBinds(int index,String item){
            this.Binds.set(index, item); return (A)this;
    }

    public A addToBinds(String... items){
            for (String item : items) {this.Binds.add(item);} return (A)this;
    }

    public A addAllToBinds(Collection<String> items){
            for (String item : items) {this.Binds.add(item);} return (A)this;
    }

    public A removeFromBinds(String... items){
            for (String item : items) {this.Binds.remove(item);} return (A)this;
    }

    public A removeAllFromBinds(Collection<String> items){
            for (String item : items) {this.Binds.remove(item);} return (A)this;
    }

    public List<String> getBinds(){
            return this.Binds;
    }

    public String getBind(int index){
            return this.Binds.get(index);
    }

    public String getFirstBind(){
            return this.Binds.get(0);
    }

    public String getLastBind(){
            return this.Binds.get(Binds.size() - 1);
    }

    public String getMatchingBind(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Binds) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withBinds(List<String> Binds){
            this.Binds.clear();
            if (Binds != null) {for (String item : Binds){this.addToBinds(item);}} return (A) this;
    }

    public A withBinds(String... Binds){
            this.Binds.clear(); if (Binds != null) {for (String item :Binds){ this.addToBinds(item);}} return (A) this;
    }

    public Boolean hasBinds(){
            return Binds!= null && !Binds.isEmpty();
    }

    public Integer getBlkioWeight(){
            return this.BlkioWeight;
    }

    public A withBlkioWeight(Integer BlkioWeight){
            this.BlkioWeight=BlkioWeight; return (A) this;
    }

    public Boolean hasBlkioWeight(){
            return this.BlkioWeight!=null;
    }

    public A addToCapAdd(int index,String item){
            this.CapAdd.add(index, item); return (A)this;
    }

    public A setToCapAdd(int index,String item){
            this.CapAdd.set(index, item); return (A)this;
    }

    public A addToCapAdd(String... items){
            for (String item : items) {this.CapAdd.add(item);} return (A)this;
    }

    public A addAllToCapAdd(Collection<String> items){
            for (String item : items) {this.CapAdd.add(item);} return (A)this;
    }

    public A removeFromCapAdd(String... items){
            for (String item : items) {this.CapAdd.remove(item);} return (A)this;
    }

    public A removeAllFromCapAdd(Collection<String> items){
            for (String item : items) {this.CapAdd.remove(item);} return (A)this;
    }

    public List<String> getCapAdd(){
            return this.CapAdd;
    }

    public String getCapAdd(int index){
            return this.CapAdd.get(index);
    }

    public String getFirstCapAdd(){
            return this.CapAdd.get(0);
    }

    public String getLastCapAdd(){
            return this.CapAdd.get(CapAdd.size() - 1);
    }

    public String getMatchingCapAdd(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: CapAdd) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withCapAdd(List<String> CapAdd){
            this.CapAdd.clear();
            if (CapAdd != null) {for (String item : CapAdd){this.addToCapAdd(item);}} return (A) this;
    }

    public A withCapAdd(String... CapAdd){
            this.CapAdd.clear(); if (CapAdd != null) {for (String item :CapAdd){ this.addToCapAdd(item);}} return (A) this;
    }

    public Boolean hasCapAdd(){
            return CapAdd!= null && !CapAdd.isEmpty();
    }

    public A addToCapDrop(int index,String item){
            this.CapDrop.add(index, item); return (A)this;
    }

    public A setToCapDrop(int index,String item){
            this.CapDrop.set(index, item); return (A)this;
    }

    public A addToCapDrop(String... items){
            for (String item : items) {this.CapDrop.add(item);} return (A)this;
    }

    public A addAllToCapDrop(Collection<String> items){
            for (String item : items) {this.CapDrop.add(item);} return (A)this;
    }

    public A removeFromCapDrop(String... items){
            for (String item : items) {this.CapDrop.remove(item);} return (A)this;
    }

    public A removeAllFromCapDrop(Collection<String> items){
            for (String item : items) {this.CapDrop.remove(item);} return (A)this;
    }

    public List<String> getCapDrop(){
            return this.CapDrop;
    }

    public String getCapDrop(int index){
            return this.CapDrop.get(index);
    }

    public String getFirstCapDrop(){
            return this.CapDrop.get(0);
    }

    public String getLastCapDrop(){
            return this.CapDrop.get(CapDrop.size() - 1);
    }

    public String getMatchingCapDrop(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: CapDrop) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withCapDrop(List<String> CapDrop){
            this.CapDrop.clear();
            if (CapDrop != null) {for (String item : CapDrop){this.addToCapDrop(item);}} return (A) this;
    }

    public A withCapDrop(String... CapDrop){
            this.CapDrop.clear(); if (CapDrop != null) {for (String item :CapDrop){ this.addToCapDrop(item);}} return (A) this;
    }

    public Boolean hasCapDrop(){
            return CapDrop!= null && !CapDrop.isEmpty();
    }

    public String getCgroupParent(){
            return this.CgroupParent;
    }

    public A withCgroupParent(String CgroupParent){
            this.CgroupParent=CgroupParent; return (A) this;
    }

    public Boolean hasCgroupParent(){
            return this.CgroupParent!=null;
    }

    public Object getConsoleSize(){
            return this.ConsoleSize;
    }

    public A withConsoleSize(Object ConsoleSize){
            this.ConsoleSize=ConsoleSize; return (A) this;
    }

    public Boolean hasConsoleSize(){
            return this.ConsoleSize!=null;
    }

    public String getContainerIDFile(){
            return this.ContainerIDFile;
    }

    public A withContainerIDFile(String ContainerIDFile){
            this.ContainerIDFile=ContainerIDFile; return (A) this;
    }

    public Boolean hasContainerIDFile(){
            return this.ContainerIDFile!=null;
    }

    public Long getCpuPeriod(){
            return this.CpuPeriod;
    }

    public A withCpuPeriod(Long CpuPeriod){
            this.CpuPeriod=CpuPeriod; return (A) this;
    }

    public Boolean hasCpuPeriod(){
            return this.CpuPeriod!=null;
    }

    public Long getCpuQuota(){
            return this.CpuQuota;
    }

    public A withCpuQuota(Long CpuQuota){
            this.CpuQuota=CpuQuota; return (A) this;
    }

    public Boolean hasCpuQuota(){
            return this.CpuQuota!=null;
    }

    public Long getCpuShares(){
            return this.CpuShares;
    }

    public A withCpuShares(Long CpuShares){
            this.CpuShares=CpuShares; return (A) this;
    }

    public Boolean hasCpuShares(){
            return this.CpuShares!=null;
    }

    public String getCpusetCpus(){
            return this.CpusetCpus;
    }

    public A withCpusetCpus(String CpusetCpus){
            this.CpusetCpus=CpusetCpus; return (A) this;
    }

    public Boolean hasCpusetCpus(){
            return this.CpusetCpus!=null;
    }

    public String getCpusetMems(){
            return this.CpusetMems;
    }

    public A withCpusetMems(String CpusetMems){
            this.CpusetMems=CpusetMems; return (A) this;
    }

    public Boolean hasCpusetMems(){
            return this.CpusetMems!=null;
    }

    public A addToDevices(int index,DeviceMapping item){
            DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.Devices.add(index >= 0 ? index : Devices.size(), builder); return (A)this;
    }

    public A setToDevices(int index,DeviceMapping item){
            DeviceMappingBuilder builder = new DeviceMappingBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= Devices.size()) { Devices.add(builder); } else { Devices.set(index, builder);}
             return (A)this;
    }

    public A addToDevices(DeviceMapping... items){
            for (DeviceMapping item : items) {DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.add(builder);this.Devices.add(builder);} return (A)this;
    }

    public A addAllToDevices(Collection<DeviceMapping> items){
            for (DeviceMapping item : items) {DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.add(builder);this.Devices.add(builder);} return (A)this;
    }

    public A removeFromDevices(DeviceMapping... items){
            for (DeviceMapping item : items) {DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.remove(builder);this.Devices.remove(builder);} return (A)this;
    }

    public A removeAllFromDevices(Collection<DeviceMapping> items){
            for (DeviceMapping item : items) {DeviceMappingBuilder builder = new DeviceMappingBuilder(item);_visitables.remove(builder);this.Devices.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDevices instead.
 */
@Deprecated public List<DeviceMapping> getDevices(){
            return build(Devices);
    }

    public List<DeviceMapping> buildDevices(){
            return build(Devices);
    }

    public DeviceMapping buildDevice(int index){
            return this.Devices.get(index).build();
    }

    public DeviceMapping buildFirstDevice(){
            return this.Devices.get(0).build();
    }

    public DeviceMapping buildLastDevice(){
            return this.Devices.get(Devices.size() - 1).build();
    }

    public DeviceMapping buildMatchingDevice(io.fabric8.docker.api.builder.Predicate<DeviceMappingBuilder> predicate){
            for (DeviceMappingBuilder item: Devices) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withDevices(List<DeviceMapping> Devices){
            _visitables.removeAll(this.Devices);
            this.Devices.clear();
            if (Devices != null) {for (DeviceMapping item : Devices){this.addToDevices(item);}} return (A) this;
    }

    public A withDevices(DeviceMapping... Devices){
            this.Devices.clear(); if (Devices != null) {for (DeviceMapping item :Devices){ this.addToDevices(item);}} return (A) this;
    }

    public Boolean hasDevices(){
            return Devices!= null && !Devices.isEmpty();
    }

    public HostConfigFluent.DevicesNested<A> addNewDevice(){
            return new DevicesNestedImpl();
    }

    public HostConfigFluent.DevicesNested<A> addNewDeviceLike(DeviceMapping item){
            return new DevicesNestedImpl(-1, item);
    }

    public HostConfigFluent.DevicesNested<A> setNewDeviceLike(int index,DeviceMapping item){
            return new DevicesNestedImpl(index, item);
    }

    public HostConfigFluent.DevicesNested<A> editDevice(int index){
            if (Devices.size() <= index) throw new RuntimeException("Can't edit Devices. Index exceeds size.");
            return setNewDeviceLike(index, buildDevice(index));
    }

    public HostConfigFluent.DevicesNested<A> editFirstDevice(){
            if (Devices.size() == 0) throw new RuntimeException("Can't edit first Devices. The list is empty.");
            return setNewDeviceLike(0, buildDevice(0));
    }

    public HostConfigFluent.DevicesNested<A> editLastDevice(){
            int index = Devices.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last Devices. The list is empty.");
            return setNewDeviceLike(index, buildDevice(index));
    }

    public HostConfigFluent.DevicesNested<A> editMatchingDevice(io.fabric8.docker.api.builder.Predicate<DeviceMappingBuilder> predicate){
            int index = -1;
            for (int i=0;i<Devices.size();i++) { 
            if (predicate.apply(Devices.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching Devices. No match found.");
            return setNewDeviceLike(index, buildDevice(index));
    }

    public A addNewDevice(String CgroupPermissions,String PathInContainer,String PathOnHost){
            return (A)addToDevices(new DeviceMapping(CgroupPermissions, PathInContainer, PathOnHost));
    }

    public A addToDns(int index,String item){
            this.Dns.add(index, item); return (A)this;
    }

    public A setToDns(int index,String item){
            this.Dns.set(index, item); return (A)this;
    }

    public A addToDns(String... items){
            for (String item : items) {this.Dns.add(item);} return (A)this;
    }

    public A addAllToDns(Collection<String> items){
            for (String item : items) {this.Dns.add(item);} return (A)this;
    }

    public A removeFromDns(String... items){
            for (String item : items) {this.Dns.remove(item);} return (A)this;
    }

    public A removeAllFromDns(Collection<String> items){
            for (String item : items) {this.Dns.remove(item);} return (A)this;
    }

    public List<String> getDns(){
            return this.Dns;
    }

    public String getDn(int index){
            return this.Dns.get(index);
    }

    public String getFirstDn(){
            return this.Dns.get(0);
    }

    public String getLastDn(){
            return this.Dns.get(Dns.size() - 1);
    }

    public String getMatchingDn(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Dns) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withDns(List<String> Dns){
            this.Dns.clear();
            if (Dns != null) {for (String item : Dns){this.addToDns(item);}} return (A) this;
    }

    public A withDns(String... Dns){
            this.Dns.clear(); if (Dns != null) {for (String item :Dns){ this.addToDns(item);}} return (A) this;
    }

    public Boolean hasDns(){
            return Dns!= null && !Dns.isEmpty();
    }

    public A addToDnsOptions(int index,String item){
            this.DnsOptions.add(index, item); return (A)this;
    }

    public A setToDnsOptions(int index,String item){
            this.DnsOptions.set(index, item); return (A)this;
    }

    public A addToDnsOptions(String... items){
            for (String item : items) {this.DnsOptions.add(item);} return (A)this;
    }

    public A addAllToDnsOptions(Collection<String> items){
            for (String item : items) {this.DnsOptions.add(item);} return (A)this;
    }

    public A removeFromDnsOptions(String... items){
            for (String item : items) {this.DnsOptions.remove(item);} return (A)this;
    }

    public A removeAllFromDnsOptions(Collection<String> items){
            for (String item : items) {this.DnsOptions.remove(item);} return (A)this;
    }

    public List<String> getDnsOptions(){
            return this.DnsOptions;
    }

    public String getDnsOption(int index){
            return this.DnsOptions.get(index);
    }

    public String getFirstDnsOption(){
            return this.DnsOptions.get(0);
    }

    public String getLastDnsOption(){
            return this.DnsOptions.get(DnsOptions.size() - 1);
    }

    public String getMatchingDnsOption(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: DnsOptions) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withDnsOptions(List<String> DnsOptions){
            this.DnsOptions.clear();
            if (DnsOptions != null) {for (String item : DnsOptions){this.addToDnsOptions(item);}} return (A) this;
    }

    public A withDnsOptions(String... DnsOptions){
            this.DnsOptions.clear(); if (DnsOptions != null) {for (String item :DnsOptions){ this.addToDnsOptions(item);}} return (A) this;
    }

    public Boolean hasDnsOptions(){
            return DnsOptions!= null && !DnsOptions.isEmpty();
    }

    public A addToDnsSearch(int index,String item){
            this.DnsSearch.add(index, item); return (A)this;
    }

    public A setToDnsSearch(int index,String item){
            this.DnsSearch.set(index, item); return (A)this;
    }

    public A addToDnsSearch(String... items){
            for (String item : items) {this.DnsSearch.add(item);} return (A)this;
    }

    public A addAllToDnsSearch(Collection<String> items){
            for (String item : items) {this.DnsSearch.add(item);} return (A)this;
    }

    public A removeFromDnsSearch(String... items){
            for (String item : items) {this.DnsSearch.remove(item);} return (A)this;
    }

    public A removeAllFromDnsSearch(Collection<String> items){
            for (String item : items) {this.DnsSearch.remove(item);} return (A)this;
    }

    public List<String> getDnsSearch(){
            return this.DnsSearch;
    }

    public String getDnsSearch(int index){
            return this.DnsSearch.get(index);
    }

    public String getFirstDnsSearch(){
            return this.DnsSearch.get(0);
    }

    public String getLastDnsSearch(){
            return this.DnsSearch.get(DnsSearch.size() - 1);
    }

    public String getMatchingDnsSearch(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: DnsSearch) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withDnsSearch(List<String> DnsSearch){
            this.DnsSearch.clear();
            if (DnsSearch != null) {for (String item : DnsSearch){this.addToDnsSearch(item);}} return (A) this;
    }

    public A withDnsSearch(String... DnsSearch){
            this.DnsSearch.clear(); if (DnsSearch != null) {for (String item :DnsSearch){ this.addToDnsSearch(item);}} return (A) this;
    }

    public Boolean hasDnsSearch(){
            return DnsSearch!= null && !DnsSearch.isEmpty();
    }

    public A addToExtraHosts(int index,String item){
            this.ExtraHosts.add(index, item); return (A)this;
    }

    public A setToExtraHosts(int index,String item){
            this.ExtraHosts.set(index, item); return (A)this;
    }

    public A addToExtraHosts(String... items){
            for (String item : items) {this.ExtraHosts.add(item);} return (A)this;
    }

    public A addAllToExtraHosts(Collection<String> items){
            for (String item : items) {this.ExtraHosts.add(item);} return (A)this;
    }

    public A removeFromExtraHosts(String... items){
            for (String item : items) {this.ExtraHosts.remove(item);} return (A)this;
    }

    public A removeAllFromExtraHosts(Collection<String> items){
            for (String item : items) {this.ExtraHosts.remove(item);} return (A)this;
    }

    public List<String> getExtraHosts(){
            return this.ExtraHosts;
    }

    public String getExtraHost(int index){
            return this.ExtraHosts.get(index);
    }

    public String getFirstExtraHost(){
            return this.ExtraHosts.get(0);
    }

    public String getLastExtraHost(){
            return this.ExtraHosts.get(ExtraHosts.size() - 1);
    }

    public String getMatchingExtraHost(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: ExtraHosts) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withExtraHosts(List<String> ExtraHosts){
            this.ExtraHosts.clear();
            if (ExtraHosts != null) {for (String item : ExtraHosts){this.addToExtraHosts(item);}} return (A) this;
    }

    public A withExtraHosts(String... ExtraHosts){
            this.ExtraHosts.clear(); if (ExtraHosts != null) {for (String item :ExtraHosts){ this.addToExtraHosts(item);}} return (A) this;
    }

    public Boolean hasExtraHosts(){
            return ExtraHosts!= null && !ExtraHosts.isEmpty();
    }

    public A addToGroupAdd(int index,String item){
            this.GroupAdd.add(index, item); return (A)this;
    }

    public A setToGroupAdd(int index,String item){
            this.GroupAdd.set(index, item); return (A)this;
    }

    public A addToGroupAdd(String... items){
            for (String item : items) {this.GroupAdd.add(item);} return (A)this;
    }

    public A addAllToGroupAdd(Collection<String> items){
            for (String item : items) {this.GroupAdd.add(item);} return (A)this;
    }

    public A removeFromGroupAdd(String... items){
            for (String item : items) {this.GroupAdd.remove(item);} return (A)this;
    }

    public A removeAllFromGroupAdd(Collection<String> items){
            for (String item : items) {this.GroupAdd.remove(item);} return (A)this;
    }

    public List<String> getGroupAdd(){
            return this.GroupAdd;
    }

    public String getGroupAdd(int index){
            return this.GroupAdd.get(index);
    }

    public String getFirstGroupAdd(){
            return this.GroupAdd.get(0);
    }

    public String getLastGroupAdd(){
            return this.GroupAdd.get(GroupAdd.size() - 1);
    }

    public String getMatchingGroupAdd(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: GroupAdd) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withGroupAdd(List<String> GroupAdd){
            this.GroupAdd.clear();
            if (GroupAdd != null) {for (String item : GroupAdd){this.addToGroupAdd(item);}} return (A) this;
    }

    public A withGroupAdd(String... GroupAdd){
            this.GroupAdd.clear(); if (GroupAdd != null) {for (String item :GroupAdd){ this.addToGroupAdd(item);}} return (A) this;
    }

    public Boolean hasGroupAdd(){
            return GroupAdd!= null && !GroupAdd.isEmpty();
    }

    public String getIpcMode(){
            return this.IpcMode;
    }

    public A withIpcMode(String IpcMode){
            this.IpcMode=IpcMode; return (A) this;
    }

    public Boolean hasIpcMode(){
            return this.IpcMode!=null;
    }

    public Long getKernelMemory(){
            return this.KernelMemory;
    }

    public A withKernelMemory(Long KernelMemory){
            this.KernelMemory=KernelMemory; return (A) this;
    }

    public Boolean hasKernelMemory(){
            return this.KernelMemory!=null;
    }

    public A addToLinks(int index,String item){
            this.Links.add(index, item); return (A)this;
    }

    public A setToLinks(int index,String item){
            this.Links.set(index, item); return (A)this;
    }

    public A addToLinks(String... items){
            for (String item : items) {this.Links.add(item);} return (A)this;
    }

    public A addAllToLinks(Collection<String> items){
            for (String item : items) {this.Links.add(item);} return (A)this;
    }

    public A removeFromLinks(String... items){
            for (String item : items) {this.Links.remove(item);} return (A)this;
    }

    public A removeAllFromLinks(Collection<String> items){
            for (String item : items) {this.Links.remove(item);} return (A)this;
    }

    public List<String> getLinks(){
            return this.Links;
    }

    public String getLink(int index){
            return this.Links.get(index);
    }

    public String getFirstLink(){
            return this.Links.get(0);
    }

    public String getLastLink(){
            return this.Links.get(Links.size() - 1);
    }

    public String getMatchingLink(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Links) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withLinks(List<String> Links){
            this.Links.clear();
            if (Links != null) {for (String item : Links){this.addToLinks(item);}} return (A) this;
    }

    public A withLinks(String... Links){
            this.Links.clear(); if (Links != null) {for (String item :Links){ this.addToLinks(item);}} return (A) this;
    }

    public Boolean hasLinks(){
            return Links!= null && !Links.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildLogConfig instead.
 */
@Deprecated public LogConfig getLogConfig(){
            return this.LogConfig!=null?this.LogConfig.build():null;
    }

    public LogConfig buildLogConfig(){
            return this.LogConfig!=null?this.LogConfig.build():null;
    }

    public A withLogConfig(LogConfig LogConfig){
            _visitables.remove(this.LogConfig);
            if (LogConfig!=null){ this.LogConfig= new LogConfigBuilder(LogConfig); _visitables.add(this.LogConfig);} return (A) this;
    }

    public Boolean hasLogConfig(){
            return this.LogConfig!=null;
    }

    public HostConfigFluent.LogConfigNested<A> withNewLogConfig(){
            return new LogConfigNestedImpl();
    }

    public HostConfigFluent.LogConfigNested<A> withNewLogConfigLike(LogConfig item){
            return new LogConfigNestedImpl(item);
    }

    public HostConfigFluent.LogConfigNested<A> editLogConfig(){
            return withNewLogConfigLike(getLogConfig());
    }

    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfig(){
            return withNewLogConfigLike(getLogConfig() != null ? getLogConfig(): new LogConfigBuilder().build());
    }

    public HostConfigFluent.LogConfigNested<A> editOrNewLogConfigLike(LogConfig item){
            return withNewLogConfigLike(getLogConfig() != null ? getLogConfig(): item);
    }

    public LxcConfig getLxcConf(){
            return this.LxcConf;
    }

    public A withLxcConf(LxcConfig LxcConf){
            this.LxcConf=LxcConf; return (A) this;
    }

    public Boolean hasLxcConf(){
            return this.LxcConf!=null;
    }

    public Long getMemory(){
            return this.Memory;
    }

    public A withMemory(Long Memory){
            this.Memory=Memory; return (A) this;
    }

    public Boolean hasMemory(){
            return this.Memory!=null;
    }

    public Long getMemoryReservation(){
            return this.MemoryReservation;
    }

    public A withMemoryReservation(Long MemoryReservation){
            this.MemoryReservation=MemoryReservation; return (A) this;
    }

    public Boolean hasMemoryReservation(){
            return this.MemoryReservation!=null;
    }

    public Long getMemorySwap(){
            return this.MemorySwap;
    }

    public A withMemorySwap(Long MemorySwap){
            this.MemorySwap=MemorySwap; return (A) this;
    }

    public Boolean hasMemorySwap(){
            return this.MemorySwap!=null;
    }

    public Long getMemorySwappiness(){
            return this.MemorySwappiness;
    }

    public A withMemorySwappiness(Long MemorySwappiness){
            this.MemorySwappiness=MemorySwappiness; return (A) this;
    }

    public Boolean hasMemorySwappiness(){
            return this.MemorySwappiness!=null;
    }

    public String getNetworkMode(){
            return this.NetworkMode;
    }

    public A withNetworkMode(String NetworkMode){
            this.NetworkMode=NetworkMode; return (A) this;
    }

    public Boolean hasNetworkMode(){
            return this.NetworkMode!=null;
    }

    public Boolean isOomKillDisable(){
            return this.OomKillDisable;
    }

    public A withOomKillDisable(Boolean OomKillDisable){
            this.OomKillDisable=OomKillDisable; return (A) this;
    }

    public Boolean hasOomKillDisable(){
            return this.OomKillDisable!=null;
    }

    public String getPidMode(){
            return this.PidMode;
    }

    public A withPidMode(String PidMode){
            this.PidMode=PidMode; return (A) this;
    }

    public Boolean hasPidMode(){
            return this.PidMode!=null;
    }

    public A addToPortBindings(String key,ArrayList<PortBinding> value){
            if(key != null && value != null) {this.PortBindings.put(key, value);} return (A)this;
    }

    public A addToPortBindings(Map<String,ArrayList<PortBinding>> map){
            if(map != null) { this.PortBindings.putAll(map);} return (A)this;
    }

    public A removeFromPortBindings(String key){
            if(key != null) {this.PortBindings.remove(key);} return (A)this;
    }

    public A removeFromPortBindings(Map<String,ArrayList<PortBinding>> map){
            if(map != null) { for(Object key : map.keySet()) {this.PortBindings.remove(key);}} return (A)this;
    }

    public Map<String,ArrayList<PortBinding>> getPortBindings(){
            return this.PortBindings;
    }

    public A withPortBindings(Map<String,ArrayList<PortBinding>> PortBindings){
            this.PortBindings.clear();
            if (PortBindings != null) {this.PortBindings.putAll(PortBindings);} return (A) this;
    }

    public Boolean hasPortBindings(){
            return this.PortBindings!=null;
    }

    public Boolean isPrivileged(){
            return this.Privileged;
    }

    public A withPrivileged(Boolean Privileged){
            this.Privileged=Privileged; return (A) this;
    }

    public Boolean hasPrivileged(){
            return this.Privileged!=null;
    }

    public Boolean isPublishAllPorts(){
            return this.PublishAllPorts;
    }

    public A withPublishAllPorts(Boolean PublishAllPorts){
            this.PublishAllPorts=PublishAllPorts; return (A) this;
    }

    public Boolean hasPublishAllPorts(){
            return this.PublishAllPorts!=null;
    }

    public Boolean isReadonlyRootfs(){
            return this.ReadonlyRootfs;
    }

    public A withReadonlyRootfs(Boolean ReadonlyRootfs){
            this.ReadonlyRootfs=ReadonlyRootfs; return (A) this;
    }

    public Boolean hasReadonlyRootfs(){
            return this.ReadonlyRootfs!=null;
    }

    
/**
 * This method has been deprecated, please use method buildRestartPolicy instead.
 */
@Deprecated public RestartPolicy getRestartPolicy(){
            return this.RestartPolicy!=null?this.RestartPolicy.build():null;
    }

    public RestartPolicy buildRestartPolicy(){
            return this.RestartPolicy!=null?this.RestartPolicy.build():null;
    }

    public A withRestartPolicy(RestartPolicy RestartPolicy){
            _visitables.remove(this.RestartPolicy);
            if (RestartPolicy!=null){ this.RestartPolicy= new RestartPolicyBuilder(RestartPolicy); _visitables.add(this.RestartPolicy);} return (A) this;
    }

    public Boolean hasRestartPolicy(){
            return this.RestartPolicy!=null;
    }

    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicy(){
            return new RestartPolicyNestedImpl();
    }

    public HostConfigFluent.RestartPolicyNested<A> withNewRestartPolicyLike(RestartPolicy item){
            return new RestartPolicyNestedImpl(item);
    }

    public HostConfigFluent.RestartPolicyNested<A> editRestartPolicy(){
            return withNewRestartPolicyLike(getRestartPolicy());
    }

    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicy(){
            return withNewRestartPolicyLike(getRestartPolicy() != null ? getRestartPolicy(): new RestartPolicyBuilder().build());
    }

    public HostConfigFluent.RestartPolicyNested<A> editOrNewRestartPolicyLike(RestartPolicy item){
            return withNewRestartPolicyLike(getRestartPolicy() != null ? getRestartPolicy(): item);
    }

    public A withNewRestartPolicy(Integer MaximumRetryCount,String Name){
            return (A)withRestartPolicy(new RestartPolicy(MaximumRetryCount, Name));
    }

    public A addToSecurityOpt(int index,String item){
            this.SecurityOpt.add(index, item); return (A)this;
    }

    public A setToSecurityOpt(int index,String item){
            this.SecurityOpt.set(index, item); return (A)this;
    }

    public A addToSecurityOpt(String... items){
            for (String item : items) {this.SecurityOpt.add(item);} return (A)this;
    }

    public A addAllToSecurityOpt(Collection<String> items){
            for (String item : items) {this.SecurityOpt.add(item);} return (A)this;
    }

    public A removeFromSecurityOpt(String... items){
            for (String item : items) {this.SecurityOpt.remove(item);} return (A)this;
    }

    public A removeAllFromSecurityOpt(Collection<String> items){
            for (String item : items) {this.SecurityOpt.remove(item);} return (A)this;
    }

    public List<String> getSecurityOpt(){
            return this.SecurityOpt;
    }

    public String getSecurityOpt(int index){
            return this.SecurityOpt.get(index);
    }

    public String getFirstSecurityOpt(){
            return this.SecurityOpt.get(0);
    }

    public String getLastSecurityOpt(){
            return this.SecurityOpt.get(SecurityOpt.size() - 1);
    }

    public String getMatchingSecurityOpt(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: SecurityOpt) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withSecurityOpt(List<String> SecurityOpt){
            this.SecurityOpt.clear();
            if (SecurityOpt != null) {for (String item : SecurityOpt){this.addToSecurityOpt(item);}} return (A) this;
    }

    public A withSecurityOpt(String... SecurityOpt){
            this.SecurityOpt.clear(); if (SecurityOpt != null) {for (String item :SecurityOpt){ this.addToSecurityOpt(item);}} return (A) this;
    }

    public Boolean hasSecurityOpt(){
            return SecurityOpt!= null && !SecurityOpt.isEmpty();
    }

    public String getUTSMode(){
            return this.UTSMode;
    }

    public A withUTSMode(String UTSMode){
            this.UTSMode=UTSMode; return (A) this;
    }

    public Boolean hasUTSMode(){
            return this.UTSMode!=null;
    }

    public A addToUlimits(int index,Ulimit item){
            UlimitBuilder builder = new UlimitBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.Ulimits.add(index >= 0 ? index : Ulimits.size(), builder); return (A)this;
    }

    public A setToUlimits(int index,Ulimit item){
            UlimitBuilder builder = new UlimitBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= Ulimits.size()) { Ulimits.add(builder); } else { Ulimits.set(index, builder);}
             return (A)this;
    }

    public A addToUlimits(Ulimit... items){
            for (Ulimit item : items) {UlimitBuilder builder = new UlimitBuilder(item);_visitables.add(builder);this.Ulimits.add(builder);} return (A)this;
    }

    public A addAllToUlimits(Collection<Ulimit> items){
            for (Ulimit item : items) {UlimitBuilder builder = new UlimitBuilder(item);_visitables.add(builder);this.Ulimits.add(builder);} return (A)this;
    }

    public A removeFromUlimits(Ulimit... items){
            for (Ulimit item : items) {UlimitBuilder builder = new UlimitBuilder(item);_visitables.remove(builder);this.Ulimits.remove(builder);} return (A)this;
    }

    public A removeAllFromUlimits(Collection<Ulimit> items){
            for (Ulimit item : items) {UlimitBuilder builder = new UlimitBuilder(item);_visitables.remove(builder);this.Ulimits.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildUlimits instead.
 */
@Deprecated public List<Ulimit> getUlimits(){
            return build(Ulimits);
    }

    public List<Ulimit> buildUlimits(){
            return build(Ulimits);
    }

    public Ulimit buildUlimit(int index){
            return this.Ulimits.get(index).build();
    }

    public Ulimit buildFirstUlimit(){
            return this.Ulimits.get(0).build();
    }

    public Ulimit buildLastUlimit(){
            return this.Ulimits.get(Ulimits.size() - 1).build();
    }

    public Ulimit buildMatchingUlimit(io.fabric8.docker.api.builder.Predicate<UlimitBuilder> predicate){
            for (UlimitBuilder item: Ulimits) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withUlimits(List<Ulimit> Ulimits){
            _visitables.removeAll(this.Ulimits);
            this.Ulimits.clear();
            if (Ulimits != null) {for (Ulimit item : Ulimits){this.addToUlimits(item);}} return (A) this;
    }

    public A withUlimits(Ulimit... Ulimits){
            this.Ulimits.clear(); if (Ulimits != null) {for (Ulimit item :Ulimits){ this.addToUlimits(item);}} return (A) this;
    }

    public Boolean hasUlimits(){
            return Ulimits!= null && !Ulimits.isEmpty();
    }

    public HostConfigFluent.UlimitsNested<A> addNewUlimit(){
            return new UlimitsNestedImpl();
    }

    public HostConfigFluent.UlimitsNested<A> addNewUlimitLike(Ulimit item){
            return new UlimitsNestedImpl(-1, item);
    }

    public HostConfigFluent.UlimitsNested<A> setNewUlimitLike(int index,Ulimit item){
            return new UlimitsNestedImpl(index, item);
    }

    public HostConfigFluent.UlimitsNested<A> editUlimit(int index){
            if (Ulimits.size() <= index) throw new RuntimeException("Can't edit Ulimits. Index exceeds size.");
            return setNewUlimitLike(index, buildUlimit(index));
    }

    public HostConfigFluent.UlimitsNested<A> editFirstUlimit(){
            if (Ulimits.size() == 0) throw new RuntimeException("Can't edit first Ulimits. The list is empty.");
            return setNewUlimitLike(0, buildUlimit(0));
    }

    public HostConfigFluent.UlimitsNested<A> editLastUlimit(){
            int index = Ulimits.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last Ulimits. The list is empty.");
            return setNewUlimitLike(index, buildUlimit(index));
    }

    public HostConfigFluent.UlimitsNested<A> editMatchingUlimit(io.fabric8.docker.api.builder.Predicate<UlimitBuilder> predicate){
            int index = -1;
            for (int i=0;i<Ulimits.size();i++) { 
            if (predicate.apply(Ulimits.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching Ulimits. No match found.");
            return setNewUlimitLike(index, buildUlimit(index));
    }

    public A addNewUlimit(Long Hard,String Name,Long Soft){
            return (A)addToUlimits(new Ulimit(Hard, Name, Soft));
    }

    public String getVolumeDriver(){
            return this.VolumeDriver;
    }

    public A withVolumeDriver(String VolumeDriver){
            this.VolumeDriver=VolumeDriver; return (A) this;
    }

    public Boolean hasVolumeDriver(){
            return this.VolumeDriver!=null;
    }

    public A addToVolumesFrom(int index,String item){
            this.VolumesFrom.add(index, item); return (A)this;
    }

    public A setToVolumesFrom(int index,String item){
            this.VolumesFrom.set(index, item); return (A)this;
    }

    public A addToVolumesFrom(String... items){
            for (String item : items) {this.VolumesFrom.add(item);} return (A)this;
    }

    public A addAllToVolumesFrom(Collection<String> items){
            for (String item : items) {this.VolumesFrom.add(item);} return (A)this;
    }

    public A removeFromVolumesFrom(String... items){
            for (String item : items) {this.VolumesFrom.remove(item);} return (A)this;
    }

    public A removeAllFromVolumesFrom(Collection<String> items){
            for (String item : items) {this.VolumesFrom.remove(item);} return (A)this;
    }

    public List<String> getVolumesFrom(){
            return this.VolumesFrom;
    }

    public String getVolumesFrom(int index){
            return this.VolumesFrom.get(index);
    }

    public String getFirstVolumesFrom(){
            return this.VolumesFrom.get(0);
    }

    public String getLastVolumesFrom(){
            return this.VolumesFrom.get(VolumesFrom.size() - 1);
    }

    public String getMatchingVolumesFrom(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: VolumesFrom) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withVolumesFrom(List<String> VolumesFrom){
            this.VolumesFrom.clear();
            if (VolumesFrom != null) {for (String item : VolumesFrom){this.addToVolumesFrom(item);}} return (A) this;
    }

    public A withVolumesFrom(String... VolumesFrom){
            this.VolumesFrom.clear(); if (VolumesFrom != null) {for (String item :VolumesFrom){ this.addToVolumesFrom(item);}} return (A) this;
    }

    public Boolean hasVolumesFrom(){
            return VolumesFrom!= null && !VolumesFrom.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HostConfigFluentImpl that = (HostConfigFluentImpl) o;
            if (Binds != null ? !Binds.equals(that.Binds) :that.Binds != null) return false;
            if (BlkioWeight != null ? !BlkioWeight.equals(that.BlkioWeight) :that.BlkioWeight != null) return false;
            if (CapAdd != null ? !CapAdd.equals(that.CapAdd) :that.CapAdd != null) return false;
            if (CapDrop != null ? !CapDrop.equals(that.CapDrop) :that.CapDrop != null) return false;
            if (CgroupParent != null ? !CgroupParent.equals(that.CgroupParent) :that.CgroupParent != null) return false;
            if (ConsoleSize != null &&ConsoleSize != this ? !ConsoleSize.equals(that.ConsoleSize) :that.ConsoleSize != null &&ConsoleSize != this ) return false;

            if (ContainerIDFile != null ? !ContainerIDFile.equals(that.ContainerIDFile) :that.ContainerIDFile != null) return false;
            if (CpuPeriod != null ? !CpuPeriod.equals(that.CpuPeriod) :that.CpuPeriod != null) return false;
            if (CpuQuota != null ? !CpuQuota.equals(that.CpuQuota) :that.CpuQuota != null) return false;
            if (CpuShares != null ? !CpuShares.equals(that.CpuShares) :that.CpuShares != null) return false;
            if (CpusetCpus != null ? !CpusetCpus.equals(that.CpusetCpus) :that.CpusetCpus != null) return false;
            if (CpusetMems != null ? !CpusetMems.equals(that.CpusetMems) :that.CpusetMems != null) return false;
            if (Devices != null ? !Devices.equals(that.Devices) :that.Devices != null) return false;
            if (Dns != null ? !Dns.equals(that.Dns) :that.Dns != null) return false;
            if (DnsOptions != null ? !DnsOptions.equals(that.DnsOptions) :that.DnsOptions != null) return false;
            if (DnsSearch != null ? !DnsSearch.equals(that.DnsSearch) :that.DnsSearch != null) return false;
            if (ExtraHosts != null ? !ExtraHosts.equals(that.ExtraHosts) :that.ExtraHosts != null) return false;
            if (GroupAdd != null ? !GroupAdd.equals(that.GroupAdd) :that.GroupAdd != null) return false;
            if (IpcMode != null ? !IpcMode.equals(that.IpcMode) :that.IpcMode != null) return false;
            if (KernelMemory != null ? !KernelMemory.equals(that.KernelMemory) :that.KernelMemory != null) return false;
            if (Links != null ? !Links.equals(that.Links) :that.Links != null) return false;
            if (LogConfig != null ? !LogConfig.equals(that.LogConfig) :that.LogConfig != null) return false;
            if (LxcConf != null ? !LxcConf.equals(that.LxcConf) :that.LxcConf != null) return false;
            if (Memory != null ? !Memory.equals(that.Memory) :that.Memory != null) return false;
            if (MemoryReservation != null ? !MemoryReservation.equals(that.MemoryReservation) :that.MemoryReservation != null) return false;
            if (MemorySwap != null ? !MemorySwap.equals(that.MemorySwap) :that.MemorySwap != null) return false;
            if (MemorySwappiness != null ? !MemorySwappiness.equals(that.MemorySwappiness) :that.MemorySwappiness != null) return false;
            if (NetworkMode != null ? !NetworkMode.equals(that.NetworkMode) :that.NetworkMode != null) return false;
            if (OomKillDisable != null ? !OomKillDisable.equals(that.OomKillDisable) :that.OomKillDisable != null) return false;
            if (PidMode != null ? !PidMode.equals(that.PidMode) :that.PidMode != null) return false;
            if (PortBindings != null ? !PortBindings.equals(that.PortBindings) :that.PortBindings != null) return false;
            if (Privileged != null ? !Privileged.equals(that.Privileged) :that.Privileged != null) return false;
            if (PublishAllPorts != null ? !PublishAllPorts.equals(that.PublishAllPorts) :that.PublishAllPorts != null) return false;
            if (ReadonlyRootfs != null ? !ReadonlyRootfs.equals(that.ReadonlyRootfs) :that.ReadonlyRootfs != null) return false;
            if (RestartPolicy != null ? !RestartPolicy.equals(that.RestartPolicy) :that.RestartPolicy != null) return false;
            if (SecurityOpt != null ? !SecurityOpt.equals(that.SecurityOpt) :that.SecurityOpt != null) return false;
            if (UTSMode != null ? !UTSMode.equals(that.UTSMode) :that.UTSMode != null) return false;
            if (Ulimits != null ? !Ulimits.equals(that.Ulimits) :that.Ulimits != null) return false;
            if (VolumeDriver != null ? !VolumeDriver.equals(that.VolumeDriver) :that.VolumeDriver != null) return false;
            if (VolumesFrom != null ? !VolumesFrom.equals(that.VolumesFrom) :that.VolumesFrom != null) return false;
            return true;
    }


    public class DevicesNestedImpl<N> extends DeviceMappingFluentImpl<HostConfigFluent.DevicesNested<N>> implements HostConfigFluent.DevicesNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final DeviceMappingBuilder builder;
        private final int index;
    
            DevicesNestedImpl(int index,DeviceMapping item){
                    this.index = index;
                    this.builder = new DeviceMappingBuilder(this, item);
            }
            DevicesNestedImpl(){
                    this.index = -1;
                    this.builder = new DeviceMappingBuilder(this);
            }
    
    public N and(){
            return (N) HostConfigFluentImpl.this.setToDevices(index, builder.build());
    }
    public N endDevice(){
            return and();
    }

}
    public class LogConfigNestedImpl<N> extends LogConfigFluentImpl<HostConfigFluent.LogConfigNested<N>> implements HostConfigFluent.LogConfigNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final LogConfigBuilder builder;
    
            LogConfigNestedImpl(LogConfig item){
                    this.builder = new LogConfigBuilder(this, item);
            }
            LogConfigNestedImpl(){
                    this.builder = new LogConfigBuilder(this);
            }
    
    public N and(){
            return (N) HostConfigFluentImpl.this.withLogConfig(builder.build());
    }
    public N endLogConfig(){
            return and();
    }

}
    public class RestartPolicyNestedImpl<N> extends RestartPolicyFluentImpl<HostConfigFluent.RestartPolicyNested<N>> implements HostConfigFluent.RestartPolicyNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final RestartPolicyBuilder builder;
    
            RestartPolicyNestedImpl(RestartPolicy item){
                    this.builder = new RestartPolicyBuilder(this, item);
            }
            RestartPolicyNestedImpl(){
                    this.builder = new RestartPolicyBuilder(this);
            }
    
    public N and(){
            return (N) HostConfigFluentImpl.this.withRestartPolicy(builder.build());
    }
    public N endRestartPolicy(){
            return and();
    }

}
    public class UlimitsNestedImpl<N> extends UlimitFluentImpl<HostConfigFluent.UlimitsNested<N>> implements HostConfigFluent.UlimitsNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final UlimitBuilder builder;
        private final int index;
    
            UlimitsNestedImpl(int index,Ulimit item){
                    this.index = index;
                    this.builder = new UlimitBuilder(this, item);
            }
            UlimitsNestedImpl(){
                    this.index = -1;
                    this.builder = new UlimitBuilder(this);
            }
    
    public N and(){
            return (N) HostConfigFluentImpl.this.setToUlimits(index, builder.build());
    }
    public N endUlimit(){
            return and();
    }

}


}
