package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IPAMBuilder extends IPAMFluentImpl<IPAMBuilder> implements VisitableBuilder<IPAM,IPAMBuilder>{

    IPAMFluent<?> fluent;
    Boolean validationEnabled;

    public IPAMBuilder(){
            this(true);
    }
    public IPAMBuilder(Boolean validationEnabled){
            this(new IPAM(), validationEnabled);
    }
    public IPAMBuilder(IPAMFluent<?> fluent){
            this(fluent, true);
    }
    public IPAMBuilder(IPAMFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IPAM(), validationEnabled);
    }
    public IPAMBuilder(IPAMFluent<?> fluent,IPAM instance){
            this(fluent, instance, true);
    }
    public IPAMBuilder(IPAMFluent<?> fluent,IPAM instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfig(instance.getConfig()); 
            fluent.withDriver(instance.getDriver()); 
            this.validationEnabled = validationEnabled; 
    }
    public IPAMBuilder(IPAM instance){
            this(instance,true);
    }
    public IPAMBuilder(IPAM instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfig(instance.getConfig()); 
            this.withDriver(instance.getDriver()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableIPAM build(){
            EditableIPAM buildable = new EditableIPAM(fluent.getConfig(),fluent.getDriver());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IPAMBuilder that = (IPAMBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
