package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IPAMConfigBuilder extends IPAMConfigFluentImpl<IPAMConfigBuilder> implements VisitableBuilder<IPAMConfig,IPAMConfigBuilder>{

    IPAMConfigFluent<?> fluent;
    Boolean validationEnabled;

    public IPAMConfigBuilder(){
            this(true);
    }
    public IPAMConfigBuilder(Boolean validationEnabled){
            this(new IPAMConfig(), validationEnabled);
    }
    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent){
            this(fluent, true);
    }
    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IPAMConfig(), validationEnabled);
    }
    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance){
            this(fluent, instance, true);
    }
    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuxiliaryAddresses(instance.getAuxiliaryAddresses()); 
            fluent.withGateway(instance.getGateway()); 
            fluent.withIPRange(instance.getIPRange()); 
            fluent.withSubnet(instance.getSubnet()); 
            this.validationEnabled = validationEnabled; 
    }
    public IPAMConfigBuilder(IPAMConfig instance){
            this(instance,true);
    }
    public IPAMConfigBuilder(IPAMConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuxiliaryAddresses(instance.getAuxiliaryAddresses()); 
            this.withGateway(instance.getGateway()); 
            this.withIPRange(instance.getIPRange()); 
            this.withSubnet(instance.getSubnet()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableIPAMConfig build(){
            EditableIPAMConfig buildable = new EditableIPAMConfig(fluent.getAuxiliaryAddresses(),fluent.getGateway(),fluent.getIPRange(),fluent.getSubnet());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IPAMConfigBuilder that = (IPAMConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
