package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class IPAMConfigFluentImpl<A extends IPAMConfigFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements IPAMConfigFluent<A>{

    private Map<String,String> AuxiliaryAddresses = new LinkedHashMap<String,String>();
    private String Gateway;
    private String IPRange;
    private String Subnet;

    public IPAMConfigFluentImpl(){
    }
    public IPAMConfigFluentImpl(IPAMConfig instance){
            this.withAuxiliaryAddresses(instance.getAuxiliaryAddresses()); 
            this.withGateway(instance.getGateway()); 
            this.withIPRange(instance.getIPRange()); 
            this.withSubnet(instance.getSubnet()); 
    }

    public A addToAuxiliaryAddresses(String key,String value){
            if(key != null && value != null) {this.AuxiliaryAddresses.put(key, value);} return (A)this;
    }

    public A addToAuxiliaryAddresses(Map<String,String> map){
            if(map != null) { this.AuxiliaryAddresses.putAll(map);} return (A)this;
    }

    public A removeFromAuxiliaryAddresses(String key){
            if(key != null) {this.AuxiliaryAddresses.remove(key);} return (A)this;
    }

    public A removeFromAuxiliaryAddresses(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.AuxiliaryAddresses.remove(key);}} return (A)this;
    }

    public Map<String,String> getAuxiliaryAddresses(){
            return this.AuxiliaryAddresses;
    }

    public A withAuxiliaryAddresses(Map<String,String> AuxiliaryAddresses){
            this.AuxiliaryAddresses.clear();
            if (AuxiliaryAddresses != null) {this.AuxiliaryAddresses.putAll(AuxiliaryAddresses);} return (A) this;
    }

    public Boolean hasAuxiliaryAddresses(){
            return this.AuxiliaryAddresses!=null;
    }

    public String getGateway(){
            return this.Gateway;
    }

    public A withGateway(String Gateway){
            this.Gateway=Gateway; return (A) this;
    }

    public Boolean hasGateway(){
            return this.Gateway!=null;
    }

    public String getIPRange(){
            return this.IPRange;
    }

    public A withIPRange(String IPRange){
            this.IPRange=IPRange; return (A) this;
    }

    public Boolean hasIPRange(){
            return this.IPRange!=null;
    }

    public String getSubnet(){
            return this.Subnet;
    }

    public A withSubnet(String Subnet){
            this.Subnet=Subnet; return (A) this;
    }

    public Boolean hasSubnet(){
            return this.Subnet!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IPAMConfigFluentImpl that = (IPAMConfigFluentImpl) o;
            if (AuxiliaryAddresses != null ? !AuxiliaryAddresses.equals(that.AuxiliaryAddresses) :that.AuxiliaryAddresses != null) return false;
            if (Gateway != null ? !Gateway.equals(that.Gateway) :that.Gateway != null) return false;
            if (IPRange != null ? !IPRange.equals(that.IPRange) :that.IPRange != null) return false;
            if (Subnet != null ? !Subnet.equals(that.Subnet) :that.Subnet != null) return false;
            return true;
    }




}
