package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface IPAMFluent<A extends IPAMFluent<A>> extends Fluent<A>{


    public A addToConfig(int index,IPAMConfig item);
    public A setToConfig(int index,IPAMConfig item);
    public A addToConfig(IPAMConfig... items);
    public A addAllToConfig(Collection<IPAMConfig> items);
    public A removeFromConfig(IPAMConfig... items);
    public A removeAllFromConfig(Collection<IPAMConfig> items);
    
/**
 * This method has been deprecated, please use method buildConfig instead.
 */
@Deprecated public List<IPAMConfig> getConfig();
    public List<IPAMConfig> buildConfig();
    public IPAMConfig buildConfig(int index);
    public IPAMConfig buildFirstConfig();
    public IPAMConfig buildLastConfig();
    public IPAMConfig buildMatchingConfig(io.fabric8.docker.api.builder.Predicate<IPAMConfigBuilder> predicate);
    public A withConfig(List<IPAMConfig> Config);
    public A withConfig(IPAMConfig... Config);
    public Boolean hasConfig();
    public IPAMFluent.ConfigNested<A> addNewConfig();
    public IPAMFluent.ConfigNested<A> addNewConfigLike(IPAMConfig item);
    public IPAMFluent.ConfigNested<A> setNewConfigLike(int index,IPAMConfig item);
    public IPAMFluent.ConfigNested<A> editConfig(int index);
    public IPAMFluent.ConfigNested<A> editFirstConfig();
    public IPAMFluent.ConfigNested<A> editLastConfig();
    public IPAMFluent.ConfigNested<A> editMatchingConfig(io.fabric8.docker.api.builder.Predicate<IPAMConfigBuilder> predicate);
    public String getDriver();
    public A withDriver(String Driver);
    public Boolean hasDriver();

    public interface ConfigNested<N> extends io.fabric8.docker.api.builder.Nested<N>,IPAMConfigFluent<IPAMFluent.ConfigNested<N>>{

        
    public N and();    public N endConfig();
}


}
