package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageBuilder extends ImageFluentImpl<ImageBuilder> implements VisitableBuilder<Image,ImageBuilder>{

    ImageFluent<?> fluent;
    Boolean validationEnabled;

    public ImageBuilder(){
            this(true);
    }
    public ImageBuilder(Boolean validationEnabled){
            this(new Image(), validationEnabled);
    }
    public ImageBuilder(ImageFluent<?> fluent){
            this(fluent, true);
    }
    public ImageBuilder(ImageFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Image(), validationEnabled);
    }
    public ImageBuilder(ImageFluent<?> fluent,Image instance){
            this(fluent, instance, true);
    }
    public ImageBuilder(ImageFluent<?> fluent,Image instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCreated(instance.getCreated()); 
            fluent.withId(instance.getId()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withParentId(instance.getParentId()); 
            fluent.withRepoDigests(instance.getRepoDigests()); 
            fluent.withRepoTags(instance.getRepoTags()); 
            fluent.withSize(instance.getSize()); 
            fluent.withVirtualSize(instance.getVirtualSize()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageBuilder(Image instance){
            this(instance,true);
    }
    public ImageBuilder(Image instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCreated(instance.getCreated()); 
            this.withId(instance.getId()); 
            this.withLabels(instance.getLabels()); 
            this.withParentId(instance.getParentId()); 
            this.withRepoDigests(instance.getRepoDigests()); 
            this.withRepoTags(instance.getRepoTags()); 
            this.withSize(instance.getSize()); 
            this.withVirtualSize(instance.getVirtualSize()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableImage build(){
            EditableImage buildable = new EditableImage(fluent.getCreated(),fluent.getId(),fluent.getLabels(),fluent.getParentId(),fluent.getRepoDigests(),fluent.getRepoTags(),fluent.getSize(),fluent.getVirtualSize());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageBuilder that = (ImageBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
