package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ImageHistoryFluent<A extends ImageHistoryFluent<A>> extends Fluent<A>{


    public String getComment();
    public A withComment(String Comment);
    public Boolean hasComment();
    public Long getCreated();
    public A withCreated(Long Created);
    public Boolean hasCreated();
    public String getCreatedBy();
    public A withCreatedBy(String CreatedBy);
    public Boolean hasCreatedBy();
    public String getId();
    public A withId(String Id);
    public Boolean hasId();
    public Long getSize();
    public A withSize(Long Size);
    public Boolean hasSize();
    public A addToTags(int index,String item);
    public A setToTags(int index,String item);
    public A addToTags(String... items);
    public A addAllToTags(Collection<String> items);
    public A removeFromTags(String... items);
    public A removeAllFromTags(Collection<String> items);
    public List<String> getTags();
    public String getTag(int index);
    public String getFirstTag();
    public String getLastTag();
    public String getMatchingTag(io.fabric8.docker.api.builder.Predicate<String> predicate);
    public A withTags(List<String> Tags);
    public A withTags(String... Tags);
    public Boolean hasTags();



}
