package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ImageHistoryFluentImpl<A extends ImageHistoryFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements ImageHistoryFluent<A>{

    private String Comment;
    private Long Created;
    private String CreatedBy;
    private String Id;
    private Long Size;
    private List<String> Tags = new ArrayList<String>();

    public ImageHistoryFluentImpl(){
    }
    public ImageHistoryFluentImpl(ImageHistory instance){
            this.withComment(instance.getComment()); 
            this.withCreated(instance.getCreated()); 
            this.withCreatedBy(instance.getCreatedBy()); 
            this.withId(instance.getId()); 
            this.withSize(instance.getSize()); 
            this.withTags(instance.getTags()); 
    }

    public String getComment(){
            return this.Comment;
    }

    public A withComment(String Comment){
            this.Comment=Comment; return (A) this;
    }

    public Boolean hasComment(){
            return this.Comment!=null;
    }

    public Long getCreated(){
            return this.Created;
    }

    public A withCreated(Long Created){
            this.Created=Created; return (A) this;
    }

    public Boolean hasCreated(){
            return this.Created!=null;
    }

    public String getCreatedBy(){
            return this.CreatedBy;
    }

    public A withCreatedBy(String CreatedBy){
            this.CreatedBy=CreatedBy; return (A) this;
    }

    public Boolean hasCreatedBy(){
            return this.CreatedBy!=null;
    }

    public String getId(){
            return this.Id;
    }

    public A withId(String Id){
            this.Id=Id; return (A) this;
    }

    public Boolean hasId(){
            return this.Id!=null;
    }

    public Long getSize(){
            return this.Size;
    }

    public A withSize(Long Size){
            this.Size=Size; return (A) this;
    }

    public Boolean hasSize(){
            return this.Size!=null;
    }

    public A addToTags(int index,String item){
            this.Tags.add(index, item); return (A)this;
    }

    public A setToTags(int index,String item){
            this.Tags.set(index, item); return (A)this;
    }

    public A addToTags(String... items){
            for (String item : items) {this.Tags.add(item);} return (A)this;
    }

    public A addAllToTags(Collection<String> items){
            for (String item : items) {this.Tags.add(item);} return (A)this;
    }

    public A removeFromTags(String... items){
            for (String item : items) {this.Tags.remove(item);} return (A)this;
    }

    public A removeAllFromTags(Collection<String> items){
            for (String item : items) {this.Tags.remove(item);} return (A)this;
    }

    public List<String> getTags(){
            return this.Tags;
    }

    public String getTag(int index){
            return this.Tags.get(index);
    }

    public String getFirstTag(){
            return this.Tags.get(0);
    }

    public String getLastTag(){
            return this.Tags.get(Tags.size() - 1);
    }

    public String getMatchingTag(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Tags) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withTags(List<String> Tags){
            this.Tags.clear();
            if (Tags != null) {for (String item : Tags){this.addToTags(item);}} return (A) this;
    }

    public A withTags(String... Tags){
            this.Tags.clear(); if (Tags != null) {for (String item :Tags){ this.addToTags(item);}} return (A) this;
    }

    public Boolean hasTags(){
            return Tags!= null && !Tags.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageHistoryFluentImpl that = (ImageHistoryFluentImpl) o;
            if (Comment != null ? !Comment.equals(that.Comment) :that.Comment != null) return false;
            if (Created != null ? !Created.equals(that.Created) :that.Created != null) return false;
            if (CreatedBy != null ? !CreatedBy.equals(that.CreatedBy) :that.CreatedBy != null) return false;
            if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
            if (Size != null ? !Size.equals(that.Size) :that.Size != null) return false;
            if (Tags != null ? !Tags.equals(that.Tags) :that.Tags != null) return false;
            return true;
    }




}
