package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class IndexInfoFluentImpl<A extends IndexInfoFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements IndexInfoFluent<A>{

    private List<String> Mirrors = new ArrayList<String>();
    private String Name;
    private Boolean Official;
    private Boolean Secure;

    public IndexInfoFluentImpl(){
    }
    public IndexInfoFluentImpl(IndexInfo instance){
            this.withMirrors(instance.getMirrors()); 
            this.withName(instance.getName()); 
            this.withOfficial(instance.getOfficial()); 
            this.withSecure(instance.getSecure()); 
    }

    public A addToMirrors(int index,String item){
            this.Mirrors.add(index, item); return (A)this;
    }

    public A setToMirrors(int index,String item){
            this.Mirrors.set(index, item); return (A)this;
    }

    public A addToMirrors(String... items){
            for (String item : items) {this.Mirrors.add(item);} return (A)this;
    }

    public A addAllToMirrors(Collection<String> items){
            for (String item : items) {this.Mirrors.add(item);} return (A)this;
    }

    public A removeFromMirrors(String... items){
            for (String item : items) {this.Mirrors.remove(item);} return (A)this;
    }

    public A removeAllFromMirrors(Collection<String> items){
            for (String item : items) {this.Mirrors.remove(item);} return (A)this;
    }

    public List<String> getMirrors(){
            return this.Mirrors;
    }

    public String getMirror(int index){
            return this.Mirrors.get(index);
    }

    public String getFirstMirror(){
            return this.Mirrors.get(0);
    }

    public String getLastMirror(){
            return this.Mirrors.get(Mirrors.size() - 1);
    }

    public String getMatchingMirror(io.fabric8.docker.api.builder.Predicate<String> predicate){
            for (String item: Mirrors) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withMirrors(List<String> Mirrors){
            this.Mirrors.clear();
            if (Mirrors != null) {for (String item : Mirrors){this.addToMirrors(item);}} return (A) this;
    }

    public A withMirrors(String... Mirrors){
            this.Mirrors.clear(); if (Mirrors != null) {for (String item :Mirrors){ this.addToMirrors(item);}} return (A) this;
    }

    public Boolean hasMirrors(){
            return Mirrors!= null && !Mirrors.isEmpty();
    }

    public String getName(){
            return this.Name;
    }

    public A withName(String Name){
            this.Name=Name; return (A) this;
    }

    public Boolean hasName(){
            return this.Name!=null;
    }

    public Boolean isOfficial(){
            return this.Official;
    }

    public A withOfficial(Boolean Official){
            this.Official=Official; return (A) this;
    }

    public Boolean hasOfficial(){
            return this.Official!=null;
    }

    public Boolean isSecure(){
            return this.Secure;
    }

    public A withSecure(Boolean Secure){
            this.Secure=Secure; return (A) this;
    }

    public Boolean hasSecure(){
            return this.Secure!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IndexInfoFluentImpl that = (IndexInfoFluentImpl) o;
            if (Mirrors != null ? !Mirrors.equals(that.Mirrors) :that.Mirrors != null) return false;
            if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
            if (Official != null ? !Official.equals(that.Official) :that.Official != null) return false;
            if (Secure != null ? !Secure.equals(that.Secure) :that.Secure != null) return false;
            return true;
    }




}
