package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LogConfigBuilder extends LogConfigFluentImpl<LogConfigBuilder> implements VisitableBuilder<LogConfig,LogConfigBuilder>{

    LogConfigFluent<?> fluent;
    Boolean validationEnabled;

    public LogConfigBuilder(){
            this(true);
    }
    public LogConfigBuilder(Boolean validationEnabled){
            this(new LogConfig(), validationEnabled);
    }
    public LogConfigBuilder(LogConfigFluent<?> fluent){
            this(fluent, true);
    }
    public LogConfigBuilder(LogConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LogConfig(), validationEnabled);
    }
    public LogConfigBuilder(LogConfigFluent<?> fluent,LogConfig instance){
            this(fluent, instance, true);
    }
    public LogConfigBuilder(LogConfigFluent<?> fluent,LogConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfig(instance.getConfig()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public LogConfigBuilder(LogConfig instance){
            this(instance,true);
    }
    public LogConfigBuilder(LogConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfig(instance.getConfig()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableLogConfig build(){
            EditableLogConfig buildable = new EditableLogConfig(fluent.getConfig(),fluent.getType());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LogConfigBuilder that = (LogConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
