package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface LogConfigFluent<A extends LogConfigFluent<A>> extends Fluent<A>{


    public A addToConfig(String key,String value);
    public A addToConfig(Map<String,String> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,String> map);
    public Map<String,String> getConfig();
    public A withConfig(Map<String,String> Config);
    public Boolean hasConfig();
    public String getType();
    public A withType(String Type);
    public Boolean hasType();



}
