package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface MemoryStatsFluent<A extends MemoryStatsFluent<A>> extends Fluent<A>{


    public Long getFailcnt();
    public A withFailcnt(Long failcnt);
    public Boolean hasFailcnt();
    public Long getLimit();
    public A withLimit(Long limit);
    public Boolean hasLimit();
    public Long getMaxUsage();
    public A withMaxUsage(Long maxUsage);
    public Boolean hasMaxUsage();
    public A addToStats(String key,Long value);
    public A addToStats(Map<String,Long> map);
    public A removeFromStats(String key);
    public A removeFromStats(Map<String,Long> map);
    public Map<String,Long> getStats();
    public A withStats(Map<String,Long> stats);
    public Boolean hasStats();
    public Long getUsage();
    public A withUsage(Long usage);
    public Boolean hasUsage();



}
