package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MountPointBuilder extends MountPointFluentImpl<MountPointBuilder> implements VisitableBuilder<MountPoint,MountPointBuilder>{

    MountPointFluent<?> fluent;
    Boolean validationEnabled;

    public MountPointBuilder(){
            this(true);
    }
    public MountPointBuilder(Boolean validationEnabled){
            this(new MountPoint(), validationEnabled);
    }
    public MountPointBuilder(MountPointFluent<?> fluent){
            this(fluent, true);
    }
    public MountPointBuilder(MountPointFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MountPoint(), validationEnabled);
    }
    public MountPointBuilder(MountPointFluent<?> fluent,MountPoint instance){
            this(fluent, instance, true);
    }
    public MountPointBuilder(MountPointFluent<?> fluent,MountPoint instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDestination(instance.getDestination()); 
            fluent.withDriver(instance.getDriver()); 
            fluent.withMode(instance.getMode()); 
            fluent.withName(instance.getName()); 
            fluent.withRW(instance.getRW()); 
            fluent.withSource(instance.getSource()); 
            this.validationEnabled = validationEnabled; 
    }
    public MountPointBuilder(MountPoint instance){
            this(instance,true);
    }
    public MountPointBuilder(MountPoint instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDestination(instance.getDestination()); 
            this.withDriver(instance.getDriver()); 
            this.withMode(instance.getMode()); 
            this.withName(instance.getName()); 
            this.withRW(instance.getRW()); 
            this.withSource(instance.getSource()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableMountPoint build(){
            EditableMountPoint buildable = new EditableMountPoint(fluent.getDestination(),fluent.getDriver(),fluent.getMode(),fluent.getName(),fluent.isRW(),fluent.getSource());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MountPointBuilder that = (MountPointBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
