package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetIPNetBuilder extends NetIPNetFluentImpl<NetIPNetBuilder> implements VisitableBuilder<NetIPNet,NetIPNetBuilder>{

    NetIPNetFluent<?> fluent;
    Boolean validationEnabled;

    public NetIPNetBuilder(){
            this(true);
    }
    public NetIPNetBuilder(Boolean validationEnabled){
            this(new NetIPNet(), validationEnabled);
    }
    public NetIPNetBuilder(NetIPNetFluent<?> fluent){
            this(fluent, true);
    }
    public NetIPNetBuilder(NetIPNetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetIPNet(), validationEnabled);
    }
    public NetIPNetBuilder(NetIPNetFluent<?> fluent,NetIPNet instance){
            this(fluent, instance, true);
    }
    public NetIPNetBuilder(NetIPNetFluent<?> fluent,NetIPNet instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIp(instance.getIp()); 
            fluent.withMask(instance.getMask()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetIPNetBuilder(NetIPNet instance){
            this(instance,true);
    }
    public NetIPNetBuilder(NetIPNet instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIp(instance.getIp()); 
            this.withMask(instance.getMask()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetIPNet build(){
            EditableNetIPNet buildable = new EditableNetIPNet(fluent.getIp(),fluent.getMask());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetIPNetBuilder that = (NetIPNetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
