package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class NetIPNetFluentImpl<A extends NetIPNetFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements NetIPNetFluent<A>{

    private String ip;
    private String mask;

    public NetIPNetFluentImpl(){
    }
    public NetIPNetFluentImpl(NetIPNet instance){
            this.withIp(instance.getIp()); 
            this.withMask(instance.getMask()); 
    }

    public String getIp(){
            return this.ip;
    }

    public A withIp(String ip){
            this.ip=ip; return (A) this;
    }

    public Boolean hasIp(){
            return this.ip!=null;
    }

    public String getMask(){
            return this.mask;
    }

    public A withMask(String mask){
            this.mask=mask; return (A) this;
    }

    public Boolean hasMask(){
            return this.mask!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetIPNetFluentImpl that = (NetIPNetFluentImpl) o;
            if (ip != null ? !ip.equals(that.ip) :that.ip != null) return false;
            if (mask != null ? !mask.equals(that.mask) :that.mask != null) return false;
            return true;
    }




}
