package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NetworkResourceFluent<A extends NetworkResourceFluent<A>> extends Fluent<A>{


    public A addToContainers(String key,EndpointResource value);
    public A addToContainers(Map<String,EndpointResource> map);
    public A removeFromContainers(String key);
    public A removeFromContainers(Map<String,EndpointResource> map);
    public Map<String,EndpointResource> getContainers();
    public A withContainers(Map<String,EndpointResource> Containers);
    public Boolean hasContainers();
    public String getDriver();
    public A withDriver(String Driver);
    public Boolean hasDriver();
    
/**
 * This method has been deprecated, please use method buildIPAM instead.
 */
@Deprecated public IPAM getIPAM();
    public IPAM buildIPAM();
    public A withIPAM(IPAM IPAM);
    public Boolean hasIPAM();
    public NetworkResourceFluent.IPAMNested<A> withNewIPAM();
    public NetworkResourceFluent.IPAMNested<A> withNewIPAMLike(IPAM item);
    public NetworkResourceFluent.IPAMNested<A> editIPAM();
    public NetworkResourceFluent.IPAMNested<A> editOrNewIPAM();
    public NetworkResourceFluent.IPAMNested<A> editOrNewIPAMLike(IPAM item);
    public String getId();
    public A withId(String Id);
    public Boolean hasId();
    public String getName();
    public A withName(String Name);
    public Boolean hasName();
    public A addToOptions(String key,String value);
    public A addToOptions(Map<String,String> map);
    public A removeFromOptions(String key);
    public A removeFromOptions(Map<String,String> map);
    public Map<String,String> getOptions();
    public A withOptions(Map<String,String> Options);
    public Boolean hasOptions();
    public String getScope();
    public A withScope(String Scope);
    public Boolean hasScope();

    public interface IPAMNested<N> extends io.fabric8.docker.api.builder.Nested<N>,IPAMFluent<NetworkResourceFluent.IPAMNested<N>>{

        
    public N and();    public N endIPAM();
}


}
