package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.docker.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class NetworkSettingsBaseFluentImpl<A extends NetworkSettingsBaseFluent<A>> extends io.fabric8.docker.api.builder.BaseFluent<A> implements NetworkSettingsBaseFluent<A>{

    private String Bridge;
    private Boolean HairpinMode;
    private String LinkLocalIPv6Address;
    private Integer LinkLocalIPv6PrefixLen;
    private Map<String,ArrayList<PortBinding>> Ports = new LinkedHashMap<String,ArrayList<PortBinding>>();
    private String SandboxID;
    private String SandboxKey;
    private List<AddressBuilder> SecondaryIPAddresses =  new ArrayList<AddressBuilder>();
    private List<AddressBuilder> SecondaryIPv6Addresses =  new ArrayList<AddressBuilder>();

    public NetworkSettingsBaseFluentImpl(){
    }
    public NetworkSettingsBaseFluentImpl(NetworkSettingsBase instance){
            this.withBridge(instance.getBridge()); 
            this.withHairpinMode(instance.getHairpinMode()); 
            this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); 
            this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); 
            this.withPorts(instance.getPorts()); 
            this.withSandboxID(instance.getSandboxID()); 
            this.withSandboxKey(instance.getSandboxKey()); 
            this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); 
            this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
    }

    public String getBridge(){
            return this.Bridge;
    }

    public A withBridge(String Bridge){
            this.Bridge=Bridge; return (A) this;
    }

    public Boolean hasBridge(){
            return this.Bridge!=null;
    }

    public Boolean isHairpinMode(){
            return this.HairpinMode;
    }

    public A withHairpinMode(Boolean HairpinMode){
            this.HairpinMode=HairpinMode; return (A) this;
    }

    public Boolean hasHairpinMode(){
            return this.HairpinMode!=null;
    }

    public String getLinkLocalIPv6Address(){
            return this.LinkLocalIPv6Address;
    }

    public A withLinkLocalIPv6Address(String LinkLocalIPv6Address){
            this.LinkLocalIPv6Address=LinkLocalIPv6Address; return (A) this;
    }

    public Boolean hasLinkLocalIPv6Address(){
            return this.LinkLocalIPv6Address!=null;
    }

    public Integer getLinkLocalIPv6PrefixLen(){
            return this.LinkLocalIPv6PrefixLen;
    }

    public A withLinkLocalIPv6PrefixLen(Integer LinkLocalIPv6PrefixLen){
            this.LinkLocalIPv6PrefixLen=LinkLocalIPv6PrefixLen; return (A) this;
    }

    public Boolean hasLinkLocalIPv6PrefixLen(){
            return this.LinkLocalIPv6PrefixLen!=null;
    }

    public A addToPorts(String key,ArrayList<PortBinding> value){
            if(key != null && value != null) {this.Ports.put(key, value);} return (A)this;
    }

    public A addToPorts(Map<String,ArrayList<PortBinding>> map){
            if(map != null) { this.Ports.putAll(map);} return (A)this;
    }

    public A removeFromPorts(String key){
            if(key != null) {this.Ports.remove(key);} return (A)this;
    }

    public A removeFromPorts(Map<String,ArrayList<PortBinding>> map){
            if(map != null) { for(Object key : map.keySet()) {this.Ports.remove(key);}} return (A)this;
    }

    public Map<String,ArrayList<PortBinding>> getPorts(){
            return this.Ports;
    }

    public A withPorts(Map<String,ArrayList<PortBinding>> Ports){
            this.Ports.clear();
            if (Ports != null) {this.Ports.putAll(Ports);} return (A) this;
    }

    public Boolean hasPorts(){
            return this.Ports!=null;
    }

    public String getSandboxID(){
            return this.SandboxID;
    }

    public A withSandboxID(String SandboxID){
            this.SandboxID=SandboxID; return (A) this;
    }

    public Boolean hasSandboxID(){
            return this.SandboxID!=null;
    }

    public String getSandboxKey(){
            return this.SandboxKey;
    }

    public A withSandboxKey(String SandboxKey){
            this.SandboxKey=SandboxKey; return (A) this;
    }

    public Boolean hasSandboxKey(){
            return this.SandboxKey!=null;
    }

    public A addToSecondaryIPAddresses(int index,Address item){
            AddressBuilder builder = new AddressBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.SecondaryIPAddresses.add(index >= 0 ? index : SecondaryIPAddresses.size(), builder); return (A)this;
    }

    public A setToSecondaryIPAddresses(int index,Address item){
            AddressBuilder builder = new AddressBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= SecondaryIPAddresses.size()) { SecondaryIPAddresses.add(builder); } else { SecondaryIPAddresses.set(index, builder);}
             return (A)this;
    }

    public A addToSecondaryIPAddresses(Address... items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.add(builder);this.SecondaryIPAddresses.add(builder);} return (A)this;
    }

    public A addAllToSecondaryIPAddresses(Collection<Address> items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.add(builder);this.SecondaryIPAddresses.add(builder);} return (A)this;
    }

    public A removeFromSecondaryIPAddresses(Address... items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.remove(builder);this.SecondaryIPAddresses.remove(builder);} return (A)this;
    }

    public A removeAllFromSecondaryIPAddresses(Collection<Address> items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.remove(builder);this.SecondaryIPAddresses.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSecondaryIPAddresses instead.
 */
@Deprecated public List<Address> getSecondaryIPAddresses(){
            return build(SecondaryIPAddresses);
    }

    public List<Address> buildSecondaryIPAddresses(){
            return build(SecondaryIPAddresses);
    }

    public Address buildSecondaryIPAddress(int index){
            return this.SecondaryIPAddresses.get(index).build();
    }

    public Address buildFirstSecondaryIPAddress(){
            return this.SecondaryIPAddresses.get(0).build();
    }

    public Address buildLastSecondaryIPAddress(){
            return this.SecondaryIPAddresses.get(SecondaryIPAddresses.size() - 1).build();
    }

    public Address buildMatchingSecondaryIPAddress(io.fabric8.docker.api.builder.Predicate<AddressBuilder> predicate){
            for (AddressBuilder item: SecondaryIPAddresses) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withSecondaryIPAddresses(List<Address> SecondaryIPAddresses){
            _visitables.removeAll(this.SecondaryIPAddresses);
            this.SecondaryIPAddresses.clear();
            if (SecondaryIPAddresses != null) {for (Address item : SecondaryIPAddresses){this.addToSecondaryIPAddresses(item);}} return (A) this;
    }

    public A withSecondaryIPAddresses(Address... SecondaryIPAddresses){
            this.SecondaryIPAddresses.clear(); if (SecondaryIPAddresses != null) {for (Address item :SecondaryIPAddresses){ this.addToSecondaryIPAddresses(item);}} return (A) this;
    }

    public Boolean hasSecondaryIPAddresses(){
            return SecondaryIPAddresses!= null && !SecondaryIPAddresses.isEmpty();
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddress(){
            return new SecondaryIPAddressesNestedImpl();
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> addNewSecondaryIPAddressLike(Address item){
            return new SecondaryIPAddressesNestedImpl(-1, item);
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> setNewSecondaryIPAddressLike(int index,Address item){
            return new SecondaryIPAddressesNestedImpl(index, item);
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> editSecondaryIPAddress(int index){
            if (SecondaryIPAddresses.size() <= index) throw new RuntimeException("Can't edit SecondaryIPAddresses. Index exceeds size.");
            return setNewSecondaryIPAddressLike(index, buildSecondaryIPAddress(index));
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> editFirstSecondaryIPAddress(){
            if (SecondaryIPAddresses.size() == 0) throw new RuntimeException("Can't edit first SecondaryIPAddresses. The list is empty.");
            return setNewSecondaryIPAddressLike(0, buildSecondaryIPAddress(0));
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> editLastSecondaryIPAddress(){
            int index = SecondaryIPAddresses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last SecondaryIPAddresses. The list is empty.");
            return setNewSecondaryIPAddressLike(index, buildSecondaryIPAddress(index));
    }

    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<A> editMatchingSecondaryIPAddress(io.fabric8.docker.api.builder.Predicate<AddressBuilder> predicate){
            int index = -1;
            for (int i=0;i<SecondaryIPAddresses.size();i++) { 
            if (predicate.apply(SecondaryIPAddresses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching SecondaryIPAddresses. No match found.");
            return setNewSecondaryIPAddressLike(index, buildSecondaryIPAddress(index));
    }

    public A addNewSecondaryIPAddress(String Addr,Integer PrefixLen){
            return (A)addToSecondaryIPAddresses(new Address(Addr, PrefixLen));
    }

    public A addToSecondaryIPv6Addresses(int index,Address item){
            AddressBuilder builder = new AddressBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.SecondaryIPv6Addresses.add(index >= 0 ? index : SecondaryIPv6Addresses.size(), builder); return (A)this;
    }

    public A setToSecondaryIPv6Addresses(int index,Address item){
            AddressBuilder builder = new AddressBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= SecondaryIPv6Addresses.size()) { SecondaryIPv6Addresses.add(builder); } else { SecondaryIPv6Addresses.set(index, builder);}
             return (A)this;
    }

    public A addToSecondaryIPv6Addresses(Address... items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.add(builder);this.SecondaryIPv6Addresses.add(builder);} return (A)this;
    }

    public A addAllToSecondaryIPv6Addresses(Collection<Address> items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.add(builder);this.SecondaryIPv6Addresses.add(builder);} return (A)this;
    }

    public A removeFromSecondaryIPv6Addresses(Address... items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.remove(builder);this.SecondaryIPv6Addresses.remove(builder);} return (A)this;
    }

    public A removeAllFromSecondaryIPv6Addresses(Collection<Address> items){
            for (Address item : items) {AddressBuilder builder = new AddressBuilder(item);_visitables.remove(builder);this.SecondaryIPv6Addresses.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSecondaryIPv6Addresses instead.
 */
@Deprecated public List<Address> getSecondaryIPv6Addresses(){
            return build(SecondaryIPv6Addresses);
    }

    public List<Address> buildSecondaryIPv6Addresses(){
            return build(SecondaryIPv6Addresses);
    }

    public Address buildSecondaryIPv6Address(int index){
            return this.SecondaryIPv6Addresses.get(index).build();
    }

    public Address buildFirstSecondaryIPv6Address(){
            return this.SecondaryIPv6Addresses.get(0).build();
    }

    public Address buildLastSecondaryIPv6Address(){
            return this.SecondaryIPv6Addresses.get(SecondaryIPv6Addresses.size() - 1).build();
    }

    public Address buildMatchingSecondaryIPv6Address(io.fabric8.docker.api.builder.Predicate<AddressBuilder> predicate){
            for (AddressBuilder item: SecondaryIPv6Addresses) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withSecondaryIPv6Addresses(List<Address> SecondaryIPv6Addresses){
            _visitables.removeAll(this.SecondaryIPv6Addresses);
            this.SecondaryIPv6Addresses.clear();
            if (SecondaryIPv6Addresses != null) {for (Address item : SecondaryIPv6Addresses){this.addToSecondaryIPv6Addresses(item);}} return (A) this;
    }

    public A withSecondaryIPv6Addresses(Address... SecondaryIPv6Addresses){
            this.SecondaryIPv6Addresses.clear(); if (SecondaryIPv6Addresses != null) {for (Address item :SecondaryIPv6Addresses){ this.addToSecondaryIPv6Addresses(item);}} return (A) this;
    }

    public Boolean hasSecondaryIPv6Addresses(){
            return SecondaryIPv6Addresses!= null && !SecondaryIPv6Addresses.isEmpty();
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6Address(){
            return new SecondaryIPv6AddressesNestedImpl();
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> addNewSecondaryIPv6AddressLike(Address item){
            return new SecondaryIPv6AddressesNestedImpl(-1, item);
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> setNewSecondaryIPv6AddressLike(int index,Address item){
            return new SecondaryIPv6AddressesNestedImpl(index, item);
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> editSecondaryIPv6Address(int index){
            if (SecondaryIPv6Addresses.size() <= index) throw new RuntimeException("Can't edit SecondaryIPv6Addresses. Index exceeds size.");
            return setNewSecondaryIPv6AddressLike(index, buildSecondaryIPv6Address(index));
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> editFirstSecondaryIPv6Address(){
            if (SecondaryIPv6Addresses.size() == 0) throw new RuntimeException("Can't edit first SecondaryIPv6Addresses. The list is empty.");
            return setNewSecondaryIPv6AddressLike(0, buildSecondaryIPv6Address(0));
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> editLastSecondaryIPv6Address(){
            int index = SecondaryIPv6Addresses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last SecondaryIPv6Addresses. The list is empty.");
            return setNewSecondaryIPv6AddressLike(index, buildSecondaryIPv6Address(index));
    }

    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<A> editMatchingSecondaryIPv6Address(io.fabric8.docker.api.builder.Predicate<AddressBuilder> predicate){
            int index = -1;
            for (int i=0;i<SecondaryIPv6Addresses.size();i++) { 
            if (predicate.apply(SecondaryIPv6Addresses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching SecondaryIPv6Addresses. No match found.");
            return setNewSecondaryIPv6AddressLike(index, buildSecondaryIPv6Address(index));
    }

    public A addNewSecondaryIPv6Address(String Addr,Integer PrefixLen){
            return (A)addToSecondaryIPv6Addresses(new Address(Addr, PrefixLen));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkSettingsBaseFluentImpl that = (NetworkSettingsBaseFluentImpl) o;
            if (Bridge != null ? !Bridge.equals(that.Bridge) :that.Bridge != null) return false;
            if (HairpinMode != null ? !HairpinMode.equals(that.HairpinMode) :that.HairpinMode != null) return false;
            if (LinkLocalIPv6Address != null ? !LinkLocalIPv6Address.equals(that.LinkLocalIPv6Address) :that.LinkLocalIPv6Address != null) return false;
            if (LinkLocalIPv6PrefixLen != null ? !LinkLocalIPv6PrefixLen.equals(that.LinkLocalIPv6PrefixLen) :that.LinkLocalIPv6PrefixLen != null) return false;
            if (Ports != null ? !Ports.equals(that.Ports) :that.Ports != null) return false;
            if (SandboxID != null ? !SandboxID.equals(that.SandboxID) :that.SandboxID != null) return false;
            if (SandboxKey != null ? !SandboxKey.equals(that.SandboxKey) :that.SandboxKey != null) return false;
            if (SecondaryIPAddresses != null ? !SecondaryIPAddresses.equals(that.SecondaryIPAddresses) :that.SecondaryIPAddresses != null) return false;
            if (SecondaryIPv6Addresses != null ? !SecondaryIPv6Addresses.equals(that.SecondaryIPv6Addresses) :that.SecondaryIPv6Addresses != null) return false;
            return true;
    }


    public class SecondaryIPAddressesNestedImpl<N> extends AddressFluentImpl<NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N>> implements NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final AddressBuilder builder;
        private final int index;
    
            SecondaryIPAddressesNestedImpl(int index,Address item){
                    this.index = index;
                    this.builder = new AddressBuilder(this, item);
            }
            SecondaryIPAddressesNestedImpl(){
                    this.index = -1;
                    this.builder = new AddressBuilder(this);
            }
    
    public N and(){
            return (N) NetworkSettingsBaseFluentImpl.this.setToSecondaryIPAddresses(index, builder.build());
    }
    public N endSecondaryIPAddress(){
            return and();
    }

}
    public class SecondaryIPv6AddressesNestedImpl<N> extends AddressFluentImpl<NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N>> implements NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N>,io.fabric8.docker.api.builder.Nested<N>{

            private final AddressBuilder builder;
        private final int index;
    
            SecondaryIPv6AddressesNestedImpl(int index,Address item){
                    this.index = index;
                    this.builder = new AddressBuilder(this, item);
            }
            SecondaryIPv6AddressesNestedImpl(){
                    this.index = -1;
                    this.builder = new AddressBuilder(this);
            }
    
    public N and(){
            return (N) NetworkSettingsBaseFluentImpl.this.setToSecondaryIPv6Addresses(index, builder.build());
    }
    public N endSecondaryIPv6Address(){
            return and();
    }

}


}
