package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkSettingsBuilder extends NetworkSettingsFluentImpl<NetworkSettingsBuilder> implements VisitableBuilder<NetworkSettings,NetworkSettingsBuilder>{

    NetworkSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSettingsBuilder(){
            this(true);
    }
    public NetworkSettingsBuilder(Boolean validationEnabled){
            this(new NetworkSettings(), validationEnabled);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkSettings(), validationEnabled);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,NetworkSettings instance){
            this(fluent, instance, true);
    }
    public NetworkSettingsBuilder(NetworkSettingsFluent<?> fluent,NetworkSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); 
            fluent.withNetworkSettingsBase(instance.getNetworkSettingsBase()); 
            fluent.withNetworks(instance.getNetworks()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkSettingsBuilder(NetworkSettings instance){
            this(instance,true);
    }
    public NetworkSettingsBuilder(NetworkSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); 
            this.withNetworkSettingsBase(instance.getNetworkSettingsBase()); 
            this.withNetworks(instance.getNetworks()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableNetworkSettings build(){
            EditableNetworkSettings buildable = new EditableNetworkSettings(fluent.getDefaultNetworkSettings(),fluent.getNetworkSettingsBase(),fluent.getNetworks());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkSettingsBuilder that = (NetworkSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
