package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PortBindingBuilder extends PortBindingFluentImpl<PortBindingBuilder> implements VisitableBuilder<PortBinding,PortBindingBuilder>{

    PortBindingFluent<?> fluent;
    Boolean validationEnabled;

    public PortBindingBuilder(){
            this(true);
    }
    public PortBindingBuilder(Boolean validationEnabled){
            this(new PortBinding(), validationEnabled);
    }
    public PortBindingBuilder(PortBindingFluent<?> fluent){
            this(fluent, true);
    }
    public PortBindingBuilder(PortBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PortBinding(), validationEnabled);
    }
    public PortBindingBuilder(PortBindingFluent<?> fluent,PortBinding instance){
            this(fluent, instance, true);
    }
    public PortBindingBuilder(PortBindingFluent<?> fluent,PortBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHostIp(instance.getHostIp()); 
            fluent.withHostPort(instance.getHostPort()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortBindingBuilder(PortBinding instance){
            this(instance,true);
    }
    public PortBindingBuilder(PortBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHostIp(instance.getHostIp()); 
            this.withHostPort(instance.getHostPort()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditablePortBinding build(){
            EditablePortBinding buildable = new EditablePortBinding(fluent.getHostIp(),fluent.getHostPort());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortBindingBuilder that = (PortBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
