package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SearchResultsBuilder extends SearchResultsFluentImpl<SearchResultsBuilder> implements VisitableBuilder<SearchResults,SearchResultsBuilder>{

    SearchResultsFluent<?> fluent;
    Boolean validationEnabled;

    public SearchResultsBuilder(){
            this(true);
    }
    public SearchResultsBuilder(Boolean validationEnabled){
            this(new SearchResults(), validationEnabled);
    }
    public SearchResultsBuilder(SearchResultsFluent<?> fluent){
            this(fluent, true);
    }
    public SearchResultsBuilder(SearchResultsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SearchResults(), validationEnabled);
    }
    public SearchResultsBuilder(SearchResultsFluent<?> fluent,SearchResults instance){
            this(fluent, instance, true);
    }
    public SearchResultsBuilder(SearchResultsFluent<?> fluent,SearchResults instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNumResults(instance.getNumResults()); 
            fluent.withQuery(instance.getQuery()); 
            fluent.withResults(instance.getResults()); 
            this.validationEnabled = validationEnabled; 
    }
    public SearchResultsBuilder(SearchResults instance){
            this(instance,true);
    }
    public SearchResultsBuilder(SearchResults instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNumResults(instance.getNumResults()); 
            this.withQuery(instance.getQuery()); 
            this.withResults(instance.getResults()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.docker.api.model.EditableSearchResults build(){
            EditableSearchResults buildable = new EditableSearchResults(fluent.getNumResults(),fluent.getQuery(),fluent.getResults());
            io.fabric8.docker.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SearchResultsBuilder that = (SearchResultsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
